/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api.bullets;

import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCasingType;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletComponent;
import pl.pabilo8.immersiveintelligence.api.bullets.IBulletCoreType;
import pl.pabilo8.immersiveintelligence.client.model.IBulletModel;

public class BulletRegistry {
    public static BulletRegistry INSTANCE = new BulletRegistry();
    public HashMap<String, IBulletComponent> registeredComponents = new HashMap();
    public HashMap<String, IBulletCoreType> registeredBulletCores = new HashMap();
    public HashMap<String, IBulletCasingType> registeredCasings = new HashMap();
    public HashMap<String, IBulletModel> registeredModels = new HashMap();

    public boolean registerComponent(IBulletComponent component, String name) {
        if (!this.registeredComponents.containsKey(name)) {
            this.registeredComponents.put(name, component);
            return true;
        }
        return false;
    }

    public boolean registerBulletCore(IBulletCoreType core, String name) {
        if (!this.registeredBulletCores.containsKey(name)) {
            this.registeredBulletCores.put(name, core);
            return true;
        }
        return false;
    }

    public boolean registerCasing(IBulletCasingType casing, String name) {
        if (!this.registeredCasings.containsKey(name)) {
            this.registeredCasings.put(name, casing);
            if (FMLCommonHandler.instance().getSide().isClient()) {
                try {
                    this.registeredModels.put(casing.getName(), casing.getModel().newInstance());
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public IBulletComponent getComponent(String name) {
        return this.registeredComponents.get(name);
    }

    @Nullable
    public IBulletCasingType getCasing(String name) {
        return this.registeredCasings.get(name);
    }

    @Nullable
    public IBulletCoreType getCore(String name) {
        return this.registeredBulletCores.get(name);
    }

    public static enum EnumComponentRole implements IStringSerializable
    {
        SHRAPNEL,
        PIERCING,
        EXPLOSIVE,
        INCENDIARY,
        TRACER,
        FLARE,
        CHEMICAL,
        SPECIAL;


        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

