/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api;

import blusunrize.immersiveengineering.api.DimensionBlockPos;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import pl.pabilo8.immersiveintelligence.api.data.DataPacket;
import pl.pabilo8.immersiveintelligence.api.data.IDataConnector;
import pl.pabilo8.immersiveintelligence.api.utils.IWrench;
import pl.pabilo8.immersiveintelligence.common.items.ItemIIBase;

public class Utils {
    public static double getDistanceBetweenPos(BlockPos pos1, BlockPos pos2, boolean center) {
        double deltaX = (double)pos1.func_177958_n() + (center ? 0.0 : 0.5) - ((double)pos2.func_177958_n() + (center ? 0.0 : 0.5));
        double deltaY = (double)pos1.func_177956_o() + (center ? 0.0 : 0.5) - ((double)pos2.func_177956_o() + (center ? 0.0 : 0.5));
        double deltaZ = (double)pos1.func_177952_p() + (center ? 0.0 : 0.5) - ((double)pos2.func_177952_p() + (center ? 0.0 : 0.5));
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    @Nullable
    public static IDataConnector findConnectorFacing(BlockPos pos, World world, EnumFacing facing) {
        IEBlockInterfaces.IDirectionalTile t;
        BlockPos newpos = pos.func_177972_a(facing);
        if (world.func_175667_e(newpos) && world.func_175625_s(newpos) instanceof IDataConnector && world.func_175625_s(newpos) instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)world.func_175625_s(newpos)).getFacing() == facing.func_176734_d()) {
            return (IDataConnector)world.func_175625_s(newpos);
        }
        return null;
    }

    @Nullable
    public static IDataConnector findConnectorAround(BlockPos pos, World world) {
        IEBlockInterfaces.IDirectionalTile t;
        BlockPos newpos = pos.func_177982_a(1, 0, 0);
        if (world.func_175667_e(newpos) && world.func_175625_s(newpos) instanceof IDataConnector && world.func_175625_s(newpos) instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)world.func_175625_s(newpos)).getFacing() == EnumFacing.WEST) {
            return (IDataConnector)world.func_175625_s(newpos);
        }
        newpos = pos.func_177982_a(-1, 0, 0);
        if (world.func_175667_e(newpos) && world.func_175625_s(newpos) instanceof IDataConnector && world.func_175625_s(newpos) instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)world.func_175625_s(newpos)).getFacing() == EnumFacing.EAST) {
            return (IDataConnector)world.func_175625_s(newpos);
        }
        newpos = pos.func_177982_a(0, 0, 1);
        if (world.func_175667_e(newpos) && world.func_175625_s(newpos) instanceof IDataConnector && world.func_175625_s(newpos) instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)world.func_175625_s(newpos)).getFacing() == EnumFacing.NORTH) {
            return (IDataConnector)world.func_175625_s(newpos);
        }
        newpos = pos.func_177982_a(0, 0, -1);
        if (world.func_175667_e(newpos) && world.func_175625_s(newpos) instanceof IDataConnector && world.func_175625_s(newpos) instanceof IEBlockInterfaces.IDirectionalTile && (t = (IEBlockInterfaces.IDirectionalTile)world.func_175625_s(newpos)).getFacing() == EnumFacing.SOUTH) {
            return (IDataConnector)world.func_175625_s(newpos);
        }
        return null;
    }

    public static NetworkRegistry.TargetPoint targetPointFromPos(BlockPos pos, World world, int range) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromEntity(Entity entity, int range) {
        return new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.getDimension(), (double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), (double)range);
    }

    public static NetworkRegistry.TargetPoint targetPointFromTile(TileEntity tile, int range) {
        return new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), (double)range);
    }

    public static double root(double num, double root) {
        double d = Math.pow(num, 1.0 / root);
        long rounded = Math.round(d);
        return Math.abs((double)rounded - d) < 1.0E-14 ? (double)rounded : d;
    }

    public static int[] rgbToCmyk(int red, int green, int blue) {
        return new int[]{255 - red, 255 - green, 255 - blue, 255 - Math.min(red, Math.max(green, blue))};
    }

    public static int[] cmykToRgb(int cyan, int magenta, int yellow, int black) {
        return new int[]{Math.min(255 - black, 255 - cyan), Math.min(255 - black, 255 - magenta), Math.min(255 - black, 255 - yellow)};
    }

    public static boolean isPointInRectangle(double x, double y, double xx, double yy, double px, double py) {
        return px >= x && px < xx && py >= y && py < yy;
    }

    public static boolean handleBucketTankInteraction(FluidTank[] tanks, NonNullList<ItemStack> inventory, int bucketInputSlot, int bucketOutputSlot, int tank) {
        if (((ItemStack)inventory.get(bucketInputSlot)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && ((IFluidHandlerItem)((ItemStack)inventory.get(bucketInputSlot)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties()[0].getContents() != null) {
            int amount_prev = tanks[tank].getFluidAmount();
            ItemStack emptyContainer = blusunrize.immersiveengineering.common.util.Utils.drainFluidContainer((IFluidHandler)tanks[tank], (ItemStack)((ItemStack)inventory.get(bucketInputSlot)), (ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), null);
            if (amount_prev != tanks[tank].getFluidAmount()) {
                if (!((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)inventory.get(bucketOutputSlot)), (ItemStack)emptyContainer, (boolean)true)) {
                    ((ItemStack)inventory.get(bucketOutputSlot)).func_190917_f(emptyContainer.func_190916_E());
                } else if (((ItemStack)inventory.get(bucketOutputSlot)).func_190926_b()) {
                    inventory.set(bucketOutputSlot, (Object)emptyContainer.func_77946_l());
                }
                ((ItemStack)inventory.get(bucketInputSlot)).func_190918_g(1);
                if (((ItemStack)inventory.get(bucketInputSlot)).func_190916_E() <= 0) {
                    inventory.set(bucketInputSlot, (Object)ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean outputFluidToTank(FluidTank tank, int amount, BlockPos pos, World world, EnumFacing side) {
        if (tank.getFluidAmount() > 0) {
            int accepted;
            FluidStack out = blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)tank.getFluid(), (int)Math.min(tank.getFluidAmount(), 80), (boolean)false);
            IFluidHandler output = FluidUtil.getFluidHandler((World)world, (BlockPos)pos.func_177972_a(side), (EnumFacing)side);
            if (output != null && (accepted = output.fill(out, false)) > 0) {
                int drained = output.fill(blusunrize.immersiveengineering.common.util.Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                tank.drain(drained, true);
                return true;
            }
        }
        return false;
    }

    public static Vec3d offsetPosDirection(float offset, double yaw, double pitch) {
        double yy = MathHelper.func_76126_a((float)((float)pitch)) * offset;
        double true_offset = MathHelper.func_76134_b((float)((float)pitch)) * offset;
        double xx = (double)MathHelper.func_76126_a((float)((float)yaw)) * true_offset;
        double zz = (double)MathHelper.func_76134_b((float)((float)yaw)) * true_offset;
        Vec3d vec = new Vec3d(xx, yy, zz);
        return vec;
    }

    public static float[] rgbIntToRGB(int rgb) {
        float r = (float)(rgb / 256 / 256 % 256) / 255.0f;
        float g = (float)(rgb / 256 % 256) / 255.0f;
        float b = (float)(rgb % 256) / 255.0f;
        return new float[]{r, g, b};
    }

    public static char cycleDataPacketChars(char current, boolean forward, boolean hasEmpty) {
        if (hasEmpty) {
            if (current == ' ') {
                current = forward ? DataPacket.varCharacters[0] : DataPacket.varCharacters[DataPacket.varCharacters.length - 1];
            } else {
                int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
                current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length || current_char < 0 ? (char)32 : DataPacket.varCharacters[current_char];
            }
        } else {
            int current_char = ArrayUtils.indexOf((char[])DataPacket.varCharacters, (char)current);
            current = (current_char += forward ? 1 : -1) >= DataPacket.varCharacters.length ? DataPacket.varCharacters[0] : (current_char < 0 ? DataPacket.varCharacters[DataPacket.varCharacters.length - 1] : DataPacket.varCharacters[current_char]);
        }
        return current;
    }

    public static float calculateBallisticAngle(double distance, double height, float force, double gravity, double drag) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (gravity == 0.0) {
            return 90.0f - (float)(Math.atan(height / distance) * 180.0 / Math.PI);
        }
        for (double i = 0.031415926535897934; i < 1.5707963267948966; i += 0.01) {
            double motionX = MathHelper.func_76134_b((float)((float)i)) * force;
            double posX = 0.0;
            double posY = 0.0;
            for (double motionY = (double)(MathHelper.func_76126_a((float)((float)i)) * force); posY > height || motionY > 0.0; motionY *= drag) {
                posX += motionX;
                posY += motionY;
                motionY -= gravity;
                motionX *= drag;
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    public static boolean isAdvancedHammer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_ADVANCED_HAMMER");
    }

    public static boolean isAABBContained(@Nonnull AxisAlignedBB compared, @Nonnull AxisAlignedBB comparedTo) {
        Vec3d c0 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72339_c);
        Vec3d c1 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72339_c);
        Vec3d c2 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72339_c);
        Vec3d c3 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72339_c);
        Vec3d c4 = new Vec3d(compared.field_72340_a, compared.field_72338_b, compared.field_72334_f);
        Vec3d c5 = new Vec3d(compared.field_72336_d, compared.field_72338_b, compared.field_72334_f);
        Vec3d c6 = new Vec3d(compared.field_72340_a, compared.field_72337_e, compared.field_72334_f);
        Vec3d c7 = new Vec3d(compared.field_72336_d, compared.field_72337_e, compared.field_72334_f);
        AxisAlignedBB comp2 = comparedTo.func_186662_g((double)0.1f);
        return comp2.func_72318_a(c0) && comp2.func_72318_a(c1) && comp2.func_72318_a(c2) && comp2.func_72318_a(c3) && comp2.func_72318_a(c4) && comp2.func_72318_a(c5) && comp2.func_72318_a(c6) && comp2.func_72318_a(c7);
    }

    public static String toCamelCase(String string, boolean startSmall) {
        String[] all;
        StringBuilder result = new StringBuilder();
        for (String s : all = string.split("_")) {
            result.append(Character.toUpperCase(s.charAt(0)));
            result.append(s.substring(1));
        }
        if (startSmall) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static void unlockIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "code_trigger");
            }
        }
    }

    public static boolean hasUnlockedIIAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveintelligence", name));
            if (advancement != null) {
                return advancements.func_192747_a(advancement).func_192105_a();
            }
        }
        return false;
    }

    public static boolean isWrench(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_WRENCH") && stack.func_77973_b() instanceof IWrench;
    }

    public static boolean isTachometer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("TOOL_TACHOMETER");
    }

    public static boolean isCrowbar(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("II_CROWBAR");
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCentered(FontRenderer fontRenderer, String string, int x, int y, int w, int h, int colour) {
        fontRenderer.func_78276_b(string, x + w / 2 - fontRenderer.func_78256_a(string) / 2, y + h, colour);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawStringCenteredScaled(FontRenderer fontRenderer, String string, int x, int y, int w, int h, float scale, int colour) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + ((float)(w / 2) - (float)fontRenderer.func_78256_a(string) * scale / 2.0f)), (float)(y + h), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_78276_b(string, 0, 0, 14260039);
        GlStateManager.func_179121_F();
    }

    public static int cycleInt(boolean forward, int current, int min, int max) {
        if ((current += forward ? 1 : -1) > max) {
            return min;
        }
        if (current < min) {
            return max;
        }
        return current;
    }

    public static boolean compareBlockstateOredict(IBlockState state, String oreName) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return blusunrize.immersiveengineering.common.util.Utils.compareToOreName((ItemStack)stack, (String)oreName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void tesselateBlockBreak(Tessellator tessellatorIn, WorldClient world, DimensionBlockPos blockpos, Float value, float partialTicks) {
        IBlockState iblockstate;
        boolean hasBreak;
        BufferBuilder worldRendererIn = tessellatorIn.func_178180_c();
        EntityPlayerSP player = ClientUtils.mc().field_71439_g;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        int progress = 9 - (int)MathHelper.func_76131_a((float)(value.floatValue() * 10.0f), (float)0.0f, (float)10.0f);
        if (progress < 0) {
            return;
        }
        renderEngine.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)1);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179141_d();
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        worldRendererIn.func_178969_c(-d0, -d1, -d2);
        Block block = world.func_180495_p((BlockPos)blockpos).func_177230_c();
        TileEntity te = world.func_175625_s((BlockPos)blockpos);
        boolean bl = hasBreak = block instanceof BlockChest || block instanceof BlockEnderChest || block instanceof BlockSign || block instanceof BlockSkull;
        if (!hasBreak) {
            boolean bl2 = hasBreak = te != null && te.canRenderBreaking();
        }
        if (!hasBreak && (iblockstate = world.func_180495_p((BlockPos)blockpos)).func_185904_a() != Material.field_151579_a) {
            TextureAtlasSprite textureatlassprite = ClientUtils.destroyBlockIcons[progress];
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            blockrendererdispatcher.func_175020_a(iblockstate, (BlockPos)blockpos, textureatlassprite, (IBlockAccess)world);
        }
        tessellatorIn.func_78381_a();
        worldRendererIn.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179120_a((int)768, (int)774, (int)1, (int)1);
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static ItemStack getItemWithMetaName(ItemIIBase item, String name) {
        return new ItemStack((Item)item, 1, item.getMetaBySubname(name));
    }

    public static ItemStack getItemWithMetaName(ItemIIBase item, String name, int count) {
        ItemStack stack = Utils.getItemWithMetaName(item, name);
        stack.func_190920_e(count);
        return stack;
    }
}

