/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.api;

import java.util.HashMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class LighterFuelHandler {
    static HashMap<Fluid, Integer> allowedFluids = new HashMap();

    public static boolean isValidFuel(FluidStack stack) {
        return stack != null && allowedFluids.containsKey(stack.getFluid());
    }

    public static int getBurnQuantity(FluidStack stack) {
        if (LighterFuelHandler.isValidFuel(stack)) {
            return allowedFluids.get(stack.getFluid());
        }
        return Integer.MAX_VALUE;
    }

    public static void setBurnQuantity(Fluid fluid, int amount) {
        if (allowedFluids.containsKey(fluid)) {
            allowedFluids.replace(fluid, amount);
        }
    }

    public static void addFuel(Fluid fluid, int amount) {
        if (!allowedFluids.containsKey(fluid)) {
            allowedFluids.put(fluid, amount);
        }
    }

    public static void removeFuel(Fluid fluid) {
        allowedFluids.remove(fluid);
    }
}

