/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence;

import blusunrize.immersiveengineering.common.Config;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Mod;
import pl.pabilo8.immersiveintelligence.common.world.IIWorldGen;

@Mod.EventBusSubscriber
public class Config {
    public static final String GEARS = "Gears: Copper, Brass, Iron, Steel, Tungsten";
    public static final String BELTS = "Belts: Cloth, Steel";

    @net.minecraftforge.common.config.Config(modid="immersiveintelligence")
    public static class IIConfig {
        @Config.SubConfig
        public static Ores ores;
        @Config.SubConfig
        public static Machines machines;
        @Config.SubConfig
        public static MechanicalDevices mechanicalDevices;
        @Config.SubConfig
        public static Tools tools;
        @Config.SubConfig
        public static Weapons weapons;
        @Config.SubConfig
        public static Wires wires;
        @Config.Comment(value={"The maximum frequency for basic radios."})
        public static int radioBasicMaxFrequency;
        @Config.Comment(value={"The maximum frequency for advanced radios."})
        public static int radioAdvancedMaxFrequency;
        @Config.Comment(value={"Should RPM be counted in real time or ingame time"})
        public static boolean rpmRealTime;

        static {
            radioBasicMaxFrequency = 32;
            radioAdvancedMaxFrequency = 256;
            rpmRealTime = true;
        }

        public static class MechanicalDevices {
            @Config.Comment(value={"Minimal RPM required by a gear to work.", "Gears: Copper, Brass, Iron, Steel, Tungsten"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] gear_min_rpm = new int[]{10, 40, 120, 360, 720};
            @Config.Comment(value={"Gears will break if RPM is higher than this value.", "Gears: Copper, Brass, Iron, Steel, Tungsten"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] gear_max_rpm = new int[]{60, 200, 240, 800, 2400};
            @Config.Comment(value={"Gears will break if Torque is higher than this value.", "Gears: Copper, Brass, Iron, Steel, Tungsten"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] gear_max_torque = new int[]{6, 24, 32, 256, 512};
            @Config.Comment(value={"Durability of the gear (decreases by 1 every 20 ticks (1 second)).", "Gears: Copper, Brass, Iron, Steel, Tungsten"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] gear_max_durability = new int[]{2400, 4800, 7200, 14400, 28800};
            @Config.Comment(value={"Belts will break if RPM is higher than this value.", "Belts: Cloth, Steel"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] belt_max_rpm = new int[]{960, 3600};
            @Config.Comment(value={"Belts will break if Torque is higher than this value.", "Belts: Cloth, Steel"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] belt_max_torque = new int[]{48, 640};
            @Config.Comment(value={"Torque loss, later multiplied by belt length.", "Belts: Cloth, Steel"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float[] belt_torque_loss = new float[]{0.05f, 0.1f};
            @Config.Comment(value={"Max length of the belt, works exactly like wires (measured in blocks).", "Belts: Cloth, Steel"})
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] belt_length = new int[]{8, 16};
            @Config.Comment(value={"Immersive Flux to Rotary Flux conversion ratio (default 1 RoF = 1 RF)."})
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float rof_conversion_ratio = 1.0f;
            @Config.Comment(value={"Default torque, used as a fallback, when IE rotational device is not recognised."})
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float dynamo_default_torque = 2.0f;
            @Config.Comment(value={"Torque multiplier for the windmill."})
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float dynamo_windmill_torque = 8.0f;
            @Config.Comment(value={"Default torque, used as a fallback, when IE rotational device is not recognised."})
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float dynamo_watermill_torque = 12.0f;
        }

        public static class Wires {
            @Config.Comment(value={"The RGB color of the data wire."})
            public static int dataWireColouration = 11784662;
            @Config.Comment(value={"The maximum length of a single data wire."})
            public static int dataWireLength = 24;
        }

        public static class Weapons {
            @Config.SubConfig
            public static Machinegun machinegun;

            public static class Machinegun {
                @Config.Comment(value={"Time required to reload a clip in MG."})
                public static int clipReloadTime = 35;
                @Config.Comment(value={"Time required to fire a single bullet in MG."})
                public static int bulletFireTime = 4;
                @Config.Comment(value={"Time required to set up the MG (in ticks)."})
                public static int setupTime = 100;
                @Config.Comment(value={"Max scatter of heat, higher values will force the player to wait until the gun cools down."})
                public static int maxOverheat = 100;
                @Config.Comment(value={"Amount of horizontal recoil after taking a shot."})
                public static float recoilHorizontal = 4.0f;
                @Config.Comment(value={"Amount of vertical recoil after taking a shot."})
                public static float recoilVertical = 4.0f;
                @Config.Comment(value={"Fire rate multiplier when heavy barrel is mouted on mg."})
                public static float heavyBarrelFireRateMultiplier = 0.25f;
                @Config.Comment(value={"Horizontal recoil after taking a shot with heavy barrel mounted."})
                public static float recoilHBHorizontal = 1.25f;
                @Config.Comment(value={"Vertical recoil after taking a shot with heavy barrel mounted."})
                public static float recoilHBVertical = 1.25f;
                @Config.Comment(value={"Water usage when water cooling upgrade is mounted on mg (in mB)."})
                public static int waterCoolingFluidUsage = 40;
                @Config.Comment(value={"Fire rate multiplier when water cooling upgrade is mouted on mg."})
                public static float waterCoolingFireRateMultiplier = 1.5f;
                @Config.Comment(value={"Setup time multiplier when the precise bipod is mouted on mg."})
                public static float preciseBipodSetupTimeMultiplier = 2.0f;
                @Config.Comment(value={"Recoil multiplier when the precise bipod is mouted on mg."})
                public static float preciseBipodRecoilMultiplier = 0.25f;
                @Config.Comment(value={"Setup time multiplier when the hasty bipod is mouted on mg."})
                public static float hastyBipodSetupTimeMultiplier = 0.5f;
                @Config.Comment(value={"Recoil multiplier when the hasty bipod is mouted on mg."})
                public static float hastyBipodRecoilMultiplier = 1.5f;
                @Config.Comment(value={"Horizontal recoil multiplier when the double magazine upgrade is mouted on mg."})
                public static float recoilSecondMagazine = 1.65f;
                @Config.Comment(value={"Setup time multiplier when the belt fed loader upgrade is mouted on mg."})
                public static float beltFedLoaderSetupTimeMultiplier = 0.5f;
                @Config.Comment(value={"Infrared scope energy usage per tick"})
                public static int infraredScopeEnergyUsage = 15;
                @Config.Comment(value={"Max zoom of a machinegun with a scope mounted (in Blu's Unit of Distance Measurement\u00e2\u201e\u02d8)."})
                @Config.RequiresMcRestart
                @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
                public static float[] machinegun_scope_max_zoom = new float[]{0.05f, 0.0833f, 0.15f};
            }
        }

        public static class Machines {
            @Config.SubConfig
            public static RadioStation radioStation;
            @Config.SubConfig
            public static DataInputMachine dataInputMachine;
            @Config.SubConfig
            public static ArithmeticLogicMachine arithmeticLogicMachine;
            @Config.SubConfig
            public static PrintingPress printingPress;
            @Config.SubConfig
            public static ChemicalBath chemicalBath;
            @Config.SubConfig
            public static Electrolyzer electrolyzer;
            @Config.SubConfig
            public static PrecissionAssembler precissionAssembler;
            @Config.SubConfig
            public static ArtilleryHowitzer artilleryHowitzer;
            @Config.SubConfig
            public static AmmunitionFactory ammunitionFactory;
            @Config.SubConfig
            public static BallisticComputer ballisticComputer;
            @Config.SubConfig
            public static MissileSilo missileSilo;
            @Config.SubConfig
            public static ConveyorScanner conveyor_scanner;
            @Config.SubConfig
            public static Inserter inserter;
            @Config.SubConfig
            public static AdvancedInserter advanced_inserter;
            @Config.SubConfig
            public static FluidInserter fluid_inserter;
            @Config.SubConfig
            public static AdvancedFluidInserter advanced_fluid_inserter;
            @Config.SubConfig
            public static ChemicalDispenser chemical_dispenser;
            @Config.SubConfig
            public static SmallDataBuffer small_data_buffer;
            @Config.SubConfig
            public static SkycrateStation skycrate_station;
            @Config.SubConfig
            public static Packer packer;
            @Config.SubConfig
            public static RedstoneInterface redstoneInterface;
            @Config.SubConfig
            public static Sawmill sawmill;

            public static class SmallDataBuffer {
                @Config.Comment(value={"Amount of data packets the machine can store."})
                public static int packetCapacity = 4;
            }

            public static class ChemicalDispenser {
                @Config.Comment(value={"Energy capacity of the chemical dispenser."})
                public static int energyCapacity = 2048;
                @Config.Comment(value={"Energy usage of the chemical dispenser per one shot."})
                public static int energyUsage = 128;
                @Config.Comment(value={"How long does it take for the chemical dispenser to rotate 45 degrees horizontally (in ticks)"})
                public static int rotateHTime = 240;
                @Config.Comment(value={"How long does it take for the chemical dispenser to rotate 45 degrees vertically (in ticks)"})
                public static int rotateVTime = 180;
            }

            public static class AdvancedFluidInserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 4096;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 256;
                @Config.Comment(value={"Max fluid output (in milibuckets per tick)"})
                public static int maxOutput = 240;
            }

            public static class FluidInserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 2048;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 128;
                @Config.Comment(value={"Max fluid output (in milibuckets per tick)"})
                public static int maxOutput = 500;
            }

            public static class AdvancedInserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 4096;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 256;
                @Config.Comment(value={"How long does it take for the inserter to pick up an item (in ticks)"})
                public static int grabTime = 10;
                @Config.Comment(value={"How long does it take for the inserter to rotate 90 degrees (in ticks)"})
                public static int rotateTime = 5;
            }

            public static class Inserter {
                @Config.Comment(value={"Energy capacity of the inserter."})
                public static int energyCapacity = 2048;
                @Config.Comment(value={"Energy usage of the inserter per item taken."})
                public static int energyUsage = 128;
                @Config.Comment(value={"How long does it take for the inserter to pick up an item (in ticks)"})
                public static int grabTime = 20;
                @Config.Comment(value={"How long does it take for the inserter to rotate 90 degrees (in ticks)"})
                public static int rotateTime = 10;
            }

            public static class AmmunitionFactory {
                @Config.Comment(value={"Energy capacity of the ammunition factory (in IF)."})
                public static int energyCapacity = 32000;
                @Config.Comment(value={"Energy usage per one tick of the bullet core making process (in IF)."})
                public static int energyUsageCore = 120;
                @Config.Comment(value={"Energy usage per one tick of putting a core into a casing (in IF)."})
                public static int energyUsageCasing = 120;
                @Config.Comment(value={"Energy usage per one tick of putting gunpowder into a casing (in IF)."})
                public static int energyUsageGunpowder = 120;
                @Config.Comment(value={"Energy usage per one tick of the paint conveyor process (in IF)."})
                public static int energyUsagePaint = 120;
                @Config.Comment(value={"Component capacity of the ammunition factory (in Pabilo8's Unit of Measurement\u00e2\u201e\u02d8)."})
                public static int componentCapacity = 48;
                @Config.Comment(value={"Max intake of the component per 20 ticks (in Pabilo8's Unit of Measurement\u00e2\u201e\u02d8)."})
                public static int componentIntake = 6;
                @Config.Comment(value={"Paint usage per one bullet making process (in mB)."})
                public static int paintUsage = 120;
                @Config.Comment(value={"How long does it take to move a bullet to the next slot (in ticks)."})
                public static int conveyorTime = 50;
                @Config.Comment(value={"Duration of filling a casing with gunpowder (in ticks)."})
                public static int gunpowderTime = 120;
                @Config.Comment(value={"Duration of filling a core with components (in ticks)."})
                public static int coreTime = 160;
                @Config.Comment(value={"Duration of one bullet making process (in ticks)."})
                public static int casingTime = 120;
                @Config.Comment(value={"Duration of the bullet painting process (in ticks)."})
                public static int paintTime = 180;
            }

            public static class MissileSilo {
                @Config.Comment(value={"Energy capacity of the missile silo (per one block of height)."})
                public static int energyCapacity = 2500000;
            }

            public static class ConveyorScanner {
                @Config.Comment(value={"Energy capacity of the scanning conveyor."})
                public static int energyCapacity = 8000;
                @Config.Comment(value={"Energy usage when scanning an ItemStack."})
                public static int energyUsage = 128;
            }

            public static class BallisticComputer {
                @Config.Comment(value={"Energy capacity of the ballistic computer."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy capacity of the ballistic computer."})
                public static int energyUsage = 16000;
            }

            public static class ArtilleryHowitzer {
                @Config.Comment(value={"Energy capacity of the artillery howitzer."})
                public static int energyCapacity = 1000000;
                @Config.Comment(value={"Energy usage when moving / rotating the platform."})
                public static int energyUsagePlatform = 1620;
                @Config.Comment(value={"Energy usage when loading / unloading a shell."})
                public static int energyUsageLoader = 3192;
                @Config.Comment(value={"Time needed for the platform to ascend/descend (in ticks."})
                public static int platformTime = 240;
                @Config.Comment(value={"Time needed for the howitzer to fire (in ticks."})
                public static int fireTime = 35;
                @Config.Comment(value={"How long does it take for the howitzer to rotate 90 degrees (in ticks)"})
                public static int rotateTime = 160;
                @Config.Comment(value={"How long does it take for the howitzer to load a shell (in ticks)"})
                public static int loadTime = 140;
                @Config.Comment(value={"How long does it take for the howitzer to move the shell by one item slot using conveyor (in ticks)"})
                public static int conveyorTime = 40;
            }

            public static class PrecissionAssembler {
                @Config.Comment(value={"Energy capacity of the chemical bath."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Hatch opening (or closing) time (in ticks)"})
                public static int hatchTime = 40;
            }

            public static class Electrolyzer {
                @Config.Comment(value={"Energy capacity of the electrolyzer."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Fluid capacity of the electrolyzer."})
                public static int fluidCapacity = 12000;
            }

            public static class ChemicalBath {
                @Config.Comment(value={"Energy capacity of the chemical bath."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Fluid capacity of the chemical bath."})
                public static int fluidCapacity = 24000;
            }

            public static class PrintingPress {
                @Config.Comment(value={"Energy capacity of the printing press."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy usage of the printing press per page printed."})
                public static int energyUsage = 512;
                @Config.Comment(value={"Page printing duration (in ticks)."})
                public static int printTime = 90;
                @Config.Comment(value={"Ink used per character printed (mB)."})
                public static int printInkUsage = 8;
            }

            public static class ArithmeticLogicMachine {
                @Config.Comment(value={"Energy capacity of the arithmetic-logic machine."})
                public static int energyCapacity = 24000;
                @Config.Comment(value={"Energy usage of the arithmetic-logic machine per circuit."})
                public static int energyUsage = 2048;
            }

            public static class DataInputMachine {
                @Config.Comment(value={"Energy capacity of the data input machine."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Energy usage when sending a signal."})
                public static int energyUsage = 2048;
                @Config.Comment(value={"Energy per step of punching a tape (1/60 of the full energy needed)."})
                public static int energyUsagePunchtape = 128;
                @Config.Comment(value={"Duration of tape punching process in ticks (1 tick = 1/20 Second)."})
                public static int timePunchtapeProduction = 160;
            }

            public static class RadioStation {
                @Config.Comment(value={"Energy capacity of the radio station."})
                public static int energyCapacity = 32000;
                @Config.Comment(value={"Energy usage when sending a signal."})
                public static int energyUsage = 8192;
                @Config.Comment(value={"Energy usage when a radio station is working."})
                public static int energyUsageIdle = 512;
                @Config.Comment(value={"Range of the radio station (in which the signals can be received) in blocks from center (radius)."})
                public static int radioRange = 64;
                @Config.Comment(value={"How much the range decreases when there is bad weather (rain, snow) ( 0 - full range, 0.5 - half range, 1 - no range, etc.)"})
                public static float weatherHarshness = 0.5f;
            }

            public static class Sawmill {
                @Config.Comment(value={"Rotations per minute required for the Sawmill to Work."})
                public static int rpmMin = 20;
                @Config.Comment(value={"Max rotations per minute (will break if over)."})
                public static int rpmBreakingMax = 160;
                @Config.Comment(value={"Torque required for the Sawmill to Work."})
                public static int torqueMin = 6;
                @Config.Comment(value={"Max Torque (will break if over)."})
                public static int torqueBreakingMax = 140;
            }

            public static class SkycrateStation {
                @Config.Comment(value={"Rotations per minute required for the Skycrate Station to Work."})
                public static int rpmMin = 20;
                @Config.Comment(value={"Max rotations per minute (reaching over this level doesn't change effectiveness)."})
                public static int rpmEffectiveMax = 80;
                @Config.Comment(value={"Max rotations per minute (will break if over)."})
                public static int rpmBreakingMax = 240;
                @Config.Comment(value={"Torque required for the Skycrate Station to Work."})
                public static int torqueMin = 4;
                @Config.Comment(value={"Max Torque (reaching over this level doesn't change effectiveness)."})
                public static int torqueEffectiveMax = 8;
                @Config.Comment(value={"Max Torque (will break if over)."})
                public static int torqueBreakingMax = 256;
                @Config.Comment(value={"How long does it take for the station to put a crate onto the line. (in ticks)"})
                public static int outputTime = 240;
                @Config.Comment(value={"How long does it take for the station to put a crate onto a minecart. (in ticks)"})
                public static int inputTime = 240;
                @Config.Comment(value={"How long does it take for the minecart to drive into the station. (in ticks)"})
                public static int minecartInTime = 60;
                @Config.Comment(value={"How long does it take for the minecart to drive out of the station. (in ticks)"})
                public static int minecartOutTime = 60;
            }

            public static class Packer {
                @Config.Comment(value={"Energy capacity of the glorious boxing device also known as The Packer."})
                public static int energyCapacity = 16000;
                @Config.Comment(value={"Energy usage of the packer (after dropping a stack inside)."})
                public static int energyUsage = 512;
                @Config.Comment(value={"Duration of the container being pushed by conveyor into and out of the center (in ticks)."})
                public static int conveyorTime = 60;
                @Config.Comment(value={"Duration of a single stack insertion process (in ticks)."})
                public static int timeInsertion = 5;
            }

            public static class RedstoneInterface {
            }
        }

        public static class Tools {
            @Config.SubConfig
            public static SkycrateMounts skycrateMounts;
            @Config.Comment(value={"A modifier to apply to the ammunition resupply time of the Ammunition Crate (weapons reload)."})
            public static float ammunition_crate_resupply_time;
            @Config.Comment(value={"The Lighter fuel capacity in milibuckets (mB)."})
            @Config.RequiresMcRestart
            public static int lighter_capacity;
            @Config.Comment(value={"The capacity of the measuring cup (mB)."})
            @Config.RequiresMcRestart
            public static int measuring_cup_capacity;
            @Config.Comment(value={"The energy capacity of the electric hammer in RF... i mean IF... i mean FE... that thing o' powerin'!."})
            @Config.RequiresMcRestart
            public static int electric_hammer_capacity;
            @Config.Comment(value={"The energy capacity of the electric wirecutter."})
            @Config.RequiresMcRestart
            public static int electric_wirecutter_capacity;
            @Config.Comment(value={"The energy capacity of the electric wrench."})
            @Config.RequiresMcRestart
            public static int electric_wrench_capacity;
            @Config.Comment(value={"The energy capacity of the electric multitool. (when it will be added)"})
            @Config.RequiresMcRestart
            public static int electric_multitool_capacity;
            @Config.Comment(value={"The energy usage of the electric hammer (when mining, rotating, etc. )."})
            @Config.RequiresMcRestart
            public static int electric_hammer_energy_per_use;
            @Config.Comment(value={"The energy usage of the electric hammer when building advanced multiblocks (per tick)."})
            @Config.RequiresMcRestart
            public static int electric_hammer_energy_per_use_construction;
            @Config.Comment(value={"The energy usage of the electric wirecutter (when cutting wires)."})
            @Config.RequiresMcRestart
            public static int electric_wirecutter_energy_per_use;
            @Config.Comment(value={"The energy usage of the electric wrench (when destroying blocks / accessing GUIs)."})
            @Config.RequiresMcRestart
            public static int electric_wrench_energy_per_use;
            @Config.Comment(value={"The durability of the engineer's wrench."})
            @Config.RequiresMcRestart
            public static int wrench_durability;
            @Config.Comment(value={"Max zoom of the binoculars (in Blu's unit of distance measurement\u00e2\u201e\u02d8)."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float[] binoculars_max_zoom;
            @Config.Comment(value={"Max zoom of the advanced binoculars (in Blu's Unit of Distance Measurement\u00e2\u201e\u02d8)."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_floatA")
            public static float[] advanced_binoculars_max_zoom;
            @Config.Comment(value={"The energy capacity of advanced binoculars (when using Infrared Sight)."})
            @Config.RequiresMcRestart
            public static int advanced_binoculars_energy_capacity;
            @Config.Comment(value={"The energy usage of advanced binoculars (when using Infrared Sight)."})
            @Config.RequiresMcRestart
            public static int advanced_binoculars_energy_usage;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Buzzsaw."})
            @Config.RequiresMcRestart
            public static int precission_tool_buzzsaw_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Drill."})
            @Config.RequiresMcRestart
            public static int precission_tool_drill_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Inserter."})
            @Config.RequiresMcRestart
            public static int precission_tool_inserter_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Solderer."})
            @Config.RequiresMcRestart
            public static int precission_tool_solderer_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Welder."})
            @Config.RequiresMcRestart
            public static int precission_tool_welder_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Precission Hammer."})
            @Config.RequiresMcRestart
            public static int precission_tool_hammer_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Iron Sawblade."})
            @Config.RequiresMcRestart
            public static int sawblade_iron_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Steel Sawblade."})
            @Config.RequiresMcRestart
            public static int sawblade_steel_durability;
            @Config.Comment(value={"The durability (max number of uses) of the Tungsten Sawblade."})
            @Config.RequiresMcRestart
            public static int sawblade_tungsten_durability;
            @Config.Comment(value={"The usage time of the Precission Buzzsaw."})
            @Config.RequiresMcRestart
            public static int precission_tool_buzzsaw_usage_time;
            @Config.Comment(value={"The usage time of the Precission Drill."})
            @Config.RequiresMcRestart
            public static int precission_tool_drill_usage_time;
            @Config.Comment(value={"The usage time of the Precission Inserter."})
            @Config.RequiresMcRestart
            public static int precission_tool_inserter_usage_time;
            @Config.Comment(value={"The usage time of the Precission Solderer."})
            @Config.RequiresMcRestart
            public static int precission_tool_solderer_usage_time;
            @Config.Comment(value={"The usage time of the Precission Welder."})
            @Config.RequiresMcRestart
            public static int precission_tool_welder_usage_time;
            @Config.Comment(value={"The usage time of the Precission Hammer."})
            @Config.RequiresMcRestart
            public static int precission_tool_hammer_usage_time;

            static {
                ammunition_crate_resupply_time = 1.0f;
                lighter_capacity = 1000;
                measuring_cup_capacity = 500;
                electric_hammer_capacity = 24000;
                electric_wirecutter_capacity = 24000;
                electric_wrench_capacity = 24000;
                electric_multitool_capacity = 100000;
                electric_hammer_energy_per_use = 100;
                electric_hammer_energy_per_use_construction = 4096;
                electric_wirecutter_energy_per_use = 100;
                electric_wrench_energy_per_use = 100;
                wrench_durability = 256;
                binoculars_max_zoom = new float[]{0.1f, 0.125f, 0.167f, 0.25f, 0.5f};
                advanced_binoculars_max_zoom = new float[]{0.05f, 0.0625f, 0.0833f, 0.1f, 0.25f};
                advanced_binoculars_energy_capacity = 4000;
                advanced_binoculars_energy_usage = 150;
                precission_tool_buzzsaw_durability = 150;
                precission_tool_drill_durability = 250;
                precission_tool_inserter_durability = 200;
                precission_tool_solderer_durability = 150;
                precission_tool_welder_durability = 250;
                precission_tool_hammer_durability = 200;
                sawblade_iron_durability = 150;
                sawblade_steel_durability = 300;
                sawblade_tungsten_durability = 550;
                precission_tool_buzzsaw_usage_time = 140;
                precission_tool_drill_usage_time = 140;
                precission_tool_inserter_usage_time = 60;
                precission_tool_solderer_usage_time = 80;
                precission_tool_welder_usage_time = 160;
                precission_tool_hammer_usage_time = 40;
            }

            public static class SkycrateMounts {
                @Config.Comment(value={"The speed of the Mechanical Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float mech_speed = 0.25f;
                @Config.Comment(value={"The energy (max distance to be traveled) of the Mechanical Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float mech_energy = 35.0f;
                @Config.Comment(value={"The speed of the Electric Skycrate Mount."})
                @Config.RequiresMcRestart
                public static float electric_speed = 1.0f;
                @Config.Comment(value={"The energy to distance ratio of the Electric Skycrate Mount. (in Immersive Flux per Meter)"})
                @Config.RequiresMcRestart
                public static int electric_energy_ratio = 128;
                @Config.Comment(value={"The energy capacity of the Electric Skycrate Mount (in Immersive Flux)."})
                @Config.RequiresMcRestart
                public static float electric_energy = 55.0f;
            }
        }

        public static class Ores {
            @Config.Comment(value={"A blacklist of dimensions in which IE ores won't spawn. By default this is Nether (-1) and End (1)"})
            public static int[] oreDimBlacklistNormal = new int[]{-1, 1};
            @Config.Comment(value={"A blacklist of dimensions in which IE ores won't spawn. By default this is the Overworld (0) and End (1)"})
            public static int[] oreDimBlacklistNether = new int[]{0, 1};
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that were flagged for retrogen."})
            public static boolean retrogen_log_flagChunk = true;
            @Config.Comment(value={"Set this to false to disable the logging of the chunks that are still left to retrogen."})
            public static boolean retrogen_log_remaining = true;
            @Config.Comment(value={"The retrogeneration key. Basically IE checks if this key is saved in the chunks data. If it isn't, it will perform retrogen on all ores marked for retrogen.", "Change this in combination with the retrogen booleans to regen only some of the ores."})
            public static String retrogen_key = "DEFAULT_II";
            @Config.Comment(value={"Generation config for Platinum Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_platinum = new int[]{6, 0, 10, 2, 35};
            @Config.Comment(value={"Generation config for Zinc Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_zinc = new int[]{10, 35, 95, 2, 55};
            @Config.Comment(value={"Generation config for Tungsten Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_tungsten = new int[]{6, 0, 35, 2, 45};
            @Config.Comment(value={"Generation config for Salt Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_salt = new int[]{12, 55, 95, 1, 65};
            @Config.Comment(value={"Generation config for Fluorite Ore.", "Parameters: Vein size, lowest possible Y, highest possible Y, veins per chunk, chance for vein to spawn (out of 100). Set vein size to 0 to disable the generation"})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=Config.class, mapName="manual_intA")
            public static int[] ore_fluorite = new int[]{12, 1, 55, 1, 10};
            @Config.Comment(value={"Set this to true to allow retro-generation of Platinum Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_platinum = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Zinc Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_zinc = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Tungsten Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_tungsten = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Salt Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_salt = false;
            @Config.Comment(value={"Set this to true to allow retro-generation of Salt Ore."})
            @Config.RequiresMcRestart
            @Config.Mapped(mapClass=IIWorldGen.class, mapName="retrogenMap")
            public static boolean retrogen_fluorite = false;
        }
    }
}

