/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.func;

import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IConstantNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeFunc;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.INodeStack;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IVariableNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.NodeTypes;

public abstract class NodeFuncGeneric
implements INodeFunc {
    private final IExpressionNode node;
    protected final Class<?>[] types;
    protected final IVariableNode[] variables;

    public NodeFuncGeneric(IExpressionNode node, Class<?>[] types, IVariableNode[] nodes) {
        this.node = node;
        this.types = types;
        this.variables = nodes;
        if (types.length != nodes.length) {
            throw new IllegalArgumentException("Lengths did not match! (" + types.length + " vs " + nodes.length + ")");
        }
        for (int i = 0; i < types.length; ++i) {
            Class<?> givenType = types[i];
            if (NodeTypes.getType(nodes[i]) == givenType) continue;
            throw new IllegalArgumentException("Types did not match! (given " + givenType + ", node is " + nodes[i].getClass() + ")");
        }
    }

    protected IExpressionNode[] popArgs(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode[] nodes = new IExpressionNode[this.types.length];
        for (int i = this.types.length; i > 0; --i) {
            nodes[i - 1] = stack.pop(this.types[i - 1]);
        }
        return nodes;
    }

    public String toString() {
        return "somefunc(" + this.node.toString() + ")";
    }

    public static enum InlineType {
        NONE,
        PARTIAL,
        FULL;


        public InlineType and(IExpressionNode before, IExpressionNode after) {
            if (this == PARTIAL) {
                return PARTIAL;
            }
            if (this == NONE) {
                return before == after ? NONE : PARTIAL;
            }
            return after instanceof IConstantNode ? FULL : PARTIAL;
        }
    }

    protected abstract class Func
    implements IExpressionNode {
        protected final IExpressionNode[] realArgs;

        public Func(IExpressionNode[] argsIn) {
            this.realArgs = argsIn;
        }

        protected void setupEvaluate(IExpressionNode[] nodes) {
            for (int i = 0; i < nodes.length; ++i) {
                NodeFuncGeneric.this.variables[i].set(nodes[i]);
            }
        }

        protected InlineType setupInline(IExpressionNode[] nodes) {
            InlineType type = InlineType.FULL;
            for (int i = 0; i < this.realArgs.length; ++i) {
                IExpressionNode aft;
                IExpressionNode bef = this.realArgs[i];
                nodes[i] = aft = bef.inline();
                type = type.and(bef, aft);
            }
            return type;
        }

        protected String getArgsToString() {
            StringBuilder total = new StringBuilder("[");
            for (int i = 0; i < this.realArgs.length; ++i) {
                if (i > 0) {
                    total.append(", (");
                } else {
                    total.append(" (");
                }
                total.append(this.realArgs[i].toString()).append(") ");
            }
            return total + "]";
        }

        public String toString() {
            return "[" + this.getArgsToString() + " -> generic]";
        }
    }
}

