/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.BakedConfigurable;
import alexiil.mc.mod.load.json.Area;
import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.InvalidSourceException;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.util.ResourceLocation;

public abstract class JsonConfigurable<C extends JsonConfigurable<C, B>, B extends BakedConfigurable> {
    public transient ResourceLocation resourceLocation;
    private transient String rawText;

    public void setLocation(ResourceLocation location) {
        if (this.resourceLocation == null) {
            this.resourceLocation = location;
        }
    }

    public final void setSource(String src) {
        if (this.rawText == null) {
            this.rawText = src;
        }
    }

    public final void setSource(JsonElement json) {
        if (this.rawText == null) {
            this.rawText = ConfigManager.GSON_DEFAULT.toJson(json);
        }
    }

    public String getRawText() {
        return this.rawText;
    }

    public final B bake(FunctionContext context) throws InvalidExpressionException {
        if (this.resourceLocation == null) {
            throw new NullPointerException("resourcelocation");
        }
        if (this.rawText == null) {
            throw new NullPointerException("src in " + this.resourceLocation);
        }
        try {
            B b = this.actuallyBake(context);
            ((BakedConfigurable)b).setOrigin(this.resourceLocation, this.rawText);
            return b;
        }
        catch (InvalidExpressionException iee) {
            throw new InvalidSourceException(this.resourceLocation, this.rawText, iee);
        }
    }

    protected abstract B actuallyBake(FunctionContext var1) throws InvalidExpressionException;

    protected static <O> O deserialiseObject(JsonObject obj, String memeber, JsonDeserializationContext ctx, Class<O> clazz) {
        if (obj.has(memeber)) {
            return (O)ctx.deserialize(obj.get(memeber), clazz);
        }
        return null;
    }

    protected static String consolidateFunction(JsonObject obj, String memeber, JsonDeserializationContext ctx, String parent, String defaultF) {
        return JsonConfigurable.consolidateFunction(JsonConfigurable.deserialiseObject(obj, memeber, ctx, String.class), parent, defaultF);
    }

    protected static String consolidateFunction(String in, String parent, String defaultF) {
        if (in == null) {
            if (parent == null) {
                return defaultF;
            }
            return parent;
        }
        if (parent == null) {
            return in;
        }
        return in.replaceAll("super", "(" + parent + ")");
    }

    protected static <O> O overrideObject(JsonObject obj, String memeber, JsonDeserializationContext ctx, Class<O> clazz, O parent, O defaultO) {
        O in = JsonConfigurable.deserialiseObject(obj, memeber, ctx, clazz);
        if (in != null) {
            return in;
        }
        if (parent != null) {
            return parent;
        }
        return defaultO;
    }

    protected static JsonVariable[] overrideVariables(JsonObject obj, String memeber, JsonDeserializationContext ctx, JsonVariable[] parent) {
        JsonVariable[] in = JsonConfigurable.deserialiseObject(obj, memeber, ctx, JsonVariable[].class);
        if (in == null) {
            return parent == null ? new JsonVariable[]{} : parent;
        }
        if (parent == null) {
            return in;
        }
        ArrayList<JsonVariable> vars = new ArrayList<JsonVariable>(in.length + parent.length);
        Collections.addAll(vars, in);
        for (JsonVariable vParent : parent) {
            boolean found = false;
            for (JsonVariable vChild : vars) {
                if (!vChild.name.equalsIgnoreCase(vParent.name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            vars.add(vParent);
        }
        return vars.toArray(new JsonVariable[vars.size()]);
    }

    protected static void ensureExists(Object obj, String name) throws InvalidExpressionException {
        if (obj == null) {
            throw new InvalidExpressionException("Missing element '" + name + "'");
        }
    }

    protected static <O> O[] consolidateArray(O[] first, O[] last) {
        if (first == null || first.length == 0) {
            return last != null ? last : first;
        }
        if (last == null || last.length == 0) {
            return first;
        }
        O[] array = Arrays.copyOf(first, first.length + last.length);
        System.arraycopy(last, 0, array, first.length, last.length);
        return array;
    }

    protected static Area consolidateArea(JsonObject obj, String memeber, JsonDeserializationContext ctx, Area parent) {
        Area in;
        if (obj.has(memeber)) {
            in = (Area)ctx.deserialize(obj.get(memeber), Area.class);
            if (in == null) {
                return parent;
            }
        } else {
            return parent;
        }
        if (parent == null) {
            return in;
        }
        String x = JsonConfigurable.consolidateFunction(in.x, parent.x, "");
        String y = JsonConfigurable.consolidateFunction(in.y, parent.y, "");
        String width = JsonConfigurable.consolidateFunction(in.width, parent.width, "");
        String height = JsonConfigurable.consolidateFunction(in.height, parent.height, "");
        Area a = new Area(x, y, width, height);
        return a;
    }
}

