/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.CustomLoadingScreen;
import alexiil.mc.mod.load.render.MinecraftDisplayerWrapper;
import com.google.common.collect.Queues;
import java.io.File;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLFileResourcePack;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;

@Deprecated
public class ProgressDisplayer {
    private static List<IDisplayer> displayers = new ArrayList<IDisplayer>();
    private static int clientState = -1;
    public static Configuration cfg;
    public static File coreModLocation;
    public static ModContainer modContainer;
    private static Deque<Integer> stepsQueue;
    private static Deque<Integer> stepsCurrent;

    public static boolean isClient() {
        StackTraceElement[] steArr;
        if (clientState < 1000) {
            return true;
        }
        if (clientState != -1) {
            return clientState == 1;
        }
        for (StackTraceElement ste : steArr = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("net.minecraft.server")) continue;
            clientState = 0;
            return false;
        }
        clientState = 1;
        return true;
    }

    public static void start(File coremodLocation) {
        String comment;
        coreModLocation = coremodLocation;
        if (coreModLocation == null) {
            coreModLocation = new File("./../bin/");
        }
        ModMetadata md = new ModMetadata();
        md.name = "Custom Loading Screen";
        md.modId = "customloadingscreen";
        modContainer = new DummyModContainer(md){

            public Class<?> getCustomResourcePackClass() {
                return FMLFileResourcePack.class;
            }

            public File getSource() {
                return coreModLocation;
            }

            public String getModId() {
                return "customloadingscreen";
            }
        };
        cfg = CustomLoadingScreen.CONFIG;
        boolean useMinecraft = ProgressDisplayer.isClient();
        if (useMinecraft) {
            comment = "Whether or not to use minecraft's display to show the progress. This looks better, but there is a possibilty of not being ";
            comment = comment + "compatible, so if you do have any strange crash reports or compatability issues, try setting this to false";
            useMinecraft = cfg.getBoolean("useMinecraft", "general", true, comment);
        }
        comment = "Whether or not to show a window seperate to minecraft to show the loading time -this will automatically display above all windows, so you can see it even if you alt-tab to another window.";
        boolean showFrame = cfg.getBoolean("showFrame", "general", false, comment);
        if (useMinecraft) {
            displayers.add(new MinecraftDisplayerWrapper());
        }
        for (IDisplayer displayer : displayers) {
            displayer.open(cfg);
        }
        cfg.save();
    }

    public static void displayProgress(String text, double percent) {
        for (IDisplayer displayer : displayers) {
            displayer.updateProgress(text, percent);
        }
    }

    public static void close() {
        for (IDisplayer displayer : displayers) {
            displayer.close();
        }
        displayers.clear();
    }

    public static void minecraftDisplayFirstProgress() {
    }

    public static void minecraftDisplayAfterForge() {
    }

    public static void pause() {
        for (IDisplayer displayer : displayers) {
            if (displayer == null) continue;
            displayer.pause();
        }
    }

    public static void resume() {
        for (IDisplayer displayer : displayers) {
            if (displayer == null) continue;
            displayer.resume();
        }
    }

    public static void pushProgress() {
        for (IDisplayer displayer : displayers) {
            if (displayer == null) continue;
            displayer.pushProgress();
        }
    }

    public static void popProgress() {
        for (IDisplayer displayer : displayers) {
            if (displayer == null) continue;
            displayer.popProgress();
        }
    }

    public static void forgeHook_ProgressManager_Push(String title, int steps, boolean timeEachStep) {
        ProgressDisplayer.pushProgress();
        stepsQueue.push(steps);
        stepsCurrent.push(0);
        ProgressDisplayer.displayProgress(title, 0.0);
    }

    public static void forgeHook_ProgressManager_Pop() {
        ProgressDisplayer.popProgress();
        stepsQueue.pop();
        stepsCurrent.pop();
    }

    public static void forgeHook_ProgressManager_ProgressBar_Step(String message) {
        int current = stepsCurrent.pop() + 1;
        stepsCurrent.push(current);
        double numSteps = stepsQueue.peek().intValue();
        if ((double)current > numSteps) {
            CLSLog.warn("Current (" + current + ") was greater than num steps(" + numSteps + ")!");
            current = (int)numSteps;
        }
        ProgressDisplayer.displayProgress(message, (double)current / numSteps);
    }

    static {
        stepsQueue = Queues.newArrayDeque();
        stepsCurrent = Queues.newArrayDeque();
    }

    @Deprecated
    public static interface IDisplayer {
        public void open(Configuration var1);

        public void updateProgress(String var1, double var2);

        public void addFuture(String var1, double var2);

        public void pushProgress();

        public void popProgress();

        public void close();

        public void pause();

        public void resume();
    }
}

