/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.CustomLoadingScreen;
import alexiil.mc.mod.load.Tips;
import alexiil.mc.mod.load.baked.BakedConfig;
import alexiil.mc.mod.load.json.ConfigManager;
import alexiil.mc.mod.load.json.JsonConfig;
import alexiil.mc.mod.load.progress.SingleProgressBarTracker;
import alexiil.mc.mod.load.render.MainSplashRenderer;
import alexiil.mc.mod.load.render.MinecraftDisplayerRenderer;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.DefaultContexts;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableBoolean;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableDouble;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableLong;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariableObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.ProgressManager;
import org.lwjgl.opengl.Display;

public class ClsManager {
    public static final Resolution RESOLUTION = new Resolution();
    private static final FunctionContext FUNC_CTX = DefaultContexts.createWithAll();
    private static final NodeVariableObject<String> NODE_STATUS = FUNC_CTX.putVariableString("status");
    private static final NodeVariableObject<String> NODE_STATUS_SUB = FUNC_CTX.putVariableString("sub_status");
    private static final NodeVariableDouble NODE_PERCENTAGE = FUNC_CTX.putVariableDouble("percentage");
    private static final NodeVariableLong NODE_SCREEN_WIDTH = FUNC_CTX.putVariableLong("screen_width");
    private static final NodeVariableLong NODE_SCREEN_HEIGHT = FUNC_CTX.putVariableLong("screen_height");
    private static final NodeVariableDouble NODE_TIME = FUNC_CTX.putVariableDouble("time");
    private static final NodeVariableBoolean NODE_IS_RELOADING = FUNC_CTX.putVariableBoolean("is_reloading");
    private static final NodeVariableObject<String> NODE_ERROR_MESSAGE = FUNC_CTX.putVariableString("error_message");
    private static final List<String> forgeProgressBarTitles = new ArrayList<String>();
    private static final List<String> forgeProgressBarMessages = new ArrayList<String>();
    private static final List<Double> forgeProgressBarPercents = new ArrayList<Double>();
    private static MinecraftDisplayerRenderer instance;
    private static IResourceManager resManager;

    public static boolean load() throws InvalidExpressionException {
        resManager = Minecraft.func_71410_x().func_110442_L();
        Minecraft.func_71410_x().func_110436_a();
        String used = CustomLoadingScreen.customConfigPath;
        JsonConfig cfg = ConfigManager.getAsConfig(used);
        if (cfg == null) {
            CLSLog.info("Error: couldn't find the config file '" + used + "', defaulting to sample/generic_error");
            ClsManager.NODE_ERROR_MESSAGE.value = "Error: couldn't find the config file '" + used + "'";
            cfg = ConfigManager.getAsConfig("sample/generic_error");
            if (cfg == null) {
                CLSLog.info("Error: couldn't find the generic error file! '" + used + "', defaulting to sample/generic_error");
                return false;
            }
        } else {
            ClsManager.NODE_ERROR_MESSAGE.value = "Unknown error! Check your logs + config file (this should never be shown normally)";
        }
        try {
            instance = new MinecraftDisplayerRenderer((BakedConfig)cfg.bake(FUNC_CTX), null);
        }
        catch (InvalidExpressionException e) {
            CLSLog.warn("Failed to bake " + used, e);
            return false;
        }
        return true;
    }

    public static void renderFrame() {
        try (SingleProgressBarTracker.LockUnlocker u = SingleProgressBarTracker.lockUpdate();){
            ClsManager.NODE_IS_RELOADING.value = SingleProgressBarTracker.isInReload();
            ClsManager.NODE_STATUS.value = SingleProgressBarTracker.getStatusText();
            ClsManager.NODE_STATUS_SUB.value = SingleProgressBarTracker.getSubStatus();
            ClsManager.NODE_PERCENTAGE.value = (double)SingleProgressBarTracker.getProgress() / 1048576.0;
            Iterator i = ProgressManager.barIterator();
            forgeProgressBarTitles.clear();
            forgeProgressBarMessages.clear();
            forgeProgressBarPercents.clear();
            while (i.hasNext()) {
                ProgressManager.ProgressBar b = (ProgressManager.ProgressBar)i.next();
                forgeProgressBarTitles.add(b.getTitle());
                forgeProgressBarMessages.add(b.getMessage());
                double div = b.getSteps();
                if (div <= 0.0) {
                    forgeProgressBarPercents.add(0.0);
                    continue;
                }
                forgeProgressBarPercents.add((double)b.getStep() / div);
            }
        }
        ClsManager.RESOLUTION.update();
        ClsManager.NODE_TIME.value = (double)MainSplashRenderer.getTotalTime() / 1000.0;
        instance.render();
    }

    public static boolean renderTransitionFrame() {
        ClsManager.renderFrame();
        return true;
    }

    public static IResource getResource(ResourceLocation identifier) throws IOException {
        return resManager.func_110536_a(identifier);
    }

    static {
        FUNC_CTX.put_l("forge_progress_bar_count", forgeProgressBarTitles::size);
        FUNC_CTX.put_l_o("forge_progress_bar_title", String.class, index -> {
            if (index < 0L || index >= (long)forgeProgressBarTitles.size()) {
                return "Invalid Index";
            }
            return forgeProgressBarTitles.get((int)index);
        }).setNeverInline();
        FUNC_CTX.put_l_o("forge_progress_bar_message", String.class, index -> {
            if (index < 0L || index >= (long)forgeProgressBarMessages.size()) {
                return "Invalid Index";
            }
            return forgeProgressBarMessages.get((int)index);
        }).setNeverInline();
        FUNC_CTX.put_l_d("forge_progress_bar_percent", index -> {
            if (index < 0L || index >= (long)forgeProgressBarPercents.size()) {
                return 0.0;
            }
            return forgeProgressBarPercents.get((int)index);
        }).setNeverInline();
        FUNC_CTX.put_s("tip", Tips::getFirstTip);
        FUNC_CTX.put_l("tip_count", Tips::getTipCount);
        FUNC_CTX.put_l_o("tip", String.class, Tips::getTip);
        FUNC_CTX.put_l("memory_bytes_total", Runtime.getRuntime()::totalMemory);
        FUNC_CTX.put_l("memory_bytes_max", Runtime.getRuntime()::maxMemory);
        FUNC_CTX.put_l("memory_bytes_free", Runtime.getRuntime()::freeMemory);
        FUNC_CTX.put_l("memory_bytes_used", () -> Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        FUNC_CTX.put_l("memory_total", () -> Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        FUNC_CTX.put_l("memory_max", () -> Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        FUNC_CTX.put_l("memory_free", () -> Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        FUNC_CTX.put_l("memory_used", () -> (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L);
    }

    public static class Resolution {
        private double width;
        private double height;
        private double scale = 1.0;

        private void update() {
            this.width = Display.getWidth();
            this.height = Display.getHeight();
            int scaleFactor = 1;
            boolean unicode = false;
            int guiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
            if (guiScale == 0) {
                guiScale = 1000;
            }
            while (scaleFactor < guiScale && this.width / (double)(scaleFactor + 1) >= 320.0 && this.height / (double)(scaleFactor + 1) >= 240.0) {
                ++scaleFactor;
            }
            if (unicode && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }
            this.width = MathHelper.func_76143_f((double)(this.width / (double)scaleFactor));
            this.height = MathHelper.func_76143_f((double)(this.height / (double)scaleFactor));
            NODE_SCREEN_WIDTH.value = (long)this.width;
            NODE_SCREEN_HEIGHT.value = (long)this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

