/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks.item;

import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.capability.food.FoodStatsTFC;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.fluids.properties.DrinkableProperty;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.dries007.tfc.util.FluidTransferHelper;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import org.labellum.mc.waterflasks.ConfigFlasks;
import org.labellum.mc.waterflasks.Waterflasks;
import org.labellum.mc.waterflasks.fluids.FlaskFluidHandler;
import org.labellum.mc.waterflasks.item.ModItems;

public abstract class ItemFlask
extends ItemFluidContainer
implements IItemSize {
    private int CAPACITY;
    private int DRINK;
    protected String name;

    public ItemFlask(String name, int CAPACITY, int DRINK) {
        super(CAPACITY);
        this.CAPACITY = CAPACITY;
        this.DRINK = DRINK;
        this.name = name;
        this.func_77655_b("waterflasks." + name);
        this.setRegistryName(name);
        this.func_77637_a(CreativeTabs.field_78039_h);
        if (ConfigFlasks.GENERAL.damageFactor == 0) {
            this.func_77656_e(Integer.MAX_VALUE);
        } else {
            this.func_77656_e(CAPACITY / ConfigFlasks.GENERAL.damageFactor);
        }
        this.func_77627_a(true);
    }

    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.MEDIUM;
    }

    public boolean canStack(@Nonnull ItemStack stack) {
        return false;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FlaskFluidHandler(stack, this.CAPACITY, FluidsTFC.getAllWrappers().stream().filter(x -> x.get(DrinkableProperty.DRINKABLE) != null).map(FluidWrapper::get).collect(Collectors.toSet()));
    }

    public void registerItemModel() {
        this.initModel((Item)this, 0, this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel(Item item, int meta, String id) {
        final ModelResourceLocation modelFull = new ModelResourceLocation("waterflasks:" + id, "inventory");
        final ModelResourceLocation model4 = new ModelResourceLocation("waterflasks:" + id + "-4", "inventory");
        final ModelResourceLocation model3 = new ModelResourceLocation("waterflasks:" + id + "-3", "inventory");
        final ModelResourceLocation model2 = new ModelResourceLocation("waterflasks:" + id + "-2", "inventory");
        final ModelResourceLocation model1 = new ModelResourceLocation("waterflasks:" + id + "-1", "inventory");
        final ModelResourceLocation model0 = new ModelResourceLocation("waterflasks:" + id + "-0", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{modelFull, model4, model3, model2, model1, model0});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                switch ((int)Math.floor((double)ItemFlask.this.getLiquidAmount(stack) / (double)ItemFlask.this.CAPACITY * 5.0)) {
                    case 5: {
                        return modelFull;
                    }
                    case 4: {
                        return model4;
                    }
                    case 3: {
                        return model3;
                    }
                    case 2: {
                        return model2;
                    }
                    case 1: {
                        return model1;
                    }
                }
                return model0;
            }
        });
    }

    public int getLiquidAmount(ItemStack stack) {
        FluidStack drained;
        int content = 0;
        IFluidHandler flaskCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (flaskCap != null && (drained = flaskCap.drain(this.CAPACITY, false)) != null) {
            content = drained.amount;
        }
        return content;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        FluidStack drained;
        IFluidHandler flaskCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (flaskCap != null && (drained = flaskCap.drain(this.CAPACITY, false)) != null) {
            Fluid fluid = drained.getFluid();
            return fluid.getColor();
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (player.func_184812_l_()) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            IFluidHandler flaskCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (flaskCap != null) {
                FoodStats stats;
                if (player.func_70093_af()) {
                    flaskCap.drain(this.CAPACITY, true);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                RayTraceResult rayTrace = this.func_77621_a(world, player, true);
                FluidStack cont = flaskCap.drain(this.CAPACITY, false);
                if (!(world.field_72995_K || cont != null && cont.amount >= this.CAPACITY || rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK)) {
                    ItemStack single = stack.func_77946_l();
                    single.func_190920_e(1);
                    FluidActionResult result = FluidTransferHelper.tryPickUpFluidGreedy((ItemStack)single, (EntityPlayer)player, (World)world, (BlockPos)rayTrace.func_178782_a(), (EnumFacing)rayTrace.field_178784_b, (int)1000, (boolean)false);
                    if (result.isSuccess()) {
                        stack.func_190918_g(1);
                        ItemStack res = result.getResult();
                        if (stack.func_190926_b()) {
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)res);
                        }
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)res);
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
                if ((stats = player.func_71024_bL()) instanceof FoodStatsTFC && ((FoodStatsTFC)stats).getThirst() >= 100.0f) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                if (cont != null && cont.amount >= this.DRINK) {
                    player.func_184598_c(hand);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        DrinkableProperty drinkable;
        FluidStack fluidConsumed;
        FluidStack total;
        IFluidHandler flaskCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (flaskCap != null && (total = flaskCap.drain(this.CAPACITY, false)) != null && total.amount > 0 && (fluidConsumed = flaskCap.drain(this.DRINK, true)) != null && (drinkable = (DrinkableProperty)FluidsTFC.getWrapper((Fluid)fluidConsumed.getFluid()).get(DrinkableProperty.DRINKABLE)) != null) {
            drinkable.onDrink((EntityPlayer)entityLiving);
            if (stack.func_77952_i() == stack.func_77958_k()) {
                ResourceLocation name = stack.func_77973_b().getRegistryName();
                worldIn.func_184133_a(null, entityLiving.func_180425_c(), Waterflasks.FLASK_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (name.toString().contains("leather")) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entityLiving), (ItemStack)new ItemStack((Item)ModItems.brokenLeatherFlask));
                } else {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entityLiving), (ItemStack)new ItemStack((Item)ModItems.brokenIronFlask));
                }
                stack.func_190918_g(1);
            } else {
                stack.func_77972_a(1, entityLiving);
            }
        }
        return stack;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack;
        IFluidHandler bucketCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (bucketCap != null && (fluidStack = bucketCap.drain(this.CAPACITY, false)) != null) {
            String fluidname = fluidStack.getLocalizedName();
            return new TextComponentTranslation("item.waterflasks.filled_" + this.name + ".name", new Object[]{fluidname}).func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (FluidWrapper wrapper : FluidsTFC.getAllWrappers()) {
                if (wrapper.get(DrinkableProperty.DRINKABLE) == null) continue;
                ItemStack stack = new ItemStack((Item)this);
                IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (cap != null) {
                    cap.fill(new FluidStack(wrapper.get(), this.CAPACITY), true);
                }
                items.add((Object)stack);
            }
        }
    }
}

