/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks;

import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.util.Helpers;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.labellum.mc.waterflasks.ApplyRequiredSkill;
import org.labellum.mc.waterflasks.item.ModItems;
import org.labellum.mc.waterflasks.proxy.CommonProxy;
import org.labellum.mc.waterflasks.recipe.ModRecipes;

@Mod(modid="waterflasks", name="WaterFlasks", version="1.7", dependencies="required-after:tfc@[1.0.0.127,)", acceptedMinecraftVersions="[1.12.2]")
public class Waterflasks {
    public static final String MOD_ID = "waterflasks";
    public static final String MOD_NAME = "WaterFlasks";
    public static final String VERSION = "1.7";
    public static final String DEPENDENCIES = "required-after:tfc@[1.0.0.127,)";
    @Mod.Instance(value="waterflasks")
    public static Waterflasks INSTANCE;
    @GameRegistry.ObjectHolder(value="waterflasks:item.flaskbreak")
    public static final SoundEvent FLASK_BREAK;
    @SidedProxy(serverSide="org.labellum.mc.waterflasks.proxy.CommonProxy", clientSide="org.labellum.mc.waterflasks.proxy.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        System.out.println("WaterFlasks is loading");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new ApplyRequiredSkill.Serializer(new ResourceLocation(MOD_ID, "apply_req_skill")));
    }

    static {
        FLASK_BREAK = (SoundEvent)Helpers.getNull();
    }

    @Mod.EventBusSubscriber
    public static class ObjectRegistryHandler {
        @SubscribeEvent
        public static void addItems(RegistryEvent.Register<Item> event) {
            ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerItems(ModelRegistryEvent event) {
            ModItems.registerModels();
        }

        @SubscribeEvent
        public static void onRegisterKnappingRecipeEvent(RegistryEvent.Register<KnappingRecipe> event) {
            ModRecipes.registerKnapping(event);
        }

        @SubscribeEvent
        public static void onRegisterAnvilRecipeEvent(RegistryEvent.Register<AnvilRecipe> event) {
            ModRecipes.registerAnvil(event);
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            ResourceLocation soundID = new ResourceLocation(Waterflasks.MOD_ID, "item.flaskbreak");
            event.getRegistry().register(new SoundEvent(soundID).setRegistryName(soundID));
        }

        @SubscribeEvent
        public static void onLootTableLoad(LootTableLoadEvent event) {
            if (event.getName().toString().startsWith("tfc:")) {
                switch (event.getName().toString().substring(4)) {
                    case "animals/cow": 
                    case "animals/muskox": 
                    case "animals/wildebeest": 
                    case "animals/yak": 
                    case "animals/zebu": {
                        ObjectRegistryHandler.addPool(event, "animals/cow");
                        break;
                    }
                    case "animals/black_bear": 
                    case "animals/grizzly_bear": 
                    case "animals/polar_bear": {
                        ObjectRegistryHandler.addPool(event, "animals/bear");
                        break;
                    }
                    case "animals/horse": 
                    case "animals/camel": 
                    case "animals/donkey": 
                    case "animals/mule": {
                        ObjectRegistryHandler.addPool(event, "animals/horse");
                        break;
                    }
                    case "animals/sheep": 
                    case "animals/goat": 
                    case "animals/alpaca": 
                    case "animals/llama": {
                        ObjectRegistryHandler.addPool(event, "animals/sheep");
                        break;
                    }
                    case "animals/deer": 
                    case "animals/gazelle": {
                        ObjectRegistryHandler.addPool(event, "animals/deer");
                        break;
                    }
                }
            }
        }

        private static void addPool(LootTableLoadEvent event, String tableName) {
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("waterflasks:" + tableName), 1, 0, new LootCondition[0], "waterflasks_bladder_entry");
            LootPool newPool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "waterflasks_bladder_pool");
            event.getTable().addPool(newPool);
        }
    }
}

