/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;

@Config(modid="waterflasks", category="")
@Mod.EventBusSubscriber(modid="waterflasks")
@Config.LangKey(value="config.waterflasks")
public class ConfigFlasks {
    @Config.Comment(value={"General settings"})
    @Config.LangKey(value="config.waterflasks.general")
    public static final GeneralCFG GENERAL = new GeneralCFG();

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("waterflasks")) {
            LogManager.getLogger((String)"waterflasks").warn("Config changed");
            ConfigManager.sync((String)"waterflasks", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class GeneralCFG {
        @Config.Comment(value={"Liquid Capacity of Leather Flask (500 = 1/2 bucket = 5 drinks or 2 water bars)"})
        @Config.RangeInt(min=100)
        @Config.LangKey(value="config.waterflasks.general.leatherCap")
        public int leatherCap = 500;
        @Config.Comment(value={"Liquid Capacity of Iron Flask (1000 = 1 bucket = 10 drinks or 4 water bars)"})
        @Config.RangeInt(min=100)
        @Config.LangKey(value="config.waterflasks.general.ironCap")
        public int ironCap = 2000;
        @Config.Comment(value={"Enable Iron Flask"})
        @Config.LangKey(value="config.waterflasks.general.enableIron")
        public boolean enableIron = true;
        @Config.Comment(value={"Damage Capability of Flasks are Capacity/(this value) 0 = MAXINT uses"})
        @Config.RangeInt(min=0)
        @Config.LangKey(value="config.waterflasks.general.damageFactor")
        public int damageFactor = 5;
    }
}

