/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.waterflasks;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.SkillTier;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

@ParametersAreNonnullByDefault
public class ApplyRequiredSkill
extends LootFunction {
    private final SkillType<? extends SimpleSkill> skillType;
    private final SkillTier tier;
    private final float rarity;

    private ApplyRequiredSkill(LootCondition[] conditionsIn, SkillType<? extends SimpleSkill> skillType, SkillTier tier, float rarity) {
        super(conditionsIn);
        this.skillType = skillType;
        this.tier = tier;
        this.rarity = rarity;
    }

    @Nonnull
    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        IPlayerData skills;
        Entity entity = context.func_186495_b();
        if (entity instanceof EntityPlayer && (skills = (IPlayerData)entity.getCapability(CapabilityPlayerData.CAPABILITY, null)) != null) {
            stack.func_190920_e(0);
            SimpleSkill skill = (SimpleSkill)skills.getSkill(this.skillType);
            if (skill != null && skill.getTier().isAtLeast(this.tier) && rand.nextDouble() + (double)skill.getTotalLevel() > (double)(this.rarity / 100.0f)) {
                stack.func_190920_e(1);
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<ApplyRequiredSkill> {
        public Serializer(ResourceLocation location) {
            super(location, ApplyRequiredSkill.class);
        }

        public void serialize(JsonObject object, ApplyRequiredSkill functionClazz, JsonSerializationContext serializationContext) {
            object.add("skill", serializationContext.serialize((Object)functionClazz.skillType.getName()));
            object.add("tier", serializationContext.serialize((Object)functionClazz.tier));
            object.add("rarity", serializationContext.serialize((Object)Float.valueOf(functionClazz.rarity)));
        }

        @Nonnull
        public ApplyRequiredSkill deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            String skillName = JsonUtils.func_151200_h((JsonObject)object, (String)"skill");
            SkillType skillType = SkillType.get((String)skillName, SimpleSkill.class);
            if (skillType == null) {
                throw new JsonParseException("Unknown skill type: '" + skillName + "'");
            }
            int tierIndex = JsonUtils.func_151203_m((JsonObject)object, (String)"tier");
            float amount = JsonUtils.func_151217_k((JsonObject)object, (String)"rarity");
            return new ApplyRequiredSkill(conditionsIn, skillType, SkillTier.valueOf((int)tierIndex), amount);
        }
    }
}

