/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.integration;

import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.integration.JEIGhostItemHandler;
import com.feed_the_beast.ftblib.integration.JEIGlobalGuiHandler;
import com.feed_the_beast.ftblib.lib.gui.GuiContainerWrapper;
import java.util.Arrays;
import java.util.Optional;
import mezz.jei.Internal;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGlobalGuiHandler;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.KeyBindings;
import mezz.jei.input.InputHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@JEIPlugin
public class FTBLibJEIIntegration
implements IModPlugin {
    public static IJeiRuntime RUNTIME;
    private static Optional<BookmarkList> bookmarkList;

    public void onRuntimeAvailable(IJeiRuntime r) {
        RUNTIME = r;
    }

    public void register(IModRegistry registry) {
        try {
            registry.addGlobalGuiHandlers(new IGlobalGuiHandler[]{new JEIGlobalGuiHandler()});
        }
        catch (LinkageError | RuntimeException throwable) {
            // empty catch block
        }
        try {
            registry.addGhostIngredientHandler(GuiContainerWrapper.class, (IGhostIngredientHandler)new JEIGhostItemHandler());
        }
        catch (LinkageError | RuntimeException throwable) {
            // empty catch block
        }
        MinecraftForge.EVENT_BUS.register(FTBLibJEIIntegration.class);
    }

    public static void handleIngredientKey(int key, Object object) {
        if (RUNTIME != null) {
            if (KeyBindings.showRecipe.isActiveAndMatches(key)) {
                FTBLibJEIIntegration.showRecipe(object);
            } else if (KeyBindings.showUses.isActiveAndMatches(key)) {
                FTBLibJEIIntegration.showUses(object);
            } else if (KeyBindings.bookmark.isActiveAndMatches(key)) {
                FTBLibJEIIntegration.addBookmark(object);
            }
        }
    }

    public static void showRecipe(Object object) {
        RUNTIME.getRecipesGui().show(RUNTIME.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, object));
    }

    public static void showUses(Object object) {
        RUNTIME.getRecipesGui().show(RUNTIME.getRecipeRegistry().createFocus(IFocus.Mode.INPUT, object));
    }

    public static void addBookmark(Object object) {
        if (bookmarkList == null) {
            try {
                bookmarkList = Optional.of((BookmarkList)ReflectionHelper.findField(InputHandler.class, (String[])new String[]{"bookmarkList"}).get(ReflectionHelper.findField(Internal.class, (String[])new String[]{"inputHandler"}).get(null)));
            }
            catch (Exception ex) {
                bookmarkList = Optional.empty();
            }
        }
        if (bookmarkList.isPresent()) {
            bookmarkList.get().add(object);
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("jeicategory") && RUNTIME != null) {
            RUNTIME.getRecipesGui().showCategories(Arrays.asList(event.getID().func_110623_a().split(";")));
        }
    }
}

