/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.client.ImageCache;
import com.mrcrayfish.furniture.client.ImageDownloadThread;
import com.mrcrayfish.furniture.tileentity.IValueContainer;
import com.mrcrayfish.furniture.tileentity.TileEntitySyncClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityPhotoFrame
extends TileEntitySyncClient
implements IValueContainer {
    private int colour = 0;
    private String url;
    private boolean stretch;
    private boolean disabled;
    @SideOnly(value=Side.CLIENT)
    private boolean loading;
    @SideOnly(value=Side.CLIENT)
    private boolean loaded;
    @SideOnly(value=Side.CLIENT)
    private ImageDownloadThread.ImageDownloadResult result;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.url != null) {
            compound.func_74778_a("Photo", this.url);
        }
        compound.func_74757_a("Stretch", this.stretch);
        compound.func_74757_a("DisableInteraction", this.disabled);
        compound.func_74768_a("Color", this.colour);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Photo", 8)) {
            this.url = compound.func_74779_i("Photo");
        }
        if (compound.func_150297_b("Stretch", 1)) {
            this.stretch = compound.func_74767_n("Stretch");
        }
        if (compound.func_150297_b("DisableInteraction", 1)) {
            this.disabled = compound.func_74767_n("DisableInteraction");
        }
        if (compound.func_150297_b("Color", 3)) {
            this.colour = compound.func_74762_e("Color");
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && this.url != null) {
            this.loadUrl(this.url);
        }
    }

    @Nullable
    public String getPhoto() {
        return this.url;
    }

    @SideOnly(value=Side.CLIENT)
    public void loadUrl(String url) {
        if (this.loading) {
            return;
        }
        this.loaded = false;
        this.result = null;
        if (!ImageCache.INSTANCE.loadCached(url)) {
            this.loading = true;
            new ImageDownloadThread(url, (result, message) -> {
                this.loading = false;
                this.result = result;
                if (result == ImageDownloadThread.ImageDownloadResult.SUCCESS) {
                    this.loaded = true;
                }
            }).start();
        } else {
            this.loaded = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLoading() {
        return this.loading;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLoaded() {
        return this.loaded && !this.loading;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ImageDownloadThread.ImageDownloadResult getResult() {
        return this.result;
    }

    @Override
    public List<IValueContainer.Entry> getEntries() {
        ArrayList entries = Lists.newArrayList();
        entries.add(new IValueContainer.Entry("photo", "Photo URL", IValueContainer.Entry.Type.TEXT_FIELD, this.url));
        entries.add(new IValueContainer.Entry("stretch", "Stretch to Border", IValueContainer.Entry.Type.TOGGLE, this.stretch));
        return entries;
    }

    @Override
    public void updateEntries(Map<String, String> entries) {
        this.url = entries.get("photo");
        this.stretch = Boolean.valueOf(entries.get("stretch"));
        this.func_70296_d();
    }

    @Override
    public boolean requiresTool() {
        return false;
    }

    public boolean isStretched() {
        return this.stretch;
    }

    @Override
    public BlockPos getContainerPos() {
        return this.field_174879_c;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setColour(int colour) {
        this.colour = 15 - colour;
    }

    public int getColour() {
        return this.colour;
    }
}

