/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.blocks.IPowered;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.tileentity.TileEntityModernSlidingDoor;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModernSlidingDoor
extends BlockFurniture
implements IPowered {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB[] COLLISION_BOX_BOTTOM = new Bounds(6, 0, 0, 10, 32, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_BOX_BOTTOM_OPENED = new Bounds(0.375, 0.0, 0.0, 0.625, 2.0, 0.185).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_BOX_TOP = new Bounds(6, -16, 0, 10, 16, 16).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_BOX_TOP_OPENED = new Bounds(0.375, -1.0, 0.0, 0.625, 1.0, 0.185).getRotatedBounds();

    public BlockModernSlidingDoor() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean open = false;
        TileEntity tileEntity = source.func_175625_s(pos);
        if (tileEntity instanceof TileEntityModernSlidingDoor) {
            open = ((TileEntityModernSlidingDoor)tileEntity).isPowered();
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            if (open) {
                return COLLISION_BOX_TOP_OPENED[facing.func_176736_b()];
            }
            return COLLISION_BOX_TOP[facing.func_176736_b()];
        }
        if (open) {
            return COLLISION_BOX_BOTTOM_OPENED[facing.func_176736_b()];
        }
        return COLLISION_BOX_BOTTOM[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        boolean open = false;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityModernSlidingDoor) {
            open = ((TileEntityModernSlidingDoor)tileEntity).isPowered();
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            if (open) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_TOP_OPENED[facing.func_176736_b()]);
            } else {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_TOP[facing.func_176736_b()]);
            }
        } else if (open) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_BOTTOM_OPENED[facing.func_176736_b()]);
        } else {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOX_BOTTOM[facing.func_176736_b()]);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177984_a(), FurnitureBlocks.MODERN_SLIDING_DOOR.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            worldIn.func_175655_b(pos.func_177977_b(), false);
        } else {
            worldIn.func_175655_b(pos.func_177984_a(), false);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityModernSlidingDoor) {
            TileEntityModernSlidingDoor slidingDoor = (TileEntityModernSlidingDoor)tileEntity;
            boolean powered = slidingDoor.isPowered();
            this.setPowered(world, pos, state, !powered);
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && blockIn instanceof BlockModernSlidingDoor) {
            boolean hasPower = worldIn.func_175640_z(pos);
            hasPower = ((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue() ? (hasPower |= worldIn.func_175640_z(pos.func_177977_b())) : (hasPower |= worldIn.func_175640_z(pos.func_177984_a()));
            this.setPowered(worldIn, pos, state, hasPower);
        }
    }

    private void setPowered(World world, BlockPos pos, IBlockState state, boolean powered) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityModernSlidingDoor) {
            EnumFacing slidingFacing;
            BlockPos otherDoor;
            IBlockState state1;
            TileEntityModernSlidingDoor slidingDoor = (TileEntityModernSlidingDoor)tileEntity;
            if (slidingDoor.isPowered() == powered) {
                return;
            }
            slidingDoor.setPowered(powered);
            slidingDoor.sync();
            if (powered) {
                world.func_184133_a(null, pos, FurnitureSounds.sliding_door_open, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                world.func_184133_a(null, pos, FurnitureSounds.sliding_door_close, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            pos = (Boolean)state.func_177229_b((IProperty)TOP) != false ? pos.func_177972_a(EnumFacing.DOWN) : pos.func_177972_a(EnumFacing.UP);
            tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityModernSlidingDoor) {
                slidingDoor = (TileEntityModernSlidingDoor)tileEntity;
                slidingDoor.setPowered(powered);
                slidingDoor.sync();
            }
            if ((state1 = world.func_180495_p(otherDoor = pos.func_177972_a((slidingFacing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176735_f()).func_176734_d()))).func_177230_c() instanceof BlockModernSlidingDoor) {
                ((BlockModernSlidingDoor)state1.func_177230_c()).setPowered(world, otherDoor, state1, powered);
            }
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityModernSlidingDoor();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta / 4 > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 4 : 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TOP});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public void setPowered(World world, BlockPos pos, boolean powered) {
        this.setPowered(world, pos, world.func_180495_p(pos), powered);
    }
}

