/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.state.client;

import com.google.common.collect.Maps;
import gigaherz.survivalist.state.IItemState;
import gigaherz.survivalist.state.IItemStateManager;
import gigaherz.survivalist.state.StatefulItem;
import java.util.Map;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;

public class ItemStateMapper
implements ItemMeshDefinition {
    public final Map<StatefulItem, ItemStateMapper> STATE_MAPPERS = Maps.newHashMap();
    final StatefulItem item;

    public <T extends Item> ItemStateMapper(T item) {
        this.item = (StatefulItem)item;
    }

    public void registerAllModelsExplicitly() {
        IItemStateManager manager = this.item.getStateManager();
        for (IItemState state : manager.getStateTable()) {
            ModelLoader.setCustomModelResourceLocation((Item)((Item)this.item), (int)state.getMetadata(), (ModelResourceLocation)this.getModelLocation(state));
        }
    }

    private ModelResourceLocation getModelLocation(IItemState state) {
        return new ModelResourceLocation(((Item)this.item).getRegistryName(), state.toString());
    }

    public ModelResourceLocation func_178113_a(ItemStack stack) {
        if (stack.func_77973_b() != this.item) {
            throw new IllegalArgumentException("The stack's item is not the expected item!");
        }
        IItemState state = IItemStateManager.lookup(stack);
        if (state == null) {
            state = this.item.getDefaultState();
        }
        return this.getModelLocation(state);
    }
}

