/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.sawmill;

import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.sawmill.TileSawmill;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockSawmill
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSawmill() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0) | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileSawmill) {
            return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(((TileSawmill)tileentity).isBurning()));
        }
        return state;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        return (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_185899_b((IBlockAccess)worldIn, pos).func_177229_b((IProperty)POWERED)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double z = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    z += d4;
                    x -= 0.52;
                    break;
                }
                case EAST: {
                    z += d4;
                    x += 0.52;
                    break;
                }
                case NORTH: {
                    x += d4;
                    z -= 0.52;
                    break;
                }
                case SOUTH: {
                    x += d4;
                    z += 0.52;
                }
            }
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSawmill) {
            playerIn.openGui((Object)Survivalist.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSawmill();
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSawmill) {
            BlockSawmill.dropInventoryItems(worldIn, pos, (IItemHandler)((TileSawmill)te).getInventory());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileSawmill) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((TileSawmill)te).getInventory());
        }
        return 0;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

