/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration.drying;

import gigaherz.survivalist.api.Dryable;
import java.util.Collections;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DryingRecipeWrapper
implements IRecipeWrapper {
    private int time;
    private ItemStack output;

    public static IRecipeWrapper wrap(Dryable.DryingRecipe pair) {
        if (pair instanceof Dryable.DryingItemRecipe) {
            return new ItemInput((Dryable.DryingItemRecipe)pair);
        }
        if (pair instanceof Dryable.DryingOreRecipe) {
            return new OreInput((Dryable.DryingOreRecipe)pair);
        }
        throw new RuntimeException("Can not import recipe");
    }

    private static ItemStack copyWithSize(ItemStack middle) {
        middle = middle.func_77946_l();
        middle.func_190920_e(1);
        return middle;
    }

    private DryingRecipeWrapper(ItemStack output, int time) {
        this.output = output;
        this.time = time;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
    }

    public void drawInfo(@Nonnull Minecraft mc, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String label = (double)this.time / 20.0 + "s";
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)150.0f);
        mc.field_71466_p.func_175065_a(label, (float)(58 - mc.field_71466_p.func_78256_a(label)), 14.0f, -1, true);
        GlStateManager.func_179121_F();
    }

    private static class OreInput
    extends DryingRecipeWrapper {
        private String inputOredict;

        private OreInput(String input, ItemStack output, int time) {
            super(output, time);
            this.inputOredict = input;
        }

        public OreInput(Dryable.DryingOreRecipe recipe) {
            this(recipe.getOreName(), DryingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getTime());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, Collections.singletonList(OreDictionary.getOres((String)this.inputOredict)));
            super.getIngredients(ingredients);
        }
    }

    private static class ItemInput
    extends DryingRecipeWrapper {
        private ItemStack inputStack;

        private ItemInput(ItemStack input, ItemStack output, int time) {
            super(output, time);
            this.inputStack = input;
        }

        public ItemInput(Dryable.DryingItemRecipe recipe) {
            this(recipe.getInput(), DryingRecipeWrapper.copyWithSize(recipe.getOutput()), recipe.getTime());
        }

        @Override
        public void getIngredients(IIngredients ingredients) {
            ingredients.setInput(ItemStack.class, (Object)this.inputStack);
            super.getIngredients(ingredients);
        }
    }
}

