/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist.integration;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.mc1120.item.MCItemStack;
import gigaherz.survivalist.Survivalist;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.api.Dryable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class CraftTweakerPlugin {
    public static void init() {
        CraftTweakerAPI.registerClass(DryableZen.class);
        CraftTweakerAPI.registerClass(ChoppableZen.class);
    }

    private static boolean isOredict(IIngredient ing) {
        return ing instanceof IOreDictEntry;
    }

    private static ItemStack toStack(IIngredient ing) {
        Object internal = ing.getInternal();
        if (!(internal instanceof ItemStack)) {
            Survivalist.logger.error("Not a valid item stack: " + ing);
            return ItemStack.field_190927_a;
        }
        return (ItemStack)internal;
    }

    @Nullable
    private static String toOredictName(IIngredient ing) {
        if (!(ing instanceof IOreDictEntry)) {
            return null;
        }
        return ((IOreDictEntry)ing).getName();
    }

    @ZenClass(value="gigaherz.survivalist.Choppable")
    public static class ChoppableZen {
        @ZenMethod
        public static void addRecipe(@Nullable IIngredient input, @Nullable IItemStack output) {
            if (input == null || output == null) {
                Survivalist.logger.error("Required parameters missing for chopping recipe.");
                return;
            }
            if (CraftTweakerPlugin.isOredict(input)) {
                Choppable.ChoppingRecipe recipe = Choppable.registerRecipe(CraftTweakerPlugin.toOredictName(input), CraftTweakerPlugin.toStack((IIngredient)output));
            } else {
                Choppable.ChoppingRecipe recipe = Choppable.registerRecipe(CraftTweakerPlugin.toStack(input), CraftTweakerPlugin.toStack((IIngredient)output));
            }
        }

        @ZenMethod
        public static void addRecipe(@Nullable IIngredient input, @Nullable IItemStack output, double outputMultiplier) {
            if (input == null || output == null) {
                Survivalist.logger.error("Required parameters missing for chopping recipe.");
                return;
            }
            if (CraftTweakerPlugin.isOredict(input)) {
                Choppable.ChoppingRecipe recipe = Choppable.registerRecipe(CraftTweakerPlugin.toOredictName(input), CraftTweakerPlugin.toStack((IIngredient)output)).setOutputMultiplier(outputMultiplier);
            } else {
                Choppable.ChoppingRecipe recipe = Choppable.registerRecipe(CraftTweakerPlugin.toStack(input), CraftTweakerPlugin.toStack((IIngredient)output)).setOutputMultiplier(outputMultiplier);
            }
        }

        @ZenMethod
        public static void addRecipe(@Nullable IIngredient input, @Nullable IItemStack output, double outputMultiplier, double hitCountMultiplier) {
            if (input == null || output == null) {
                Survivalist.logger.error("Required parameters missing for chopping recipe.");
                return;
            }
            if (CraftTweakerPlugin.isOredict(input)) {
                Choppable.registerRecipe(CraftTweakerPlugin.toOredictName(input), CraftTweakerPlugin.toStack((IIngredient)output)).setOutputMultiplier(outputMultiplier).setHitCountMultiplier(hitCountMultiplier);
            } else {
                Choppable.registerRecipe(CraftTweakerPlugin.toStack(input), CraftTweakerPlugin.toStack((IIngredient)output)).setOutputMultiplier(outputMultiplier).setHitCountMultiplier(hitCountMultiplier);
            }
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output) {
            List toRemove = Choppable.RECIPES.stream().filter(recipe -> output.matches((IItemStack)new MCItemStack(recipe.getOutput()))).collect(Collectors.toList());
            Choppable.RECIPES.removeAll(toRemove);
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output, IIngredient input) {
            List toRemove;
            if (CraftTweakerPlugin.isOredict(input)) {
                toRemove = Choppable.RECIPES.stream().filter(recipe -> recipe instanceof Choppable.ChoppingOreRecipe && output.matches((IItemStack)new MCItemStack(recipe.getOutput())) && ((Choppable.ChoppingOreRecipe)recipe).getOreName().equals(CraftTweakerPlugin.toOredictName(input))).collect(Collectors.toList());
                Choppable.RECIPES.removeIf(recipe -> recipe instanceof Choppable.ChoppingOreRecipe && output.matches((IItemStack)new MCItemStack(recipe.getOutput())) && ((Choppable.ChoppingOreRecipe)recipe).getOreName().equals(CraftTweakerPlugin.toOredictName(input)));
            } else {
                toRemove = Choppable.RECIPES.stream().filter(recipe -> recipe instanceof Choppable.ChoppingItemRecipe && output.matches((IItemStack)new MCItemStack(recipe.getOutput())) && input.matches((IItemStack)new MCItemStack(((Choppable.ChoppingItemRecipe)recipe).getInput()))).collect(Collectors.toList());
            }
            Choppable.RECIPES.removeAll(toRemove);
        }
    }

    @ZenClass(value="gigaherz.survivalist.Dryable")
    public static class DryableZen {
        @ZenMethod
        public static void addRecipe(@Nullable IIngredient input, @Nullable IItemStack output, int time) {
            if (input == null || output == null) {
                Survivalist.logger.error("Required parameters missing for drying recipe.");
                return;
            }
            if (CraftTweakerPlugin.isOredict(input)) {
                Dryable.DryingRecipe recipe = Dryable.registerRecipe(CraftTweakerPlugin.toOredictName(input), CraftTweakerPlugin.toStack((IIngredient)output), time);
            } else {
                Dryable.DryingRecipe recipe = Dryable.registerRecipe(CraftTweakerPlugin.toStack(input), CraftTweakerPlugin.toStack((IIngredient)output), time);
            }
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output) {
            List toRemove = Dryable.RECIPES.stream().filter(recipe -> output.matches((IItemStack)new MCItemStack(recipe.getOutput()))).collect(Collectors.toList());
            Dryable.RECIPES.removeAll(toRemove);
        }

        @ZenMethod
        public static void removeRecipe(IIngredient output, IIngredient input) {
            List toRemove = CraftTweakerPlugin.isOredict(input) ? Dryable.RECIPES.stream().filter(recipe -> recipe instanceof Dryable.DryingOreRecipe && output.matches((IItemStack)new MCItemStack(recipe.getOutput())) && ((Dryable.DryingOreRecipe)recipe).getOreName().equals(CraftTweakerPlugin.toOredictName(input))).collect(Collectors.toList()) : Dryable.RECIPES.stream().filter(recipe -> recipe instanceof Dryable.DryingItemRecipe && output.matches((IItemStack)new MCItemStack(recipe.getOutput())) && input.matches((IItemStack)new MCItemStack(((Dryable.DryingItemRecipe)recipe).getInput()))).collect(Collectors.toList());
            Dryable.RECIPES.removeAll(toRemove);
        }
    }
}

