/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.survivalist;

import com.google.common.collect.Lists;
import gigaherz.survivalist.ConfigManager;
import gigaherz.survivalist.GuiHandler;
import gigaherz.survivalist.IModProxy;
import gigaherz.survivalist.api.Choppable;
import gigaherz.survivalist.api.Dryable;
import gigaherz.survivalist.armor.ItemTannedArmor;
import gigaherz.survivalist.chopblock.BlockChopping;
import gigaherz.survivalist.chopblock.TileChopping;
import gigaherz.survivalist.misc.DummyRecipe;
import gigaherz.survivalist.misc.FibersEventHandling;
import gigaherz.survivalist.misc.OreDictionaryHelper;
import gigaherz.survivalist.misc.StringEventHandling;
import gigaherz.survivalist.network.UpdateFields;
import gigaherz.survivalist.rack.BlockRack;
import gigaherz.survivalist.rack.TileRack;
import gigaherz.survivalist.rocks.EntityRock;
import gigaherz.survivalist.rocks.ItemNugget;
import gigaherz.survivalist.rocks.ItemOreRock;
import gigaherz.survivalist.rocks.ItemRock;
import gigaherz.survivalist.rocks.OreMaterial;
import gigaherz.survivalist.rocks.RockMaterial;
import gigaherz.survivalist.rocks.RocksEventHandling;
import gigaherz.survivalist.sawmill.BlockSawmill;
import gigaherz.survivalist.sawmill.TileSawmill;
import gigaherz.survivalist.scraping.EnchantmentScraping;
import gigaherz.survivalist.scraping.ItemBreakingTracker;
import gigaherz.survivalist.scraping.MessageScraping;
import gigaherz.survivalist.slime.SlimeMerger;
import gigaherz.survivalist.torchfire.TorchFireEventHandling;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="survivalist", version="2.1.6", acceptedMinecraftVersions="[1.12.0,1.13.0)", dependencies="after:forestry")
public class Survivalist {
    public static final String MODID = "survivalist";
    public static final String VERSION = "2.1.6";
    private static final String CHANNEL = "survivalist";
    @Mod.Instance(value="survivalist")
    public static Survivalist instance;
    @SidedProxy(clientSide="gigaherz.survivalist.client.ClientProxy", serverSide="gigaherz.survivalist.server.ServerProxy")
    public static IModProxy proxy;
    public static Logger logger;
    private GuiHandler guiHandler = new GuiHandler();
    @GameRegistry.ObjectHolder(value="survivalist:scraping")
    public static EnchantmentScraping scraping;
    @GameRegistry.ObjectHolder(value="survivalist:chainmail")
    public static Item chainmail;
    @GameRegistry.ObjectHolder(value="survivalist:tanned_leather")
    public static Item tanned_leather;
    @GameRegistry.ObjectHolder(value="survivalist:jerky")
    public static Item jerky;
    @GameRegistry.ObjectHolder(value="survivalist:nugget")
    public static ItemNugget nugget;
    @GameRegistry.ObjectHolder(value="survivalist:rock")
    public static ItemRock rock;
    @GameRegistry.ObjectHolder(value="survivalist:rock_ore")
    public static ItemOreRock rock_ore;
    @GameRegistry.ObjectHolder(value="survivalist:dough")
    public static Item dough;
    @GameRegistry.ObjectHolder(value="survivalist:round_bread")
    public static Item round_bread;
    @GameRegistry.ObjectHolder(value="survivalist:hatchet")
    public static Item hatchet;
    @GameRegistry.ObjectHolder(value="survivalist:pick")
    public static Item pick;
    @GameRegistry.ObjectHolder(value="survivalist:spade")
    public static Item spade;
    @GameRegistry.ObjectHolder(value="survivalist:plant_fibres")
    public static Item plant_fibres;
    @GameRegistry.ObjectHolder(value="survivalist:tanned_helmet")
    public static Item tanned_helmet;
    @GameRegistry.ObjectHolder(value="survivalist:tanned_chestplate")
    public static Item tanned_chestplate;
    @GameRegistry.ObjectHolder(value="survivalist:tanned_leggings")
    public static Item tanned_leggings;
    @GameRegistry.ObjectHolder(value="survivalist:tanned_boots")
    public static Item tanned_boots;
    @GameRegistry.ObjectHolder(value="survivalist:rack")
    public static Block rack;
    @GameRegistry.ObjectHolder(value="survivalist:chopping_block")
    public static Block chopping_block;
    @GameRegistry.ObjectHolder(value="survivalist:chopping_block2")
    public static Block chopping_block2;
    @GameRegistry.ObjectHolder(value="survivalist:sawmill")
    public static Block sawmill;
    @GameRegistry.ObjectHolder(value="survivalist:shlop")
    public static SoundEvent shlop;
    public static ItemArmor.ArmorMaterial TANNED_LEATHER;
    public static Item.ToolMaterial TOOL_FLINT;
    public static SimpleNetworkWrapper channel;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{Survivalist.withName(new BlockRack(), "rack"), Survivalist.withName(new BlockChopping.OldLog(), "chopping_block"), Survivalist.withName(new BlockChopping.NewLog(), "chopping_block2", "chopping_block"), Survivalist.withName(new BlockSawmill(), "sawmill")});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{Survivalist.forBlock(rack), Survivalist.forBlock(chopping_block), Survivalist.forBlock(chopping_block2), Survivalist.forBlock(sawmill), Survivalist.withName(new Item(), "chainmail").func_77637_a(CreativeTabs.field_78035_l), Survivalist.withName(new Item(), "tanned_leather").func_77637_a(CreativeTabs.field_78035_l), Survivalist.withName((Item)new ItemTannedArmor(TANNED_LEATHER, 0, EntityEquipmentSlot.HEAD), "tanned_helmet"), Survivalist.withName((Item)new ItemTannedArmor(TANNED_LEATHER, 0, EntityEquipmentSlot.CHEST), "tanned_chestplate"), Survivalist.withName((Item)new ItemTannedArmor(TANNED_LEATHER, 0, EntityEquipmentSlot.LEGS), "tanned_leggings"), Survivalist.withName((Item)new ItemTannedArmor(TANNED_LEATHER, 0, EntityEquipmentSlot.FEET), "tanned_boots"), Survivalist.withName((Item)new ItemFood(4, 1.0f, true), "jerky"), Survivalist.withName(new ItemNugget(), "nugget"), Survivalist.withName(new ItemRock(), "rock"), Survivalist.withName(new ItemOreRock(), "rock_ore"), Survivalist.withName((Item)new ItemFood(5, 0.6f, true){

            public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
                if (ConfigManager.instance.enableBread) {
                    super.func_150895_a(tab, subItems);
                }
            }
        }, "dough"), Survivalist.withName((Item)new ItemFood(8, 0.6f, true){

            public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
                if (ConfigManager.instance.enableBread) {
                    super.func_150895_a(tab, subItems);
                }
            }
        }, "round_bread"), Survivalist.withName(new ItemAxe(TOOL_FLINT, 8.0f, -3.1f){}.func_77637_a(CreativeTabs.field_78040_i), "hatchet"), Survivalist.withName(new ItemPickaxe(TOOL_FLINT){}.func_77637_a(CreativeTabs.field_78040_i), "pick"), Survivalist.withName(new ItemSpade(TOOL_FLINT).func_77637_a(CreativeTabs.field_78040_i), "spade"), Survivalist.withName(new Item(), "plant_fibres").func_77637_a(CreativeTabs.field_78035_l)});
        GameRegistry.registerTileEntity(TileRack.class, (ResourceLocation)rack.getRegistryName());
        GameRegistry.registerTileEntity(TileChopping.class, (ResourceLocation)chopping_block.getRegistryName());
        GameRegistry.registerTileEntity(TileSawmill.class, (ResourceLocation)sawmill.getRegistryName());
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(Survivalist.location("mob.slime.merge")).setRegistryName(Survivalist.location("shlop"))});
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{Survivalist.withName(new EnchantmentScraping(), "scraping")});
    }

    private static void registerOredictNames() {
        OreDictionary.registerOre((String)"materialLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"materialTannedLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"materialHardenedLeather", (Item)tanned_leather);
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)nugget.getStack(OreMaterial.IRON));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)nugget.getStack(OreMaterial.COPPER));
        OreDictionary.registerOre((String)"nuggetTin", (ItemStack)nugget.getStack(OreMaterial.TIN));
        OreDictionary.registerOre((String)"nuggetLead", (ItemStack)nugget.getStack(OreMaterial.LEAD));
        OreDictionary.registerOre((String)"nuggetSilver", (ItemStack)nugget.getStack(OreMaterial.SILVER));
        OreDictionary.registerOre((String)"nuggetAluminum", (ItemStack)nugget.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"nuggetAluminium", (ItemStack)nugget.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"rockOreIron", (ItemStack)rock_ore.getStack(OreMaterial.IRON));
        OreDictionary.registerOre((String)"rockOreGold", (ItemStack)rock_ore.getStack(OreMaterial.GOLD));
        OreDictionary.registerOre((String)"rockOreCopper", (ItemStack)rock_ore.getStack(OreMaterial.COPPER));
        OreDictionary.registerOre((String)"rockOreTin", (ItemStack)rock_ore.getStack(OreMaterial.TIN));
        OreDictionary.registerOre((String)"rockOreLead", (ItemStack)rock_ore.getStack(OreMaterial.LEAD));
        OreDictionary.registerOre((String)"rockOreSilver", (ItemStack)rock_ore.getStack(OreMaterial.SILVER));
        OreDictionary.registerOre((String)"rockOreAluminum", (ItemStack)rock_ore.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"rockOreAluminium", (ItemStack)rock_ore.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"oreNuggetIron", (ItemStack)rock_ore.getStack(OreMaterial.IRON));
        OreDictionary.registerOre((String)"oreNuggetGold", (ItemStack)rock_ore.getStack(OreMaterial.GOLD));
        OreDictionary.registerOre((String)"oreNuggetCopper", (ItemStack)rock_ore.getStack(OreMaterial.COPPER));
        OreDictionary.registerOre((String)"oreNuggetTin", (ItemStack)rock_ore.getStack(OreMaterial.TIN));
        OreDictionary.registerOre((String)"oreNuggetLead", (ItemStack)rock_ore.getStack(OreMaterial.LEAD));
        OreDictionary.registerOre((String)"oreNuggetSilver", (ItemStack)rock_ore.getStack(OreMaterial.SILVER));
        OreDictionary.registerOre((String)"oreNuggetAluminium", (ItemStack)rock_ore.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"oreNuggetAluminium", (ItemStack)rock_ore.getStack(OreMaterial.ALUMINUM));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.NORMAL));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.ANDESITE));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.DIORITE));
        OreDictionary.registerOre((String)"rock", (ItemStack)rock.getStack(RockMaterial.GRANITE));
        OreDictionary.registerOre((String)"rockAndesite", (ItemStack)rock.getStack(RockMaterial.ANDESITE));
        OreDictionary.registerOre((String)"rockDiorite", (ItemStack)rock.getStack(RockMaterial.DIORITE));
        OreDictionary.registerOre((String)"rockGranite", (ItemStack)rock.getStack(RockMaterial.GRANITE));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Survivalist.registerOredictNames();
        Dryable.registerStockRecipes();
        Choppable.registerStockRecipes();
        Survivalist.replaceVanillaRecipes();
    }

    private void registerNetwork() {
        logger.info("Registering network channel...");
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("survivalist");
        int messageNumber = 0;
        channel.registerMessage(MessageScraping.Handler.class, MessageScraping.class, messageNumber++, Side.CLIENT);
        channel.registerMessage(UpdateFields.Handler.class, UpdateFields.class, messageNumber++, Side.CLIENT);
        logger.debug("Final message number: " + messageNumber);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        ConfigManager.loadConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if (ConfigManager.instance.enableTorchFire) {
            TorchFireEventHandling.register();
        }
        if (ConfigManager.instance.enableScraping) {
            ItemBreakingTracker.register();
        }
        if (ConfigManager.instance.enableRocks) {
            RocksEventHandling.register();
        }
        if (ConfigManager.instance.dropFibersFromGrass) {
            FibersEventHandling.register();
        }
        if (ConfigManager.instance.dropStringFromSheep) {
            StringEventHandling.register();
        }
        if (ConfigManager.instance.mergeSlimes) {
            SlimeMerger.register();
        }
        this.registerNetwork();
        proxy.preInit();
        if (Loader.isModLoaded((String)"crafttweaker")) {
            try {
                Class.forName("gigaherz.survivalist.integration.CraftTweakerPlugin").getMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new ReportedException(new CrashReport("Error initializing minetweaker integration", (Throwable)e));
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        int entityId = 1;
        EntityRegistry.registerModEntity((ResourceLocation)Survivalist.location("thrown_rock"), EntityRock.class, (String)"ThrownRock", (int)entityId++, (Object)this, (int)80, (int)3, (boolean)true);
        logger.debug("Last used id: %i", (Object)entityId);
        TOOL_FLINT.setRepairItem(new ItemStack(Items.field_151145_ak));
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.IRON), "nuggetIron");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.GOLD), "nuggetGold");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.COPPER), "nuggetCopper");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.TIN), "nuggetTin");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.LEAD), "nuggetLead");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.SILVER), "nuggetSilver");
        Survivalist.addSmeltingNugget(rock_ore.getStack(OreMaterial.ALUMINUM), "nuggetAluminum");
        GameRegistry.addSmelting((Item)dough, (ItemStack)new ItemStack(round_bread), (float)0.0f);
    }

    private static void addSmeltingNugget(ItemStack stack, String ore) {
        NonNullList matches = OreDictionary.getOres((String)ore);
        if (matches.size() > 0) {
            GameRegistry.addSmelting((ItemStack)stack, (ItemStack)((ItemStack)matches.get(0)), (float)0.1f);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ConfigManager.instance.parseChoppingAxes();
    }

    private static void replaceVanillaRecipes() {
        ItemStack output;
        ForgeRegistry recipeRegistry = (ForgeRegistry)ForgeRegistries.RECIPES;
        ArrayList recipes = Lists.newArrayList((Iterable)recipeRegistry.getValuesCollection());
        logger.warn("#################################");
        logger.warn("## Removing vanilla recipes if enabled in settings, 'Dangerous alternative' messages are expected and not a bug...");
        if (ConfigManager.instance.enableBread && ConfigManager.instance.removeVanillaBread) {
            for (IRecipe r : recipes) {
                output = r.func_77571_b();
                if (output.func_77973_b() != Items.field_151025_P) continue;
                recipeRegistry.remove(r.getRegistryName());
                recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(r));
            }
        }
        if (ConfigManager.instance.removeSticksFromPlanks) {
            for (IRecipe r : recipes) {
                boolean isPlanksInput;
                output = r.func_77571_b();
                int ore = OreDictionary.getOreID((String)"plankWood");
                if (output.func_77973_b() != Items.field_151055_y || !(isPlanksInput = r.func_192400_c().stream().allMatch(ingredient -> Arrays.stream(ingredient.func_193365_a()).anyMatch(input -> ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)input), (int)ore))))) continue;
                recipeRegistry.remove(r.getRegistryName());
                recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(r));
            }
        }
        if (ConfigManager.instance.importPlanksRecipes || ConfigManager.instance.removePlanksRecipes) {
            for (IRecipe r : recipes) {
                output = r.func_77571_b();
                if (output.func_190916_E() <= 0 || !OreDictionaryHelper.hasOreName(output, "plankWood")) continue;
                NonNullList inputs = r.func_192400_c();
                Ingredient logInput = null;
                for (Ingredient input : inputs) {
                    boolean anyWood = false;
                    for (ItemStack stack : input.func_193365_a()) {
                        if (!OreDictionaryHelper.hasOreName(stack, "logWood")) continue;
                        anyWood = true;
                    }
                    if (!anyWood || logInput != null) {
                        logInput = null;
                        break;
                    }
                    logInput = input;
                }
                if (logInput == null) continue;
                if (ConfigManager.instance.removePlanksRecipes) {
                    recipeRegistry.remove(r.getRegistryName());
                    recipeRegistry.register((IForgeRegistryEntry)DummyRecipe.from(r));
                }
                if (!ConfigManager.instance.importPlanksRecipes) continue;
                for (ItemStack stack : logInput.func_193365_a()) {
                    Choppable.registerRecipe(stack.func_77946_l(), output.func_77946_l());
                }
            }
        }
        logger.warn("## Vanilla recipes removed.");
    }

    private static Item withName(Item item, String name) {
        return ((Item)item.setRegistryName(name)).func_77655_b("survivalist." + name);
    }

    private static Block withName(Block block, String name) {
        return ((Block)block.setRegistryName(name)).func_149663_c("survivalist." + name);
    }

    private static Block withName(Block block, String name, String translationBaseName) {
        return ((Block)block.setRegistryName(name)).func_149663_c("survivalist." + translationBaseName);
    }

    private static Enchantment withName(Enchantment block, String name) {
        return ((Enchantment)block.setRegistryName(name)).func_77322_b("survivalist." + name);
    }

    private static Item forBlock(Block block) {
        return (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("survivalist", path);
    }

    static {
        TANNED_LEATHER = EnumHelper.addArmorMaterial((String)"tanned_leather", (String)"survivalist:tanned_leather", (int)12, (int[])new int[]{1, 2, 3, 1}, (int)15, (SoundEvent)SoundEvents.field_187728_s, (float)1.0f);
        TOOL_FLINT = EnumHelper.addToolMaterial((String)"flint", (int)1, (int)150, (float)5.0f, (float)1.5f, (int)5);
    }
}

