/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.world;

import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import crimson_twilight.immersive_energy.common.Config;
import crimson_twilight.immersive_energy.common.util.IEnLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class IEnWorldGen
implements IWorldGenerator {
    public static ArrayList<OreGen> orespawnList = new ArrayList();
    public static ArrayList<Integer> oreDimBlacklist = new ArrayList();
    public static HashMap<String, Boolean> retrogenMap = new HashMap();
    public static ArrayListMultimap<Integer, ChunkPos> retrogenChunks = ArrayListMultimap.create();

    public static OreGen addOreGen(String name, IBlockState state, int maxVeinSize, int minY, int maxY, int chunkOccurence, int weight) {
        OreGen gen = new OreGen(name, state, maxVeinSize, Blocks.field_150348_b, minY, maxY, chunkOccurence, weight);
        orespawnList.add(gen);
        return gen;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOres(random, chunkX, chunkZ, world, true);
    }

    public void generateOres(Random random, int chunkX, int chunkZ, World world, boolean newGeneration) {
        if (world.field_73011_w.getDimension() != 1 && world.field_73011_w.getDimension() != -1) {
            for (OreGen gen : orespawnList) {
                if (!newGeneration && !retrogenMap.get("retrogen_" + gen.name).booleanValue()) continue;
                gen.generate(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = new NBTTagCompound();
        event.getData().func_74782_a("ImmersiveEnergy", (NBTBase)nbt);
        nbt.func_74757_a(Config.IEnConfig.Ores.retrogen_key, true);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        int dimension = event.getWorld().field_73011_w.getDimension();
        if (!event.getData().func_74775_l("ImmersiveEnergy").func_74764_b(Config.IEnConfig.Ores.retrogen_key) && (Config.IEnConfig.Ores.retrogen_thorium || Config.IEnConfig.Ores.retrogen_tungsten)) {
            if (Config.IEnConfig.Ores.retrogen_log_flagChunk) {
                IEnLogger.info("Chunk " + event.getChunk().func_76632_l() + " has been flagged for Ore RetroGeneration by IEn.");
            }
            retrogenChunks.put((Object)dimension, (Object)event.getChunk().func_76632_l());
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START) {
            return;
        }
        int dimension = event.world.field_73011_w.getDimension();
        int counter = 0;
        List chunks = retrogenChunks.get((Object)dimension);
        if (chunks != null && chunks.size() > 0) {
            for (int i = 0; i < 2 && (chunks = retrogenChunks.get((Object)dimension)) != null && chunks.size() > 0; ++i) {
                ++counter;
                ChunkPos loc = (ChunkPos)chunks.get(0);
                long worldSeed = event.world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)loc.field_77276_a + zSeed * (long)loc.field_77275_b ^ worldSeed);
                this.generateOres(fmlRandom, loc.field_77276_a, loc.field_77275_b, event.world, false);
                chunks.remove(0);
            }
        }
        if (counter > 0 && Config.IEnConfig.Ores.retrogen_log_remaining) {
            IELogger.info((Object)("Retrogen was performed on " + counter + " Chunks, " + Math.max(0, chunks.size()) + " chunks remaining"));
        }
    }

    public static class OreGen {
        String name;
        WorldGenMinable mineableGen;
        int minY;
        int maxY;
        int chunkOccurence;
        int weight;

        public OreGen(String name, IBlockState state, int maxVeinSize, Block replaceTarget, int minY, int maxY, int chunkOccurence, int weight) {
            this.name = name;
            this.mineableGen = new WorldGenMinable(state, maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)replaceTarget));
            this.minY = minY;
            this.maxY = maxY;
            this.chunkOccurence = chunkOccurence;
            this.weight = weight;
            System.out.println("OreGen!");
        }

        public void generate(World world, Random rand, int x, int z) {
            for (int i = 0; i < this.chunkOccurence; ++i) {
                if (rand.nextInt(100) >= this.weight) continue;
                BlockPos pos = new BlockPos(x + rand.nextInt(16), this.minY + rand.nextInt(this.maxY - this.minY), z + rand.nextInt(16));
                this.mineableGen.func_180709_b(world, rand, pos);
            }
        }
    }
}

