/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.items;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import crimson_twilight.immersive_energy.ImmersiveEnergy;
import crimson_twilight.immersive_energy.common.IEnContent;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ToolUpgradeableCrossbow
extends ItemUpgradeableTool
implements ITool,
IEItemInterfaces.IItemDamageableIE,
EnergyHelper.IIEEnergyItem {
    int durability;
    private boolean needsEnergy;
    private boolean isLoaded;
    private ItemStack ammo = ItemStack.field_190927_a;
    private static final IElectricEquipment.ElectricSource TC_FIELD = new IElectricEquipment.ElectricSource(1.0f);

    public ToolUpgradeableCrossbow() {
        super("upgradeable_crossbow", 1, "CROSSBOW", new String[0]);
        this.canRepair = false;
        this.func_77627_a(false);
        this.fixupItem();
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersive_energy." + this.itemName);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        boolean electro = this.getUpgrades(stack).func_74767_n("electro");
        boolean isFast = this.getUpgrades(stack).func_74767_n("fast");
        this.needsEnergy = electro || isFast;
    }

    protected ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int count) {
        int recharge;
        boolean isFast = this.getUpgrades(stack).func_74767_n("fast");
        int n = recharge = isFast ? 16000 : 144000;
        if (entity instanceof EntityPlayer && this.ammo == ItemStack.field_190927_a) {
            EntityPlayer player = (EntityPlayer)entity;
            if (count >= recharge) {
                this.ammo = this.findAmmo(player);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        boolean flag;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)handIn, (boolean)(flag = !this.findAmmo(playerIn).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return flag ? new ActionResult(EnumActionResult.PASS, (Object)itemstack) : new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public int func_77619_b() {
        return 1;
    }

    public EntityArrow customizeArrow(EntityArrow arrow) {
        return arrow;
    }

    public float getArrowVelocity(ItemStack stack) {
        float f = 30.0f;
        boolean isFast = this.getUpgrades(stack).func_74767_n("fast");
        if (isFast) {
            f = 50.0f;
        }
        return f;
    }

    protected boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean isTool(ItemStack arg0) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return stack.func_77960_j() != 3;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 1, 80, 32, "CROSSBOW", stack, true), new IESlot.Upgrades(container, inv, 2, 100, 48, "CROSSBOW", stack, true), new IESlot.Upgrades(container, inv, 3, 120, 32, "CROSSBOW", stack, true)};
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound ret = super.getNBTShareTag(stack);
        ret = ret == null ? new NBTTagCompound() : ret.func_74737_b();
        return ret;
    }

    public int getSlotCount(ItemStack stack) {
        return 4;
    }

    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)this.getMaxEnergyStored(stack));
        }
    }

    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)this.getMaxEnergyStored(stack));
        }
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    private void damageIETool(ItemStack stack, int amount, Random rand, @Nullable EntityPlayer player) {
        if (amount <= 0) {
            return;
        }
        int unbreakLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        for (int i = 0; unbreakLevel > 0 && i < amount; ++i) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)unbreakLevel, (Random)rand)) continue;
            --amount;
        }
        if (amount <= 0) {
            return;
        }
        int curDamage = ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
        curDamage += amount;
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)player, stack, curDamage);
        }
        if (curDamage >= this.durability) {
            if (player != null) {
                player.func_70669_a(stack);
                player.func_71029_a(StatList.func_188059_c((Item)this));
            }
            stack.func_190918_g(1);
            return;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)curDamage);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_185312_x || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_185311_w || enchantment == Enchantments.field_185310_v || enchantment == Enchantments.field_185309_u;
    }

    public int getMaxDamageIE(ItemStack stack) {
        return this.durability;
    }

    public int getItemDamageIE(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        this.damageIETool(container, 1, Utils.RAND, null);
        return container;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        boolean electro = this.getUpgrades(stack).func_74767_n("electro");
        if (electro) {
            String stored = this.getEnergyStored(stack) + "/" + 1600;
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
        if (this.ammo != ItemStack.field_190927_a) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.arrowType", (Object[])new Object[]{this.ammo.func_82833_r()}));
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.empty", (Object[])new Object[0]));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getMaxDamageIE(stack);
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") / max;
    }

    public int getMaxEnergyStored(ItemStack arg0) {
        if (this.needsEnergy) {
            return 1600;
        }
        return 0;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    super(x0);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    return (T)super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }
}

