/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.items;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityChargingStation;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RotationUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.advancements.IEAdvancements;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import crimson_twilight.immersive_energy.ImmersiveEnergy;
import crimson_twilight.immersive_energy.common.IEnContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.BaseAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ToolHeftyWrench
extends ItemUpgradeableTool
implements ITool,
IEItemInterfaces.IItemDamageableIE,
EnergyHelper.IIEEnergyItem,
IOBJModelCallback<ItemStack> {
    public static final int DURABILITY = 256;
    public static final double ATTACK_DAMAGE = 6.0;
    public static final double THERMAL_DAMAGE = 2.0;
    public static final float ELECTRIC_DAMAGE = 6.0f;
    public static final double MAGICAL_DAMAGE = 4.0;
    public static BaseAttribute basicDamage = new RangedAttribute(SharedMonsterAttributes.field_111264_e, "immersive_energy.basicdamage", 6.0, 0.0, Double.MAX_VALUE);
    public static BaseAttribute thermalDamage = new RangedAttribute(null, "immersive_energy.thermaldamage", 0.0, 0.0, Double.MAX_VALUE);
    public static BaseAttribute electricDamage = new RangedAttribute(null, "immersive_energy.electricdamage", 0.0, 0.0, Double.MAX_VALUE);
    public static BaseAttribute magicalDamage = new RangedAttribute(null, "immersive_energy.magicaldamage", 0.0, 0.0, Double.MAX_VALUE);
    public static List<Predicate<TileEntity>> tileEntitiesToIgnore = new ArrayList<Predicate<TileEntity>>();

    public ToolHeftyWrench() {
        super("hefty_wrench", 1, "HEFTYWRENCH", new String[0]);
        this.func_77627_a(false);
        this.func_77656_e(256);
        this.fixupItem();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 12;
    }

    public void fixupItem() {
        Item rItem = (Item)IEContent.registeredIEItems.remove(IEContent.registeredIEItems.size() - 1);
        if (rItem != this) {
            throw new IllegalStateException("fixupItem was not called at the appropriate time");
        }
        this.func_77655_b("immersive_energy." + this.itemName);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.8, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 6.0, 0));
        }
        return multimap;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.contains("UpgradeCapacitor")) {
            return this.hasCapacitor(stack);
        }
        if (group.equals("Z_TubeMagic")) {
            return this.hasMagic(stack);
        }
        if (group.equals("Z_TubePowered")) {
            return this.hasElectro(stack);
        }
        if (group.equals("Z_TubeThermal")) {
            return this.hasThermal(stack);
        }
        if (group.contains("UpgradeElectronTubes") || group.contains("A_ElectronTube")) {
            return this.hasMagic(stack) || this.hasElectro(stack) || this.hasThermal(stack);
        }
        return true;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return attacker.field_70721_aZ == 0.0f;
    }

    public double getAttackDamage() {
        return 6.0;
    }

    private boolean hasElectro(ItemStack stack) {
        return this.getUpgrades(stack).func_74764_b("electro");
    }

    private boolean hasThermal(ItemStack stack) {
        return this.getUpgrades(stack).func_74764_b("thermal");
    }

    private boolean hasMagic(ItemStack stack) {
        return this.getUpgrades(stack).func_74764_b("magic");
    }

    private boolean hasCapacitor(ItemStack stack) {
        return this.getUpgrades(stack).func_74764_b("capacitor");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        int drain = 1600 - 300 * EnchantmentHelper.func_185293_e((EntityLivingBase)attacker);
        if (drain < 0) {
            drain = 0;
        }
        if (drain > 1600) {
            drain = 1600;
        }
        Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        if (this.hasElectro(stack) && this.extractEnergy(stack, drain, true) >= drain) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)(this.getEnergyStored(stack) - drain));
            target.field_70172_ad = 0;
            IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage((float)6.0f, (boolean)true);
            if (dmgsrc.apply((Entity)target)) {
                target.func_70690_d(new PotionEffect(IEPotions.stunned, 128));
            }
        }
        if (this.hasThermal(stack) && this.extractEnergy(stack, drain, true) >= drain) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)(this.getEnergyStored(stack) - drain));
            int duration = 4 + 4 * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack);
            target.func_70015_d(duration);
            this.attack(stack, target, (Multimap<String, AttributeModifier>)multimap, thermalDamage, DamageSource.field_76372_a, attacker);
        }
        if (this.hasMagic(stack) && this.extractEnergy(stack, drain, true) >= drain) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)(this.getEnergyStored(stack) - drain));
            this.attack(stack, target, (Multimap<String, AttributeModifier>)multimap, magicalDamage, DamageSource.field_76376_m, attacker);
            target.func_70690_d(new PotionEffect(IEPotions.flashed, 128));
        }
        stack.func_77972_a(1, attacker);
        return true;
    }

    public void attack(ItemStack stack, EntityLivingBase target, Multimap<String, AttributeModifier> multimap, BaseAttribute attribute, DamageSource source, EntityLivingBase attacker) {
        float amount = this.getAmount(stack, target, multimap, attribute);
        if (amount > 0.0f) {
            target.field_70172_ad = 0;
            target.func_70097_a(source, amount *= ((EntityPlayer)attacker).func_184825_o(0.0f));
        }
    }

    public void normalAttack(ItemStack stack, EntityLivingBase target, BaseAttribute attribute, EntityLivingBase attacker, float mult) {
        float amount = (float)(6.0 * (double)mult);
        if (amount > 0.0f) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76377_j, amount);
        }
    }

    public float getAmount(ItemStack stack, EntityLivingBase target, Multimap<String, AttributeModifier> multimap, BaseAttribute attribute) {
        float amount = 0.0f;
        Collection gsd = multimap.get((Object)attribute.func_111108_a());
        if (gsd != null) {
            for (AttributeModifier t : gsd) {
                float d0 = (float)t.func_111164_d();
                if (t.func_111167_a() == Item.field_111210_e) {
                    d0 = (float)((double)d0 + (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)target.func_70668_bt()));
                }
                amount += d0;
            }
        }
        return amount;
    }

    public boolean canModify(ItemStack stack) {
        return stack.func_77960_j() != 1;
    }

    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, inv, 0, 100, 26, "HEFTYWRENCH_HEAD", stack, true), new IESlot.Upgrades(container, inv, 1, 100, 48, "HEFTYWRENCH_HANDLE", stack, true)};
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound ret = super.getNBTShareTag(stack);
        ret = ret == null ? new NBTTagCompound() : ret.func_74737_b();
        return ret;
    }

    public int getSlotCount(ItemStack stack) {
        return 2;
    }

    public void recalculateUpgrades(ItemStack stack) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.clearUpgrades(stack);
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        NBTTagCompound upgradeTag = this.getUpgradeBase(stack).func_74737_b();
        if (inv != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack u = inv.getStackInSlot(i);
                if (u.func_190926_b() || !(u.func_77973_b() instanceof IUpgrade)) continue;
                IUpgrade upg = (IUpgrade)u.func_77973_b();
                upg.applyUpgrades(stack, u, upgradeTag);
            }
            ItemNBTHelper.setTagCompound((ItemStack)stack, (String)"upgrades", (NBTTagCompound)upgradeTag);
            if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)this.getMaxEnergyStored(stack));
            }
            this.finishUpgradeRecalculation(stack);
        }
    }

    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
    }

    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        int drain = 1600 - 300 * EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        if (drain < 0) {
            drain = 0;
        }
        if (drain > 1600) {
            drain = 1600;
        }
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && this.getEnergyStored(stack) >= drain) {
            if (this.hasMagic(stack)) {
                multimap.put((Object)magicalDamage.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 4.0, 0));
            }
            if (this.hasElectro(stack)) {
                multimap.put((Object)electricDamage.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 6.0, 0));
            }
            if (this.hasThermal(stack)) {
                multimap.put((Object)thermalDamage.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Weapon modifier", 2.0 + (double)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack), 0));
            }
        }
        return multimap;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        int i = ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
        if (i > stack.func_77952_i()) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)stack.func_77952_i());
        }
        double randomNum = Math.random();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0 && randomNum > 0.96) {
            if (i > 0) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)(i - 1));
                stack.func_77964_b(ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage"));
            } else if (this.getEnergyStored(stack) < this.getMaxEnergyStored(stack) && this.getEnergyStored(stack) < 1600) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)"energy", (int)(this.getEnergyStored(stack) + 1));
            }
        }
    }

    private void damageIETool(ItemStack stack, int amount, Random rand, @Nullable EntityPlayer player) {
        if (amount <= 0) {
            return;
        }
        int unbreakLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
        for (int i = 0; unbreakLevel > 0 && i < amount; ++i) {
            if (!EnchantmentDurability.func_92097_a((ItemStack)stack, (int)unbreakLevel, (Random)rand)) continue;
            --amount;
        }
        if (amount <= 0) {
            return;
        }
        int curDamage = ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
        curDamage += amount;
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)player, stack, curDamage);
        }
        if (curDamage >= 256) {
            if (player != null) {
                player.func_70669_a(stack);
                player.func_71029_a(StatList.func_188059_c((Item)this));
            }
            stack.func_190918_g(1);
            return;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)"Damage", (int)curDamage);
        stack.func_77964_b(curDamage);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (stack.func_77948_v()) {
            return false;
        }
        return enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185296_A || enchantment == Enchantments.field_77334_n;
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        player.func_184609_a(hand);
        if (this.performHammerFunctions(player, world, pos, side, hitX, hitY, hitZ, hand)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    boolean performHammerFunctions(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean b;
        int i;
        Object list;
        ItemStack stack = player.func_184586_b(hand);
        String[] permittedMultiblocks = null;
        String[] interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission")) {
            list = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
            permittedMultiblocks = new String[list.func_74745_c()];
            for (i = 0; i < permittedMultiblocks.length; ++i) {
                permittedMultiblocks[i] = list.func_150307_f(i);
            }
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction")) {
            list = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
            interdictedMultiblocks = new String[list.func_74745_c()];
            for (i = 0; i < interdictedMultiblocks.length; ++i) {
                interdictedMultiblocks[i] = list.func_150307_f(i);
            }
        }
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            if (!mb.isBlockTrigger(world.func_180495_p(pos))) continue;
            boolean bl = b = permittedMultiblocks == null;
            if (permittedMultiblocks != null) {
                for (String s : permittedMultiblocks) {
                    if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                    b = true;
                }
            }
            if (!b) break;
            if (interdictedMultiblocks != null) {
                for (String s : interdictedMultiblocks) {
                    if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                    b = false;
                }
            }
            if (!b) break;
            if (MultiblockHandler.fireMultiblockFormationEventPre((EntityPlayer)player, (MultiblockHandler.IMultiblock)mb, (BlockPos)pos, (ItemStack)stack).isCanceled() || !mb.createStructure(world, pos, side, player)) continue;
            if (player instanceof EntityPlayerMP) {
                IEAdvancements.TRIGGER_MULTIBLOCK.trigger((EntityPlayerMP)player, mb, stack);
            }
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEBlockInterfaces.IConfigurableSides && !world.field_72995_K) {
            int iSide;
            int n = iSide = player.func_70093_af() ? side.func_176734_d().ordinal() : side.ordinal();
            if (((IEBlockInterfaces.IConfigurableSides)tile).toggleSide(iSide, player)) {
                return true;
            }
        } else {
            if (tileEntitiesToIgnore.stream().noneMatch(tileEntityPredicate -> tileEntityPredicate.test(tile)) && tile instanceof IEBlockInterfaces.IDirectionalTile && ((IEBlockInterfaces.IDirectionalTile)tile).canHammerRotate(side, hitX, hitY, hitZ, (EntityLivingBase)player) && !world.field_72995_K) {
                EnumFacing f;
                EnumFacing oldF = f = ((IEBlockInterfaces.IDirectionalTile)tile).getFacing();
                int limit = ((IEBlockInterfaces.IDirectionalTile)tile).getFacingLimitation();
                if (limit == 0) {
                    f = EnumFacing.field_82609_l[(f.ordinal() + 1) % EnumFacing.field_82609_l.length];
                } else if (limit == 1) {
                    f = player.func_70093_af() ? f.func_176732_a(side.func_176740_k()).func_176734_d() : f.func_176732_a(side.func_176740_k());
                } else if (limit == 2 || limit == 5) {
                    f = player.func_70093_af() ? f.func_176735_f() : f.func_176746_e();
                }
                ((IEBlockInterfaces.IDirectionalTile)tile).setFacing(f);
                ((IEBlockInterfaces.IDirectionalTile)tile).afterRotation(oldF, f);
                tile.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
                world.func_175641_c(tile.func_174877_v(), tile.func_145838_q(), 255, 0);
                return true;
            }
            if (tile instanceof IEBlockInterfaces.IHammerInteraction && !world.field_72995_K && (b = ((IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, hitX, hitY, hitZ))) {
                return b;
            }
        }
        return false;
    }

    public int getMaxDamageIE(ItemStack stack) {
        return 256;
    }

    public int getItemDamageIE(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.func_77946_l();
        this.damageIETool(container, 1, Utils.RAND, null);
        return container;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        int i;
        String s;
        NBTTagList tagList;
        int[] link;
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"linkingPos") && (link = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"linkingPos")) != null && link.length > 3) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockPermission")) {
            tagList = stack.func_77978_p().func_150295_c("multiblockPermission", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblocksAllowed", (Object[])new Object[0]);
            if (!GuiScreen.func_146272_n()) {
                list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
            } else {
                list.add(s);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                }
            }
        }
        if (ItemNBTHelper.hasKey((ItemStack)stack, (String)"multiblockInterdiction")) {
            tagList = stack.func_77978_p().func_150295_c("multiblockInterdiction", 8);
            s = I18n.func_135052_a((String)"desc.immersiveengineering.info.multiblockForbidden", (Object[])new Object[0]);
            if (!GuiScreen.func_146272_n()) {
                list.add(s + " " + I18n.func_135052_a((String)"desc.immersiveengineering.info.holdShift", (Object[])new Object[0]));
            } else {
                list.add(s);
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    list.add(TextFormatting.DARK_GRAY + " " + I18n.func_135052_a((String)("desc.immersiveengineering.info.multiblock." + tagList.func_150307_f(i)), (Object[])new Object[0]));
                }
            }
        }
        if (this.hasElectro(stack)) {
            list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"desc.immersiveengineering.electro", (Object[])new Object[0]));
        }
        if (this.hasThermal(stack)) {
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"desc.immersiveengineering.thermal", (Object[])new Object[0]));
        }
        if (this.hasMagic(stack)) {
            list.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"desc.immersiveengineering.magic", (Object[])new Object[0]));
        }
        if (this.getMaxEnergyStored(stack) > 0) {
            String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
        float integrity = 100.0f - (float)this.getDurabilityForDisplay(stack) * 100.0f;
        list.add(String.format("%s %.2f %%", I18n.func_135052_a((String)"desc.immersiveengineering.info.integrity", (Object[])new Object[0]), Float.valueOf(integrity)));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static float getChargeUpDamageModifyer(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.5f) {
            f = 1.5f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            Entity entity;
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            int i = this.func_77626_a(stack) - timeLeft;
            if (ToolHeftyWrench.getEntityPlayerLookedAt((float)entityplayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e()) != null && (entity = ToolHeftyWrench.getEntityPlayerLookedAt((float)entityplayer.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e())) instanceof EntityLivingBase) {
                Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
                EntityLivingBase target = (EntityLivingBase)entity;
                float j = ToolHeftyWrench.getChargeUpDamageModifyer(i);
                if (6.0 * (double)j >= 1.0) {
                    this.normalAttack(stack, target, basicDamage, entityLiving, j);
                }
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.func_184598_c(hand);
        if (this.performHammerFunctions(player, world, pos, side, hitX, hitY, hitZ, hand)) {
            System.out.print("hammer");
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        return !player.field_70170_p.field_72995_K & RotationUtil.rotateEntity((Entity)entity, (EntityPlayer)player);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double max = this.getMaxDamageIE(stack);
        return (double)ItemNBTHelper.getInt((ItemStack)stack, (String)"Damage") / max;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName((ItemStack)material, (String)"ingotSteel");
    }

    public int getMaxEnergyStored(ItemStack stack) {
        int storage = 0;
        if (this.hasElectro(stack) || this.hasThermal(stack) || this.hasMagic(stack)) {
            storage += 1600;
        }
        if (this.hasCapacitor(stack)) {
            storage += 28800;
        }
        return storage;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    super(x0);
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
                }

                public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityEnergy.ENERGY) {
                        return (T)this.energyStorage;
                    }
                    return (T)super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public boolean func_77662_d() {
        return true;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"II_ADVANCED_HAMMER");
    }

    public boolean isTool(ItemStack item) {
        return true;
    }

    public static Entity getEntityPlayerLookedAt(float dist) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72314_b(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72321_a((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72321_a((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                return pointedEntity;
            }
        }
        return null;
    }

    static {
        tileEntitiesToIgnore.add(tileEntity -> tileEntity instanceof TileEntityChargingStation);
    }
}

