/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.items;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.items.ItemPowerpack;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.google.common.collect.Multimap;
import crimson_twilight.immersive_energy.ImmersiveEnergy;
import crimson_twilight.immersive_energy.common.IEnContent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="immersive_energy")
public class ItemPowerArmorChestplate
extends ItemArmor
implements IElectricEquipment,
EnergyHelper.IIEEnergyItem {
    public static ItemArmor.ArmorMaterial mat = IEnContent.powerArmor;
    private static int armor = mat.func_78044_b(EntityEquipmentSlot.CHEST);
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public ItemPowerArmorChestplate() {
        super(mat, armor, EntityEquipmentSlot.CHEST);
        String name = "power_armor_suit_body";
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(1);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        float integrity = 100.0f - (float)this.getDurabilityForDisplay(stack) * 100.0f;
        list.add(String.format("%s %.2f %%", I18n.func_135052_a((String)"desc.immersiveengineering.info.integrity", (Object[])new Object[0]), Float.valueOf(integrity)));
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    public static void playReducedSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 0.1f;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        int energy = this.getEnergyStored(itemStack);
        if (energy > 0) {
            int pre = energy;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                if (!EnergyHelper.isFluxItem((ItemStack)player.func_184582_a(slot)) || player.func_184582_a(slot).func_77973_b() instanceof ItemPowerArmorChestplate || player.func_184582_a(slot).func_77973_b() instanceof ItemPowerpack) continue;
                energy -= EnergyHelper.insertFlux((ItemStack)player.func_184582_a(slot), (int)Math.min(energy, Config.IEConfig.Machines.capacitorHV_output), (boolean)false);
            }
            if (pre != energy) {
                EnergyHelper.extractFlux((ItemStack)itemStack, (int)(pre - energy), (boolean)false);
            }
        }
    }

    public int getMaxEnergyStored(ItemStack container) {
        return Config.IEConfig.Machines.capacitorHV_storage;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new ICapabilityProvider(){
                final EnergyHelper.ItemEnergyStorage energyStorage;
                {
                    this.energyStorage = new EnergyHelper.ItemEnergyStorage(stack);
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == CapabilityEnergy.ENERGY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == CapabilityEnergy.ENERGY ? this.energyStorage : null);
                }
            };
        }
        return super.initCapabilities(stack, nbt);
    }

    public void onStrike(ItemStack stack, EntityEquipmentSlot eqSlot, EntityLivingBase entity, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if (dmg.source.level <= 2.0f) {
            if (cache.containsKey("power_armor_suit_chest")) {
                cache.put("power_armor_suit_chest", 1 << this.field_77881_a.func_188454_b() | (Integer)cache.get("power_armor_suit_chest"));
            } else {
                cache.put("power_armor_suit_chest", 1 << this.field_77881_a.func_188454_b());
            }
            if (!(dmg.dmg * 100.0f <= (float)Config.IEConfig.Machines.capacitorHV_input && cache.containsKey("power_armor_suit_helmet") && cache.containsKey("power_armor_suit_chest") && cache.containsKey("power_armor_suit_legs") && cache.containsKey("power_armor_suit_boots"))) {
                dmg.dmg = (float)((double)dmg.dmg * 1.2);
                if (!(entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !stack.func_96631_a(2, field_77697_d, dmg.func_76346_g() instanceof EntityPlayerMP ? (EntityPlayerMP)dmg.func_76346_g() : null))) {
                    stack.func_77972_a((int)(dmg.dmg * 500.0f), entity);
                }
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !stack.func_96631_a(2, field_77697_d, dmg.func_76346_g() instanceof EntityPlayerMP ? (EntityPlayerMP)dmg.func_76346_g() : null))) {
                stack.func_77972_a((int)(dmg.dmg * 500.0f), entity);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/powerpack.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return ModelPowerpack.getModel();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Power Armor Knockback Resistance Major", 3.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Power Armor Attack Speed Debuff", -0.05, 2));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Power Armor Movement Speed Debuff", -0.1, 2));
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Power Armor Attack Damage Boost", 0.2, 2));
        }
        return multimap;
    }
}

