/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.items;

import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import com.google.common.collect.Multimap;
import crimson_twilight.immersive_energy.ImmersiveEnergy;
import crimson_twilight.immersive_energy.common.IEnContent;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="immersive_energy")
public class ItemPowerArmorBoots
extends ItemArmor
implements IElectricEquipment,
IUpgradeableTool {
    public static ItemArmor.ArmorMaterial mat = IEnContent.powerArmor;
    private static int armor = mat.func_78044_b(EntityEquipmentSlot.FEET);
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public ItemPowerArmorBoots() {
        super(mat, armor, EntityEquipmentSlot.FEET);
        String name = "power_armor_suit_boots";
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(1);
        IEnContent.registeredIEnItems.add((Item)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        float integrity = 100.0f - (float)this.getDurabilityForDisplay(stack) * 100.0f;
        list.add(String.format("%s %.2f %%", I18n.func_135052_a((String)"desc.immersiveengineering.info.integrity", (Object[])new Object[0]), Float.valueOf(integrity)));
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 0.1f;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public static void playBlockedSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187554_ai, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void playReducedSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == this.field_77881_a) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Power Armor Movement Speed Debuff", -0.02, 2));
        }
        return multimap;
    }

    public void onStrike(ItemStack s, EntityEquipmentSlot eqSlot, EntityLivingBase p, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if (dmg.source.level <= 2.0f) {
            if (cache.containsKey("power_armor_suit_boots")) {
                cache.put("power_armor_suit_boots", 1 << this.field_77881_a.func_188454_b() | (Integer)cache.get("powerpower_armor_suit_boots_armor_suit"));
            } else {
                cache.put("power_armor_suit_boots", 1 << this.field_77881_a.func_188454_b());
            }
            if (!(dmg.dmg * 100.0f <= (float)Config.IEConfig.Machines.capacitorHV_input && cache.containsKey("power_armor_suit_helmet") && cache.containsKey("power_armor_suit_chest") && cache.containsKey("power_armor_suit_legs") && cache.containsKey("power_armor_suit_boots"))) {
                dmg.dmg = (float)((double)dmg.dmg * 1.2);
                if (!(p instanceof EntityPlayer && ((EntityPlayer)p).field_71075_bZ.field_75098_d || !s.func_96631_a(2, field_77697_d, dmg.func_76346_g() instanceof EntityPlayerMP ? (EntityPlayerMP)dmg.func_76346_g() : null))) {
                    s.func_77972_a((int)(dmg.dmg * 50.0f), p);
                }
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(p instanceof EntityPlayer && ((EntityPlayer)p).field_71075_bZ.field_75098_d || !s.func_96631_a(2, field_77697_d, dmg.func_76346_g() instanceof EntityPlayerMP ? (EntityPlayerMP)dmg.func_76346_g() : null))) {
                s.func_77972_a((int)(dmg.dmg * 50.0f), p);
            }
        }
    }

    public boolean canModify(ItemStack arg0) {
        return true;
    }

    public boolean canTakeFromWorkbench(ItemStack arg0) {
        return true;
    }

    public void clearUpgrades(ItemStack arg0) {
    }

    public void finishUpgradeRecalculation(ItemStack arg0) {
    }

    public NBTTagCompound getUpgrades(ItemStack arg0) {
        return null;
    }

    public Slot[] getWorkbenchSlots(Container arg0, ItemStack arg1) {
        return null;
    }

    public void recalculateUpgrades(ItemStack arg0) {
    }

    public void removeFromWorkbench(EntityPlayer arg0, ItemStack arg1) {
    }
}

