/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.items;

import crimson_twilight.immersive_energy.ImmersiveEnergy;
import crimson_twilight.immersive_energy.common.IEnContent;
import crimson_twilight.immersive_energy.common.entities.EntityIEnArrow;
import crimson_twilight.immersive_energy.common.util.IArrowLogic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IEnArrowBase
extends ItemArrow {
    private boolean infinity = true;
    private int damage = 2;
    private int knockback = 0;
    private boolean flaming = false;
    private boolean ignore_invulnerability = false;
    private ItemStack dropItem = ItemStack.field_190927_a;
    private IArrowLogic logic;
    private String logic_desc = "";
    private String logic_extra = "";

    public IEnArrowBase(String name, String ... logic_desc) {
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(64);
        this.logic_desc = logic_desc[0];
        this.logic_extra = logic_desc[1];
        this.dropItem = new ItemStack((Item)this);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public IEnArrowBase(String name, int stackSize, String ... logic_desc) {
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(stackSize);
        this.logic_desc = logic_desc[0];
        this.logic_extra = logic_desc[1];
        this.dropItem = new ItemStack((Item)this);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public IEnArrowBase(String name, int stackSize) {
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(stackSize);
        this.dropItem = new ItemStack((Item)this);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public IEnArrowBase(String name) {
        this.func_77655_b("immersive_energy." + name);
        this.func_77637_a(ImmersiveEnergy.creativeTab);
        this.func_77625_d(64);
        this.dropItem = new ItemStack((Item)this);
        IEnContent.registeredIEnItems.add((Item)this);
    }

    public EntityArrow func_185052_a(World world, ItemStack stack, EntityLivingBase shooter) {
        EntityIEnArrow arrow = new EntityIEnArrow(world, this.dropItem.func_77946_l(), shooter).setIgnoreInvulnerability(this.ignore_invulnerability);
        arrow.setLogic(this.logic);
        arrow.func_70239_b(this.damage);
        arrow.func_70240_a(this.knockback);
        if (this.flaming) {
            arrow.func_70015_d(100);
        }
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow);
        return enchant < 1 ? false : this.infinity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.damage > 0) {
            tooltip.add(TextFormatting.BLUE + Integer.toString(this.getArrowDamage()) + " " + I18n.func_135052_a((String)"attribute.name.immersive_energy.damage", (Object[])new Object[0]));
        }
        if (this.logic != null && this.logic_desc != "") {
            tooltip.add(TextFormatting.BLUE + String.valueOf(this.logic_extra) + " " + I18n.func_135052_a((String)("attribute.name.immersive_energy." + this.logic_desc), (Object[])new Object[0]));
        }
        if (this.knockback > 0) {
            tooltip.add(TextFormatting.BLUE + String.valueOf(this.getKnockback()) + " " + I18n.func_135052_a((String)"attribute.name.immersive_energy.knockback", (Object[])new Object[0]));
        }
    }

    public boolean isInfinity() {
        return this.infinity;
    }

    public IEnArrowBase setInfinity(boolean infinity) {
        this.infinity = infinity;
        return this;
    }

    public int getArrowDamage() {
        return this.damage;
    }

    public IEnArrowBase setDamage(int damage) {
        this.damage = damage;
        return this;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public IEnArrowBase setKnockback(int knockback) {
        this.knockback = knockback;
        return this;
    }

    public boolean isFlaming() {
        return this.flaming;
    }

    public IEnArrowBase setFlaming(boolean flaming) {
        this.flaming = flaming;
        return this;
    }

    public ItemStack getDropItem() {
        return this.dropItem;
    }

    public IEnArrowBase setDropItem(ItemStack dropItem) {
        this.dropItem = dropItem;
        return this;
    }

    public IArrowLogic getLogic() {
        return this.logic;
    }

    public IEnArrowBase setLogic(IArrowLogic logic) {
        this.logic = logic;
        return this;
    }

    public boolean getIgnoreInvulnerability() {
        return this.ignore_invulnerability;
    }

    public IEnArrowBase setIgnoreInvulnerability(boolean ignore) {
        this.ignore_invulnerability = ignore;
        return this;
    }
}

