/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import crimson_twilight.immersive_energy.api.crafting.GasBurnerRecipe;
import crimson_twilight.immersive_energy.api.energy.FuelHandler;
import crimson_twilight.immersive_energy.common.Config;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityGasBurner
extends TileEntityIEBase
implements IIEInventory,
ITickable,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IPlacementInteraction {
    public boolean active;
    public int cookTime;
    public int burnTime;
    public int cookMax = 160;
    public double heat;
    public double heatMax = 2400.0;
    public double heatMin = 450.0;
    public int cookNeeded = this.cookMax;
    public FluidTank tank = new FluidTank(Config.IEnConfig.Machines.burnerCapacity){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && FuelHandler.isValidFuel(fluid.getFluid());
        }
    };
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);

    public static boolean isCookableFood(ItemStack stack) {
        ItemStack result = GasBurnerRecipe.getResult(stack);
        if (!result.func_190926_b()) {
            return true;
        }
        result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        return !result.func_190926_b() && (result.func_77973_b() instanceof ItemFood || result.func_77973_b() instanceof ItemPotion);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.active = nbt.func_74767_n("active");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.burnTime = nbt.func_74762_e("burnTime");
        this.cookTime = nbt.func_74762_e("cookTime");
        this.cookNeeded = nbt.func_74762_e("cookNeeded");
        this.heat = nbt.func_74762_e("heat");
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)2);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("cookTime", this.cookTime);
        nbt.func_74768_a("cookNeeded", this.cookNeeded);
        nbt.func_74780_a("heat", this.heat);
        this.writeTank(nbt, false);
    }

    public void func_73660_a() {
        Fluid fuel;
        this.active = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime > 0) {
                this.heat = Math.min(this.heat + 1.0, this.heatMax);
                this.active = true;
                this.burnTime = Math.max(this.burnTime - 1, 0);
                this.markContainingBlockForUpdate(null);
            } else if (this.heat > 0.0) {
                this.heat = Math.max(this.heat - 1.0, 0.0);
                this.markContainingBlockForUpdate(null);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.tank.getFluid() != null && FuelHandler.isValidFuel(fuel = this.tank.getFluid().getFluid()) && this.tank.getFluidAmount() > 0 && this.burnTime == 0 && this.canCook()) {
            this.burnTime = FuelHandler.getTickPermb(fuel);
            this.tank.drain(new FluidStack(fuel, 1), true);
            this.active = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.active) {
                if (this.canCook() && this.heat >= this.heatMin) {
                    ++this.cookTime;
                    ItemStack stack = (ItemStack)this.inventory.get(0);
                    ItemStack result = GasBurnerRecipe.getResult(stack).func_77946_l();
                    if (result.func_190926_b()) {
                        result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
                    }
                    ItemStack stack1 = (ItemStack)this.inventory.get(1);
                    this.cookNeeded = this.cookMax - (int)(152.0 * (this.heat - this.heatMin) / (this.heatMax - this.heatMin));
                    if (this.cookTime >= this.cookNeeded) {
                        this.cookTime = 0;
                        if (stack1.func_190926_b()) {
                            this.inventory.set(1, (Object)result);
                        } else {
                            stack1.func_190917_f(result.func_190916_E());
                        }
                        stack.func_190918_g(1);
                    }
                }
            } else {
                this.cookTime = this.canCook() && this.cookTime > 0 ? --this.cookTime : 0;
            }
        }
    }

    private boolean canCook() {
        ItemStack stack1;
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.func_190926_b()) {
            return false;
        }
        if (!TileEntityGasBurner.isCookableFood(stack)) {
            return false;
        }
        ItemStack result = GasBurnerRecipe.getResult(stack).func_77946_l();
        if (result.func_190926_b()) {
            result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
        }
        if ((stack1 = (ItemStack)this.inventory.get(1)).func_190926_b()) {
            return true;
        }
        if (!result.func_77969_a(stack1)) {
            return false;
        }
        return stack1.func_190916_E() + result.func_190916_E() <= result.func_77976_d();
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (write) {
            nbt.func_74782_a(toItem ? "Fluid" : "tank", (NBTBase)tankTag);
        }
    }

    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readTank(stack.func_77978_p());
        }
    }

    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        NBTTagCompound tag = new NBTTagCompound();
        this.writeTank(tag, true);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 0;
    }

    public TileEntity getGuiMaster() {
        return this;
    }

    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        return false;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return this.canCook();
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        return ((ItemStack)this.inventory.get(slot)).func_77976_d();
    }

    public void doGraphicalUpdates(int slot) {
    }

    public void onTilePlaced(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            this.tank.setFluid(fs);
        }
    }
}

