/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import crimson_twilight.immersive_energy.common.Config;
import crimson_twilight.immersive_energy.common.IEnRecipes;
import crimson_twilight.immersive_energy.common.blocks.BlockIEnBase;
import crimson_twilight.immersive_energy.common.blocks.BlockIEnSlab;
import crimson_twilight.immersive_energy.common.blocks.BlockTypes_MetalsIEn;
import crimson_twilight.immersive_energy.common.blocks.BlockTypes_OresIEn;
import crimson_twilight.immersive_energy.common.blocks.ItemBlockIEnBase;
import crimson_twilight.immersive_energy.common.blocks.TileEntityIEnSlab;
import crimson_twilight.immersive_energy.common.blocks.metal.BlockGenerators0;
import crimson_twilight.immersive_energy.common.blocks.metal.BlockMachines0;
import crimson_twilight.immersive_energy.common.blocks.metal.TileEntitySolarPanel;
import crimson_twilight.immersive_energy.common.items.IEnArrowBase;
import crimson_twilight.immersive_energy.common.items.ItemIEnBase;
import crimson_twilight.immersive_energy.common.items.ItemIEnMaterial;
import crimson_twilight.immersive_energy.common.items.ItemPowerArmorBoots;
import crimson_twilight.immersive_energy.common.items.ItemPowerArmorChestplate;
import crimson_twilight.immersive_energy.common.items.ItemPowerArmorHelmet;
import crimson_twilight.immersive_energy.common.items.ItemPowerArmorLegs;
import crimson_twilight.immersive_energy.common.items.ItemThoriumRod;
import crimson_twilight.immersive_energy.common.items.ItemToolUpgradeIEn;
import crimson_twilight.immersive_energy.common.items.ItemUraniumRod;
import crimson_twilight.immersive_energy.common.items.ToolHeftyWrench;
import crimson_twilight.immersive_energy.common.world.IEnWorldGen;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="immersive_energy")
public class IEnContent {
    public static ArrayList<Block> registeredIEnBlocks = new ArrayList();
    public static ArrayList<Item> registeredIEnItems = new ArrayList();
    public static List<Class<? extends TileEntity>> registeredIEnTiles = new ArrayList<Class<? extends TileEntity>>();
    public static BlockIEnBase<BlockTypes_OresIEn> blockOre;
    public static BlockIEnBase<BlockTypes_MetalsIEn> blockStorage;
    public static BlockIEnBase<BlockTypes_MetalsIEn> blockSheetmetal;
    public static BlockIEnBase<BlockTypes_MetalsIEn> blockSheetmetalSlabs;
    public static BlockGenerators0 blockGenerators0;
    public static BlockMachines0 blockMachines0;
    public static ItemArmor.ArmorMaterial powerArmor;
    public static Item itemPowerArmorChestplate;
    public static Item itemPowerArmorHelmet;
    public static Item itemPowerArmorLegs;
    public static Item itemPowerArmorBoots;
    public static ItemIEnBase itemMetal;
    public static ItemIEnBase itemMaterial;
    public static ItemIEnBase itemThoriumRod;
    public static ItemIEnBase itemUraniumRod;
    public static IEnArrowBase itemArrow;
    public static ItemIEnBase itemUpgrades;
    public static ItemIEBase toolHeftyWrench;

    public static void preInit() {
        blockOre = (BlockIEnBase)new BlockIEnBase("ore", Material.field_151576_e, PropertyEnum.func_177709_a((String)"type", BlockTypes_OresIEn.class), ItemBlockIEnBase.class, new Object[0]).setOpaque(true).func_149711_c(3.0f).func_149752_b(5.0f);
        blockStorage = (BlockIEnBase)new BlockIEnBase("storage", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalsIEn.class), ItemBlockIEnBase.class, new Object[0]).setOpaque(true).func_149711_c(5.0f).func_149752_b(10.0f);
        blockSheetmetal = (BlockIEnBase)new BlockIEnBase("sheetmetal", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalsIEn.class), ItemBlockIEnBase.class, new Object[0]).setOpaque(true).func_149711_c(3.0f).func_149752_b(10.0f);
        blockSheetmetalSlabs = (BlockIEnSlab)new BlockIEnSlab("sheetmetal_slab", Material.field_151573_f, PropertyEnum.func_177709_a((String)"type", BlockTypes_MetalsIEn.class)).func_149711_c(3.0f).func_149752_b(10.0f);
        blockGenerators0 = new BlockGenerators0();
        itemMetal = new ItemIEnBase("metal", 64, "ingot_thorium", "ingot_tungsten", "dust_thorium", "dust_tungsten", "nugget_thorium", "nugget_tungsten", "plate_thorium", "plate_tungsten");
        itemMaterial = new ItemIEnMaterial();
        itemThoriumRod = new ItemThoriumRod();
        itemUraniumRod = new ItemUraniumRod();
        itemPowerArmorChestplate = new ItemPowerArmorChestplate();
        itemPowerArmorHelmet = new ItemPowerArmorHelmet();
        itemPowerArmorLegs = new ItemPowerArmorLegs();
        itemPowerArmorBoots = new ItemPowerArmorBoots();
        itemUpgrades = new ItemToolUpgradeIEn();
        toolHeftyWrench = new ToolHeftyWrench();
    }

    public static void preInitEnd() {
    }

    public static void registerOres() {
        IEnContent.registerToOreDict("ore", blockOre, new int[0]);
        IEnContent.registerToOreDict("block", blockStorage, new int[0]);
        IEnContent.registerToOreDict("", itemMetal, new int[0]);
        OreDictionary.registerOre((String)"stickTungsten", (ItemStack)new ItemStack((Item)itemMaterial, 1, 0));
        OreDictionary.registerOre((String)"stickThorium", (ItemStack)new ItemStack((Item)itemThoriumRod));
        OreDictionary.registerOre((String)"stickUranium", (ItemStack)new ItemStack((Item)itemUraniumRod));
    }

    public static void init() {
        blockOre.setHarvestLevel("pickaxe", 2, blockOre.func_176203_a(BlockTypes_OresIEn.THORIUM.getMeta()));
        blockOre.setHarvestLevel("pickaxe", 3, blockOre.func_176203_a(BlockTypes_OresIEn.TUNGSTEN.getMeta()));
        IEnContent.addConfiguredWorldgen(blockOre.func_176203_a(BlockTypes_OresIEn.THORIUM.getMeta()), "thorium", Config.IEnConfig.Ores.ore_thorium);
        IEnContent.addConfiguredWorldgen(blockOre.func_176203_a(BlockTypes_OresIEn.TUNGSTEN.getMeta()), "tungsten", Config.IEnConfig.Ores.ore_tungsten);
        IEnContent.registerTile(TileEntityIEnSlab.class);
        IEnContent.registerTile(TileEntitySolarPanel.class);
        RailgunHandler.registerProjectileProperties((IngredientStack)new IngredientStack("stickTungsten"), (double)32.0, (double)1.3).setColourMap((int[][])new int[][]{{13357526, 13357526, 13357526, 13357526, 10396327, 10396327}});
        ThermoelectricHandler.registerSourceInKelvin((String)"blockThorium", (int)1800);
        Config.IEnConfig.addBurnerFuel(Config.IEnConfig.Machines.burner_fuels);
    }

    public static void initEnd() {
    }

    public static void postInit() {
    }

    public static void postInitEnd() {
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IEnRecipes.initCraftingRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
        IEnRecipes.initFurnaceRecipes();
        IEnRecipes.initBlueprintRecipes();
        IEnRecipes.initExcavatorOres();
        IEnRecipes.initBlastFurnaceRecipes();
        IEnRecipes.initMetalPressRecipes();
        IEnRecipes.initAlloySmeltingRecipes();
        IEnRecipes.initCrusherRecipes();
        IEnRecipes.initArcSmeltingRecipes();
        IEnRecipes.postInitOreDictRecipes();
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        String s = tile.getSimpleName();
        s = s.substring(s.indexOf("TileEntity") + "TileEntity".length());
        GameRegistry.registerTileEntity(tile, (String)("immersive_energy:" + s));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : registeredIEnBlocks) {
            event.getRegistry().register(block.setRegistryName(IEnContent.createRegistryName(block.func_149739_a())));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : registeredIEnItems) {
            event.getRegistry().register(item.setRegistryName(IEnContent.createRegistryName(item.func_77658_a())));
        }
        IEnContent.registerOres();
    }

    private static ResourceLocation createRegistryName(String unlocalized) {
        unlocalized = unlocalized.substring(unlocalized.indexOf("immersive"));
        unlocalized = unlocalized.replaceFirst("\\.", ":");
        return new ResourceLocation(unlocalized);
    }

    public static Fluid setupFluid(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            return FluidRegistry.getFluid((String)fluid.getName());
        }
        return fluid;
    }

    public static void refreshFluidReferences() {
    }

    public static void registerToOreDict(String type, ItemIEnBase item, int ... metas) {
        if (metas == null || metas.length < 1) {
            for (int meta = 0; meta < item.getSubNames().length; ++meta) {
                if (item.isMetaHidden(meta)) continue;
                String name = item.getSubNames()[meta];
                name = IEnContent.createOreDictName(name);
                if (type != null && !type.isEmpty()) {
                    name = name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                OreDictionary.registerOre((String)(type + name), (ItemStack)new ItemStack((Item)item, 1, meta));
            }
        } else {
            for (int meta : metas) {
                if (item.isMetaHidden(meta)) continue;
                String name = item.getSubNames()[meta];
                name = IEnContent.createOreDictName(name);
                if (type != null && !type.isEmpty()) {
                    name = name.substring(0, 1).toUpperCase() + name.substring(1);
                }
                OreDictionary.registerOre((String)(type + name), (ItemStack)new ItemStack((Item)item, 1, meta));
            }
        }
    }

    private static String createOreDictName(String name) {
        String upperName = name.toUpperCase();
        StringBuilder sb = new StringBuilder();
        boolean nextCapital = false;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_') {
                nextCapital = true;
                continue;
            }
            char nextChar = name.charAt(i);
            if (nextCapital) {
                nextChar = upperName.charAt(i);
                nextCapital = false;
            }
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public static void registerToOreDict(String type, BlockIEnBase item, int ... metas) {
        if (metas == null || metas.length < 1) {
            for (int meta = 0; meta < item.getMetaEnums().length; ++meta) {
                if (item.isMetaHidden(meta)) continue;
                String name = item.getMetaEnums()[meta].toString();
                if (type != null && !type.isEmpty()) {
                    name = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
                }
                OreDictionary.registerOre((String)(type + name), (ItemStack)new ItemStack((Block)item, 1, meta));
            }
        } else {
            for (int meta : metas) {
                if (item.isMetaHidden(meta)) continue;
                String name = item.getMetaEnums()[meta].toString();
                if (type != null && !type.isEmpty()) {
                    name = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1).toLowerCase(Locale.ENGLISH);
                }
                OreDictionary.registerOre((String)(type + name), (ItemStack)new ItemStack((Block)item, 1, meta));
            }
        }
    }

    public static void registerOre(String type, ItemStack ore, ItemStack ingot, ItemStack dust, ItemStack nugget, ItemStack plate, ItemStack block, ItemStack slab, ItemStack sheet, ItemStack slabSheet) {
        if (!ore.func_190926_b()) {
            OreDictionary.registerOre((String)("ore" + type), (ItemStack)ore);
        }
        if (!ingot.func_190926_b()) {
            OreDictionary.registerOre((String)("ingot" + type), (ItemStack)ingot);
        }
        if (!dust.func_190926_b()) {
            OreDictionary.registerOre((String)("dust" + type), (ItemStack)dust);
        }
        if (!nugget.func_190926_b()) {
            OreDictionary.registerOre((String)("nugget" + type), (ItemStack)nugget);
        }
        if (!plate.func_190926_b()) {
            OreDictionary.registerOre((String)("plate" + type), (ItemStack)plate);
        }
        if (!block.func_190926_b()) {
            OreDictionary.registerOre((String)("block" + type), (ItemStack)block);
        }
        if (!slab.func_190926_b()) {
            OreDictionary.registerOre((String)("slab" + type), (ItemStack)slab);
        }
        if (!sheet.func_190926_b()) {
            OreDictionary.registerOre((String)("blockSheetmetal" + type), (ItemStack)sheet);
        }
        if (!slabSheet.func_190926_b()) {
            OreDictionary.registerOre((String)("slabSheetmetal" + type), (ItemStack)slabSheet);
        }
    }

    public static void addConfiguredWorldgen(IBlockState state, String name, int[] config) {
        if (config != null && config.length >= 5 && config[0] > 0) {
            IEnWorldGen.addOreGen(name, state, config[0], config[1], config[2], config[3], config[4]);
        }
    }

    static {
        powerArmor = EnumHelper.addArmorMaterial((String)"power_armor_suit", (String)"immersive_energy:power_armor_suit", (int)5260, (int[])new int[]{2, 7, 8, 3}, (int)1, (SoundEvent)SoundEvents.field_187725_r, (float)3.0f);
    }
}

