/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.common;

import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.realmsclient.util.Pair;
import crimson_twilight.immersive_energy.common.IEnContent;
import crimson_twilight.immersive_energy.common.IEnSaveData;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="immersive_energy")
public class EventHandler {
    public static final Queue<Pair<Integer, BlockPos>> requestedBlockUpdates = new LinkedList<Pair<Integer, BlockPos>>();
    private static final UUID POWER_ARMOR_SPEED_BOOST_ID = UUID.fromString("eba4c34c-c7d9-11e9-a32f-2a2ae2dbcce4");
    private static final AttributeModifier POWER_ARMOR_SPEED_BOOST = new AttributeModifier(POWER_ARMOR_SPEED_BOOST_ID, "Power Armor Speed Boost", 0.4, 2);
    public static final Map<EntityPlayer, Pair<Entity, RayTraceResult>> hitList = new WeakHashMap<EntityPlayer, Pair<Entity, RayTraceResult>>();

    @SubscribeEvent
    public static void onLoad(WorldEvent.Load event) {
    }

    @SubscribeEvent
    public static void onSave(WorldEvent.Save event) {
        IEnSaveData.setDirty(0);
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload event) {
        IEnSaveData.setDirty(0);
    }

    @SubscribeEvent
    public static void onCapabilitiesAttachEntity(AttachCapabilitiesEvent<Entity> event) {
    }

    @SubscribeEvent
    public static void onCapabilitiesAttachItem(AttachCapabilitiesEvent<ItemStack> event) {
    }

    @SubscribeEvent
    public static void livingFall(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76379_h && entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots)) {
            int fallreduction = 2;
            fallreduction = entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().equals(IEnContent.itemPowerArmorLegs) ? (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().equals(IEnContent.itemPowerArmorChestplate) ? (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().equals(IEnContent.itemPowerArmorHelmet) ? 9 : 8) : 6) : 2;
            float damage = event.getAmount();
            if (damage - (float)fallreduction <= 0.0f) {
                EventHandler.playBlockedSound(entity);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76379_h && entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots)) {
            int fallreduction = 2;
            fallreduction = entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().equals(IEnContent.itemPowerArmorLegs) ? (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().equals(IEnContent.itemPowerArmorChestplate) ? (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().equals(IEnContent.itemPowerArmorHelmet) ? 9 : 8) : 6) : 2;
            float damage = event.getAmount();
            if (damage - (float)fallreduction <= 0.0f) {
                EventHandler.playBlockedSound(entity);
                event.setCanceled(true);
            } else {
                EventHandler.playReducedSound(entity);
                event.setAmount((damage - (float)fallreduction) * 0.8f);
            }
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots) && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots) && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().equals(IEnContent.itemPowerArmorLegs) && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().equals(IEnContent.itemPowerArmorChestplate) && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().equals(IEnContent.itemPowerArmorHelmet)) {
            player.func_70045_F();
            int energy = EnergyHelper.getEnergyStored((ItemStack)player.func_184582_a(EntityEquipmentSlot.CHEST));
            IAttributeInstance iattributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (iattributeinstance.func_111127_a(POWER_ARMOR_SPEED_BOOST_ID) != null) {
                iattributeinstance.func_188479_b(POWER_ARMOR_SPEED_BOOST_ID);
            }
            if (!(player.func_184218_aH() || player.field_70702_br == 0.0f && player.field_191988_bg == 0.0f || energy <= 5)) {
                iattributeinstance.func_111121_a(POWER_ARMOR_SPEED_BOOST);
                EnergyHelper.extractFlux((ItemStack)player.func_184582_a(EntityEquipmentSlot.CHEST), (int)5, (boolean)false);
            }
        }
    }

    public static void playBlockedSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187554_ai, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void playReducedSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    @SubscribeEvent
    public static void blastProtection(LivingHurtEvent event) {
        if (event.getSource().func_94541_c()) {
            float damage = event.getAmount();
            float mult = 1.0f;
            EntityLivingBase entity = event.getEntityLiving();
            for (int i = 0; i < 4; ++i) {
                switch (i) {
                    case 0: {
                        if (!entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots)) break;
                        mult = (float)((double)mult - 0.05);
                        break;
                    }
                    case 1: {
                        if (!entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().equals(IEnContent.itemPowerArmorLegs)) break;
                        mult = (float)((double)mult - 0.2);
                        break;
                    }
                    case 2: {
                        if (!entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().equals(IEnContent.itemPowerArmorChestplate)) break;
                        mult = (float)((double)mult - 0.3);
                        break;
                    }
                    case 3: {
                        if (!entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().equals(IEnContent.itemPowerArmorHelmet)) break;
                        mult = (float)((double)mult - 0.15);
                    }
                }
                event.setAmount(damage * mult);
            }
        }
    }

    @SubscribeEvent
    public static void reflectArrows(ProjectileImpactEvent.Arrow event) {
        EntityLivingBase entity;
        EntityArrow projectile = event.getArrow();
        if (!projectile.func_130014_f_().field_72995_K && event.getEntity() != null && event.getEntity() instanceof EntityLivingBase && (entity = (EntityLivingBase)event.getRayTraceResult().field_72308_g).func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().equals(IEnContent.itemPowerArmorBoots) && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().equals(IEnContent.itemPowerArmorLegs) && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().equals(IEnContent.itemPowerArmorChestplate) && entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().equals(IEnContent.itemPowerArmorHelmet)) {
            Random rand = new Random();
            int item = rand.nextInt(4);
            int damageItem = 100 + rand.nextInt(25) - rand.nextInt(25);
            ItemStack armor = null;
            switch (item) {
                case 0: {
                    armor = entity.func_184582_a(EntityEquipmentSlot.FEET);
                    break;
                }
                case 1: {
                    armor = entity.func_184582_a(EntityEquipmentSlot.LEGS);
                    break;
                }
                case 2: {
                    armor = entity.func_184582_a(EntityEquipmentSlot.CHEST);
                    break;
                }
                case 3: {
                    armor = entity.func_184582_a(EntityEquipmentSlot.HEAD);
                    break;
                }
                default: {
                    armor = entity.func_184582_a(EntityEquipmentSlot.CHEST);
                }
            }
            if (projectile.func_70242_d() <= 15.0) {
                armor.func_77972_a(damageItem, entity);
                EventHandler.playReflectSound(entity);
                projectile.func_70186_c(projectile.field_70159_w * -1.0, projectile.field_70181_x, projectile.field_70179_y * -1.0, 0.3f, 0.2f);
                projectile.field_70250_c = entity;
                event.setCanceled(true);
            } else {
                projectile.func_70239_b(projectile.func_70242_d() - 15.0);
                armor.func_77972_a(250, entity);
                EventHandler.playPirceSound(entity);
            }
        }
    }

    public static void playReflectSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    public static void playPirceSound(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        if (!world.field_72995_K) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187677_b, SoundCategory.PLAYERS, 0.8f, 0.4f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
    }

    @SubscribeEvent
    public static void onFurnaceBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (Utils.isFluidRelatedItemStack((ItemStack)event.getItemStack())) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)event.getItemStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
    }
}

