/*
 * Decompiled with CFR 0.152.
 */
package crimson_twilight.immersive_energy.api.energy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FuelHandler {
    static final HashMap<String, Integer> gasBurnerAmountTick = new HashMap();

    public static void registerGasBurnerFuel(Fluid fuel, int tickPermb) {
        if (fuel != null) {
            gasBurnerAmountTick.put(fuel.getName(), tickPermb);
        }
    }

    public static boolean isValidFuel(Fluid fuel) {
        if (fuel != null) {
            return gasBurnerAmountTick.containsKey(fuel.getName());
        }
        return false;
    }

    public static HashMap<String, Integer> getFuelPerTick() {
        return gasBurnerAmountTick;
    }

    public static int getTickPermb(Fluid fuel) {
        if (!FuelHandler.isValidFuel(fuel)) {
            return 0;
        }
        return gasBurnerAmountTick.get(fuel.getName());
    }

    public static List<FluidStack> getBurnerFuels() {
        ArrayList<FluidStack> fuels = new ArrayList<FluidStack>();
        for (String fuel : gasBurnerAmountTick.keySet()) {
            if (fuel == null) continue;
            fuels.add(FluidRegistry.getFluidStack((String)fuel, (int)1));
        }
        return fuels;
    }
}

