/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfc_drying_rack.registry;

import com.lumintorious.tfc_drying_rack.DryingRackConfig;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

@Mod.EventBusSubscriber(modid="tfc_drying_rack")
public class RecipeRegistry {
    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        String[] colors = new String[]{"white", "light_gray", "gray", "dark_gray", "yellow", "lime", "green", "cyan", "blue", "light_blue", "purple", "magenta", "red", "orange", "brown", "black"};
        if (DryingRackConfig.GENERAL.dyesNeedWater) {
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                String color = dyeColor == EnumDyeColor.SILVER ? "light_gray" : dyeColor.func_176610_l();
                int dyeMeta = dyeColor.func_176765_a();
                modRegistry.remove(new ResourceLocation("minecraft:" + color + "_wool"));
                modRegistry.remove(new ResourceLocation("minecraft:" + color + "_stained_hardened_clay"));
                modRegistry.remove(new ResourceLocation("minecraft:" + color + "_concrete_powder"));
                modRegistry.remove(new ResourceLocation("tfc:vanilla/concrete_powder/" + color + "_concrete_powder"));
                modRegistry.remove(new ResourceLocation("minecraft:" + color + "_stained_glass"));
                BarrelRecipe barrelrec1 = (BarrelRecipe)new BarrelRecipe(IIngredient.of((Fluid)FluidsTFC.getFluidFromDye((EnumDyeColor)dyeColor).get(), (int)125), IIngredient.of((Block)Blocks.field_150359_w), null, new ItemStack((Block)Blocks.field_150399_cn, 1, dyeMeta), 1000).setRegistryName("glass0_" + color);
                BarrelRecipe barrelrec2 = (BarrelRecipe)new BarrelRecipe(IIngredient.of((Fluid)FluidsTFC.getFluidFromDye((EnumDyeColor)dyeColor).get(), (int)125), IIngredient.of((Block)Blocks.field_150399_cn), null, new ItemStack((Block)Blocks.field_150399_cn, 1, dyeMeta), 1000).setRegistryName("glass_" + color);
                BarrelRecipe barrelrec3 = (BarrelRecipe)new BarrelRecipe(IIngredient.of((Fluid)FluidsTFC.getFluidFromDye((EnumDyeColor)dyeColor).get(), (int)125), IIngredient.of((Block)Blocks.field_150406_ce), null, new ItemStack(Blocks.field_150406_ce, 1, dyeMeta), 1000).setRegistryName("stained_clay_alt_" + color);
                TFCRegistries.BARREL.register((IForgeRegistryEntry)barrelrec1);
                TFCRegistries.BARREL.register((IForgeRegistryEntry)barrelrec2);
                TFCRegistries.BARREL.register((IForgeRegistryEntry)barrelrec3);
            }
        }
    }
}

