/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfc_drying_rack.registry;

import com.lumintorious.tfc_drying_rack.TFCDryingRack;
import com.lumintorious.tfc_drying_rack.objects.base.ItemBase;
import com.lumintorious.tfc_drying_rack.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="tfc_drying_rack")
public class ItemRegistry {
    public static final List<Item> ITEMS = new ArrayList<Item>();
    public static Item SCOOP;
    public static Item FRAME;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ITEMS.toArray(new Item[0]));
        for (Item item : ITEMS) {
            ItemRegistry.registerModel(item, "inventory");
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])BlockRegistry.ITEM_BLOCKS.toArray(new Item[0]));
        for (Item item : BlockRegistry.ITEM_BLOCKS) {
            ItemRegistry.registerModel(item, "inventory");
        }
    }

    public static Item register(Item item) {
        ITEMS.add(item);
        return item;
    }

    public static void registerModel(Item item, String id) {
        if (item instanceof ItemBase) {
            ((ItemBase)item).registerModel(id);
        } else {
            TFCDryingRack.proxy.registerItemRenderer(item, 0, id);
        }
    }
}

