/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfc_drying_rack.recipes;

import com.lumintorious.tfc_drying_rack.DryingRackConfig;
import com.lumintorious.tfc_drying_rack.recipes.DryingRackRecipe;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.agriculture.Crop;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class DryingRackRecipeHandler {
    public static final Set<DryingRackRecipe> recipes = new HashSet<DryingRackRecipe>();

    public static void init() {
        if (DryingRackConfig.GENERAL.seedsFromVegetables) {
            for (Crop crop : Crop.values()) {
                try {
                    IIngredient input = IIngredient.of((Item)crop.getFoodDrop(crop.getMaxStage()).func_77973_b());
                    ItemStack output = ItemSeedsTFC.get((ICrop)crop, (int)1);
                    int duration = 72;
                    float chance = 0.2f;
                    recipes.add(new DryingRackRecipe("tfc_drying_rack:" + crop.toString() + "_seed", (IIngredient<ItemStack>)input, output, duration, chance));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (DryingRackConfig.GENERAL.driedFlowers) {
            IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)TFCRegistries.QUERN;
            TFCRegistries.QUERN.forEach(recipe -> {
                IIngredient input = (IIngredient)recipe.getIngredients().get(0);
                ItemStack output = (ItemStack)recipe.getOutputs().get(0);
                if (((ItemStack)input.getValidIngredients().get(0)).func_77973_b().getRegistryName().toString().contains("plants/")) {
                    recipes.add(new DryingRackRecipe("tfc_drying_rack:dried_pre_" + recipe.getRegistryName(), (IIngredient<ItemStack>)input, output, 8, 1.0f));
                    modRegistry.remove(recipe.getRegistryName());
                }
            });
        }
        if (DryingRackConfig.GENERAL.thatchFromLeaves) {
            recipes.add(new DryingRackRecipe("tfc_drying_rack:thatch_from_leaves", (IIngredient<ItemStack>)IIngredient.of((String)"treeLeaves"), new ItemStack((Block)BlocksTFC.THATCH), 92, 1.0f));
        }
        if (DryingRackConfig.GENERAL.saltFromSaltPeter) {
            recipes.add(new DryingRackRecipe("tfc_drying_rack:salt_from_saltpeter", (IIngredient<ItemStack>)IIngredient.of((String)"dustSaltpeter"), new ItemStack((Item)ItemsTFC.SALT), 24, 1.0f));
        }
    }

    public static DryingRackRecipe getRecipe(ItemStack input) {
        for (DryingRackRecipe recipe : recipes) {
            if (!recipe.input.testIgnoreCount((Object)input)) continue;
            return recipe;
        }
        return null;
    }

    public static DryingRackRecipe getRecipe(IIngredient input) {
        for (DryingRackRecipe recipe : recipes) {
            if (recipe.input != input) continue;
            return recipe;
        }
        return null;
    }

    public static DryingRackRecipe getRecipe(String registryName) {
        for (DryingRackRecipe recipe : recipes) {
            if (recipe.registryName != registryName) continue;
            return recipe;
        }
        return null;
    }

    public static void addRecipe(DryingRackRecipe recipe) {
        recipes.add(recipe);
    }
}

