/*
 * Decompiled with CFR 0.152.
 */
package com.lumintorious.tfc_drying_rack.objects.rack;

import com.lumintorious.tfc_drying_rack.recipes.DryingRackRecipe;
import com.lumintorious.tfc_drying_rack.recipes.DryingRackRecipeHandler;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.objects.te.TEPlacedItemFlat;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityRack
extends TEInventory
implements ITickable {
    public static final int ID = 1;
    public static final String NAME = "tile_entity_drying_rack";
    private ItemStack last = new ItemStack(Items.field_190931_a);
    private DryingRackRecipe recipe = null;
    private long dueDate = -1L;

    public TileEntityRack() {
        super(12);
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(I18n.func_135052_a((String)NAME, (Object[])new Object[0]));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long currentHours = CalendarTFC.CALENDAR_TIME.getTotalHours();
            BlockPos newPos = this.field_174879_c.func_177982_a(0, 1, 0);
            TileEntity te = this.field_145850_b.func_175625_s(newPos);
            if (te instanceof TEPlacedItemFlat) {
                TEPlacedItemFlat tile = (TEPlacedItemFlat)te;
                if (this.recipe != null && currentHours >= this.dueDate && this.dueDate != -1L) {
                    tile.setStack(new ItemStack(Items.field_190931_a));
                    this.field_145850_b.func_175656_a(newPos, Blocks.field_150350_a.func_176223_P());
                    ItemStack newStack = ItemStack.field_190927_a;
                    int count = 0;
                    for (int i = 0; i < this.last.func_190916_E(); ++i) {
                        if (!(Math.random() <= (double)this.recipe.chance)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        this.field_145850_b.func_175656_a(newPos, BlocksTFC.PLACED_ITEM_FLAT.func_176223_P());
                        newStack = this.recipe.output.func_77946_l();
                        newStack.func_190920_e(Math.min(newStack.func_190916_E() * count, 64));
                        ((TEPlacedItemFlat)this.field_145850_b.func_175625_s(newPos)).setStack(newStack);
                    }
                    this.last = newStack;
                    this.recipe = null;
                    this.dueDate = -1L;
                }
            } else {
                this.last = new ItemStack(Items.field_190931_a);
                this.recipe = null;
                this.dueDate = -1L;
            }
        }
    }

    public void putItemIn(ItemStack stack) {
        DryingRackRecipe recipe = DryingRackRecipeHandler.getRecipe(stack);
        if (recipe != null) {
            this.last = stack;
            this.recipe = recipe;
            long currentHours = CalendarTFC.CALENDAR_TIME.getTotalHours();
            this.dueDate = currentHours + (long)recipe.time;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        try {
            this.last = new ItemStack(nbt.func_74775_l("last"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dueDate = nbt.func_74763_f("dueDate");
        String recipeName = nbt.func_74779_i("recipe");
        this.recipe = DryingRackRecipeHandler.getRecipe(this.last);
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound last = new NBTTagCompound();
        try {
            this.last.func_77955_b(last);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nbt.func_74782_a("last", (NBTBase)last);
        nbt.func_74772_a("dueDate", this.dueDate);
        nbt.func_74778_a("recipe", this.recipe == null ? "" : this.recipe.registryName);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public NBTTagCompound getTileData() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }
}

