/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.blockdrops;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mrriegel.blockdrops.BlockDrops;
import mrriegel.blockdrops.util.Drop;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Wrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private ItemStack in;
    private List<Drop> out;
    private int index = 0;
    private int maxIndex;

    public Wrapper(ItemStack in, List<Drop> out) {
        this.in = in;
        this.out = out;
        this.maxIndex = Math.max(0, out.size() - 9);
    }

    public List<ItemStack> getInputs() {
        return Collections.singletonList(this.in);
    }

    public List<ItemStack> getOutputs() {
        return this.out.stream().map(d -> d.out).collect(Collectors.toList());
    }

    private float chance(ItemStack s, int fortune) {
        for (Drop d : this.out) {
            if (!d.out.func_77969_a(s)) continue;
            switch (fortune) {
                case 0: {
                    return d.chance0;
                }
                case 1: {
                    return d.chance1;
                }
                case 2: {
                    return d.chance2;
                }
                case 3: {
                    return d.chance3;
                }
            }
        }
        return 0.0f;
    }

    public String toString() {
        return "Wrapper [in=" + this.in + ", out=" + this.out + "]";
    }

    private Pair<Integer, Integer> pair(ItemStack s, int fortune) {
        for (Drop d : this.out) {
            if (!d.out.func_77969_a(s)) continue;
            switch (fortune) {
                case 0: {
                    return d.pair0;
                }
                case 1: {
                    return d.pair1;
                }
                case 2: {
                    return d.pair2;
                }
                case 3: {
                    return d.pair3;
                }
            }
        }
        return MutablePair.of((Object)0, (Object)0);
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (!input) {
            String minmax;
            long x = System.currentTimeMillis() / 1500L % 4L;
            String chance = BlockDrops.showChance ? String.format("%.2f", Float.valueOf(this.chance(ingredient, (int)x))) + " %  " : "";
            String string = minmax = BlockDrops.showMinMax ? "Min: " + this.pair(ingredient, (int)x).getLeft() + "  Max: " + this.pair(ingredient, (int)x).getRight() : "";
            if (BlockDrops.showChance || BlockDrops.showMinMax) {
                tooltip.add(TextFormatting.BLUE + "Fortune " + (0L != x ? I18n.func_135052_a((String)("enchantment.level." + x), (Object[])new Object[0]) : Integer.valueOf(0)) + " " + TextFormatting.GRAY + chance + minmax);
            }
            if (this.out.size() > 9) {
                tooltip.add(TextFormatting.GRAY + "There are too many possible drops. Use left and right key to cycle.");
            }
        }
    }

    public ItemStack getIn() {
        return this.in;
    }

    public void setIn(ItemStack in) {
        this.in = in;
    }

    public List<Drop> getOut() {
        return this.out;
    }

    public void setOut(List<Drop> out) {
        this.out = out;
        this.maxIndex = Math.max(0, out.size() - 9);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setOutputs(ItemStack.class, this.getOutputs());
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = MathHelper.func_76125_a((int)index, (int)0, (int)this.maxIndex);
    }

    public void increaseIndex() {
        this.index = MathHelper.func_76125_a((int)(this.index + 1), (int)0, (int)this.maxIndex);
    }

    public void decreaseIndex() {
        this.index = MathHelper.func_76125_a((int)(this.index - 1), (int)0, (int)this.maxIndex);
    }
}

