/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.blockdrops;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.gui.recipes.RecipesGui;
import mrriegel.blockdrops.Wrapper;
import mrriegel.blockdrops.util.Drop;
import mrriegel.blockdrops.util.FakeClientPlayer;
import mrriegel.blockdrops.util.FakeClientWorld;
import mrriegel.blockdrops.util.StackWrapper;
import mrriegel.blockdrops.util.WrapperJson;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@Mod(modid="blockdrops", name="Block Drops", version="1.4.0", acceptedMinecraftVersions="[1.12,1.13)", dependencies="required-after:jei@[4.8.0,);", clientSideOnly=true)
@Mod.EventBusSubscriber
public class BlockDrops {
    public static final String MODID = "blockdrops";
    public static final String VERSION = "1.4.0";
    public static final String MODNAME = "Block Drops";
    @Mod.Instance(value="blockdrops")
    public static BlockDrops instance;
    public static boolean all;
    public static boolean showChance;
    public static boolean showMinMax;
    public static boolean multithreaded;
    public static int iteration;
    public static Set<String> blacklist;
    public static List<Wrapper> recipeWrappers;
    public static Gson gson;
    public static Logger logger;
    private File recipeWrapFile;
    private File modHashFile;
    private static Field recipeLayouts;
    private static Field recipeWrapper;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configDir = new File(event.getModConfigurationDirectory(), "BlockDrops");
        this.recipeWrapFile = new File(configDir, "blockdrops.txt");
        this.modHashFile = new File(configDir, "modVersions.txt");
        Configuration config = new Configuration(new File(configDir, "config.cfg"));
        config.load();
        all = config.getBoolean("allDrops", "client", false, "Show block drops of any block.");
        showChance = config.getBoolean("showChance", "client", true, "Show chance of drops.");
        showMinMax = config.getBoolean("showMinMax", "client", true, "Show minimum and maximum of drops.");
        multithreaded = config.getBoolean("multithreaded", "client", true, "Multithreaded calculation of drops");
        iteration = config.getInt("iteration", "client", 4000, 1, 99999, "Number of calculation. The higher the more precise the chance.");
        blacklist = Sets.newHashSet((Object[])config.getStringList("blacklist", "client", new String[]{"flatcoloredblocks", "chisel", "xtones", "wallpapercraft", "sonarcore", "microblockcbe"}, "Mod IDs of mods that won't be scanned."));
        if (config.hasChanged()) {
            config.save();
        }
        gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Wrapper.class, (Object)new WrapperJson()).create();
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws IOException {
        if (this.recipeWrapFile.exists()) {
            recipeWrappers = (List)gson.fromJson((Reader)new BufferedReader(new FileReader(this.recipeWrapFile)), new TypeToken<List<Wrapper>>(){}.getType());
            if (recipeWrappers == null) {
                recipeWrappers = new ArrayList<Wrapper>();
            }
        } else {
            recipeWrappers = Lists.newArrayList();
            this.recipeWrapFile.createNewFile();
            this.modHashFile.createNewFile();
        }
        HashMap mods = Maps.newHashMap();
        Loader.instance().getActiveModList().stream().forEach(m -> mods.put(m.getModId(), m.getVersion()));
        for (String black : blacklist) {
            mods.remove(black);
        }
        Map fileMods = null;
        if (this.modHashFile.exists()) {
            fileMods = (Map)gson.fromJson((Reader)new BufferedReader(new FileReader(this.modHashFile)), new TypeToken<Map<String, String>>(){}.getType());
            if (fileMods == null) {
                fileMods = Maps.newHashMap();
            }
        } else {
            this.modHashFile.createNewFile();
            fileMods = Maps.newHashMap();
        }
        HashSet check = Sets.newHashSet();
        for (Map.Entry entry : mods.entrySet()) {
            if (fileMods.containsKey(entry.getKey()) && ((String)fileMods.get(entry.getKey())).equals(entry.getValue())) continue;
            check.add(entry.getKey());
        }
        if (!check.isEmpty()) {
            recipeWrappers.removeIf(w -> check.contains(w.getIn().func_77973_b().getRegistryName().func_110624_b()));
            recipeWrappers.addAll(Lists.newArrayList(BlockDrops.getRecipes(check)));
        }
        recipeWrappers.removeIf(rw -> rw.getIn().func_190926_b());
        recipeWrappers.forEach(rw -> rw.getOut().removeIf(d -> d.out.func_190926_b()));
        BufferedWriter fw = new BufferedWriter(new FileWriter(this.modHashFile));
        fw.write(gson.toJson((Object)mods));
        ((Writer)fw).close();
        fw = new BufferedWriter(new FileWriter(this.recipeWrapFile));
        fw.write(gson.toJson(recipeWrappers));
        ((Writer)fw).close();
    }

    public static List<Wrapper> getRecipes(Collection<String> ids) {
        ArrayList res = Lists.newArrayList();
        HashSet stateSet = Sets.newHashSet();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!ids.contains(b.getRegistryName().func_110624_b()) || Item.func_150898_a((Block)b) == null || b == Blocks.field_150357_h) continue;
            NonNullList lis = NonNullList.func_191196_a();
            b.func_149666_a(b.func_149708_J(), lis);
            try {
                ArrayList stacks = Lists.newArrayList();
                for (int i = 0; i < 16; ++i) {
                    IBlockState st2 = b.func_176203_a(i);
                    for (ItemStack s : lis) {
                        if (s.func_190926_b() || !s.func_77969_a(BlockDrops.getStack(st2)) || stacks.stream().anyMatch(ss -> ss.func_77969_a(s))) continue;
                        stateSet.add(st2);
                        stacks.add(s);
                    }
                }
            }
            catch (Exception stacks) {
            }
        }
        ArrayList states = Lists.newArrayList((Iterable)stateSet);
        states.sort((o1, o2) -> {
            int id = Integer.compare(Block.func_149682_b((Block)o1.func_177230_c()), Block.func_149682_b((Block)o2.func_177230_c()));
            int meta = Integer.compare(o1.func_177230_c().func_176201_c(o1), o2.func_177230_c().func_176201_c(o2));
            return id != 0 ? id : meta;
        });
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Analysing Drops", (int)states.size());
        ExecutorService threadPool = Executors.newCachedThreadPool();
        Consumer<IBlockState> task = st -> {
            List<Drop> drops;
            bar.step(st.func_177230_c().getRegistryName().toString());
            try {
                drops = BlockDrops.getList(st);
            }
            catch (Throwable e) {
                logger.error("An error occured while calculating drops for " + st.func_177230_c().func_149732_F() + " (" + e.getClass() + ")");
                drops = Collections.emptyList();
            }
            if (drops.isEmpty()) {
                return;
            }
            res.add(new Wrapper(BlockDrops.getStack(st), drops));
        };
        for (IBlockState st2 : states) {
            if (multithreaded) {
                threadPool.execute(() -> task.accept(st2));
                continue;
            }
            task.accept(st2);
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (bar.getSteps() != bar.getStep()) {
            ReflectionHelper.setPrivateValue(ProgressManager.ProgressBar.class, (Object)bar, (Object)bar.getSteps(), (String[])new String[]{"step"});
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        return res;
    }

    private static List<Drop> getList(IBlockState state) {
        ArrayList drops = Lists.newArrayList();
        if (BlockDrops.getStack(state).func_190926_b()) {
            return drops;
        }
        ArrayList stacks0 = Lists.newArrayList();
        ArrayList stacks1 = Lists.newArrayList();
        ArrayList stacks2 = Lists.newArrayList();
        ArrayList stacks3 = Lists.newArrayList();
        HashMap pairs0 = Maps.newHashMap();
        HashMap pairs1 = Maps.newHashMap();
        HashMap pairs2 = Maps.newHashMap();
        HashMap pairs3 = Maps.newHashMap();
        boolean crashed = false;
        for (int i = 0; i < iteration; ++i) {
            for (int j = 0; j < 4; ++j) {
                List list = state.func_177230_c().getDrops((IBlockAccess)FakeClientWorld.getInstance(), BlockPos.field_177992_a, state, j);
                ArrayList lis = Lists.newArrayList((Iterable)list);
                if (!crashed) {
                    try {
                        ForgeEventFactory.fireBlockHarvesting((List)lis, (World)FakeClientWorld.getInstance(), (BlockPos)BlockPos.field_177992_a, (IBlockState)state, (int)j, (float)1.0f, (boolean)false, (EntityPlayer)FakeClientPlayer.getInstance());
                    }
                    catch (Throwable t) {
                        crashed = true;
                    }
                }
                lis.removeAll(Collections.singleton(null));
                Iterables.removeIf((Iterable)lis, s -> s.func_190926_b());
                switch (j) {
                    case 0: {
                        BlockDrops.add(pairs0, lis);
                        break;
                    }
                    case 1: {
                        BlockDrops.add(pairs1, lis);
                        break;
                    }
                    case 2: {
                        BlockDrops.add(pairs2, lis);
                        break;
                    }
                    case 3: {
                        BlockDrops.add(pairs3, lis);
                    }
                }
                for (ItemStack s2 : lis) {
                    if (s2.func_190926_b()) continue;
                    switch (j) {
                        case 0: {
                            BlockDrops.add(stacks0, s2);
                            break;
                        }
                        case 1: {
                            BlockDrops.add(stacks1, s2);
                            break;
                        }
                        case 2: {
                            BlockDrops.add(stacks2, s2);
                            break;
                        }
                        case 3: {
                            BlockDrops.add(stacks3, s2);
                        }
                    }
                }
            }
        }
        ArrayList stacks = Lists.newArrayList();
        for (StackWrapper w : stacks0) {
            BlockDrops.add(stacks, w.stack);
        }
        for (StackWrapper w : stacks1) {
            BlockDrops.add(stacks, w.stack);
        }
        for (StackWrapper w : stacks2) {
            BlockDrops.add(stacks, w.stack);
        }
        for (StackWrapper w : stacks3) {
            BlockDrops.add(stacks, w.stack);
        }
        if (!all) {
            Iterator it = stacks.iterator();
            while (it.hasNext()) {
                StackWrapper tmp = (StackWrapper)it.next();
                if (!tmp.stack.func_77969_a(BlockDrops.getStack(state))) continue;
                it.remove();
            }
        }
        stacks.sort((o1, o2) -> {
            int id = Integer.compare(Item.func_150891_b((Item)o1.stack.func_77973_b()), Item.func_150891_b((Item)o2.stack.func_77973_b()));
            int meta = Integer.compare(o1.stack.func_77952_i(), o2.stack.func_77952_i());
            return id != 0 ? id : meta;
        });
        for (int i = 0; i < stacks.size(); ++i) {
            StackWrapper stack = (StackWrapper)stacks.get(i);
            float s0 = BlockDrops.getChance(stacks0, stack.stack);
            float s1 = BlockDrops.getChance(stacks1, stack.stack);
            float s2 = BlockDrops.getChance(stacks2, stack.stack);
            float s3 = BlockDrops.getChance(stacks3, stack.stack);
            if (stack.stack == null || stack.stack.func_77973_b() == null) continue;
            drops.add(new Drop(stack.stack, s0, s1, s2, s3, (Pair<Integer, Integer>)((Pair)pairs0.get(stack)), (Pair<Integer, Integer>)((Pair)pairs1.get(stack)), (Pair<Integer, Integer>)((Pair)pairs2.get(stack)), (Pair<Integer, Integer>)((Pair)pairs3.get(stack))));
        }
        return drops;
    }

    private static float getChance(List<StackWrapper> stacks, ItemStack stack) {
        if (!showChance) {
            return 0.0f;
        }
        int con = BlockDrops.contains(stacks, stack);
        if (con == -1) {
            return 0.0f;
        }
        return 100.0f * ((float)stacks.get((int)con).size / (float)iteration);
    }

    private static int contains(List<StackWrapper> lis, ItemStack stack) {
        for (int i = 0; i < lis.size(); ++i) {
            if (!lis.get((int)i).stack.func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    private static void add(List<StackWrapper> lis, ItemStack stack) {
        if (lis == null) {
            lis = Lists.newArrayList();
        }
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        int con = BlockDrops.contains(lis, stack);
        if (con == -1) {
            lis.add(new StackWrapper(stack, stack.func_190916_E()));
        } else {
            StackWrapper tmp = (StackWrapper)lis.get(con);
            tmp.size += stack.func_190916_E();
            lis.set(con, tmp);
        }
    }

    private static void add(Map<StackWrapper, Pair<Integer, Integer>> map, List<ItemStack> lis) {
        if (map == null) {
            map = Maps.newHashMap();
        }
        ArrayList list = Lists.newArrayList();
        for (ItemStack s : lis) {
            BlockDrops.add(list, s);
        }
        for (StackWrapper w : list) {
            if (map.get(w) == null) {
                map.put(w, Pair.of((Object)10000, (Object)0));
            }
            int min = (Integer)((Pair)map.get(w)).getLeft();
            int max = (Integer)((Pair)map.get(w)).getRight();
            Pair pair = Pair.of((Object)Math.min(min, w.size), (Object)Math.max(max, w.size));
            map.put(w, pair);
        }
    }

    private static ItemStack getStack(IBlockState state) {
        return state.func_177230_c().getPickBlock(state, new RayTraceResult((Entity)FakeClientPlayer.getInstance()), (World)FakeClientWorld.getInstance(), BlockPos.field_177992_a, (EntityPlayer)FakeClientPlayer.getInstance());
    }

    @SubscribeEvent
    public static void key(GuiScreenEvent.KeyboardInputEvent.Post event) throws IllegalArgumentException, IllegalAccessException {
        if (Minecraft.func_71410_x().field_71462_r instanceof RecipesGui) {
            if (recipeLayouts == null) {
                recipeLayouts = ReflectionHelper.findField(RecipesGui.class, (String[])new String[]{"recipeLayouts"});
                recipeWrapper = ReflectionHelper.findField(RecipeLayout.class, (String[])new String[]{"recipeWrapper"});
            }
            ((List)recipeLayouts.get(Minecraft.func_71410_x().field_71462_r)).stream().map(rl -> {
                try {
                    return recipeWrapper.get(rl);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(o -> o instanceof Wrapper).map(o -> (Wrapper)o).collect(Collectors.toList()).forEach(w -> {
                if (Keyboard.isKeyDown((int)203)) {
                    w.decreaseIndex();
                    ((RecipesGui)Minecraft.func_71410_x().field_71462_r).onStateChange();
                } else if (Keyboard.isKeyDown((int)205)) {
                    w.increaseIndex();
                    ((RecipesGui)Minecraft.func_71410_x().field_71462_r).onStateChange();
                }
            });
        }
    }
}

