/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.sound;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.sound.SoundState;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.sound.SoundMetadata;
import org.orecruncher.lib.gui.RecordTitleEmitter;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public abstract class Emitter {
    protected static final int ERROR_DELAY = 10;
    protected static final int ERROR_DELAY_RANDOM = 6;
    protected static final Random RANDOM = XorShiftRandom.current();
    protected static final RecordTitleEmitter.ITimeKeeper timer = () -> EnvironStateHandler.EnvironState.getTickCounter();
    @Nullable
    protected final RecordTitleEmitter titleEmitter;
    protected final SoundEffect effect;
    protected SoundInstance activeSound;
    protected boolean done = false;
    protected int errorDelayTicks;

    public Emitter(@Nonnull SoundEffect sound2) {
        this.effect = sound2;
        if (StringUtils.isEmpty((CharSequence)sound2.getSoundTitle())) {
            SoundMetadata data = RegistryManager.SOUND.getSoundMetadata(this.effect.getSound().getRegistryName());
            if (data != null) {
                if (!StringUtils.isEmpty((CharSequence)data.getTitle())) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(data.getTitle());
                    if (data.getCredits().size() > 0) {
                        builder.append(" by ").append(data.getCredits().get(0));
                    }
                    this.titleEmitter = new RecordTitleEmitter(builder.toString(), timer);
                } else {
                    this.titleEmitter = null;
                }
            } else {
                this.titleEmitter = null;
            }
        } else {
            this.titleEmitter = new RecordTitleEmitter(sound2.getSoundTitle(), timer);
        }
    }

    protected abstract SoundInstance createSound();

    public void update() {
        if (this.titleEmitter != null) {
            this.titleEmitter.update();
        }
        if (this.activeSound == null) {
            this.activeSound = this.createSound();
            this.activeSound.setQueue(true);
        } else {
            if (this.activeSound.getState().isActive()) {
                if (!this.activeSound.canSoundBeHeard() || this.isFading() && this.activeSound.getState() == SoundState.DELAYED) {
                    SoundEffectHandler.INSTANCE.stopSound(this.activeSound);
                }
                return;
            }
            if (this.isFading()) {
                this.done = true;
                return;
            }
        }
        try {
            if (this.errorDelayTicks > 0) {
                --this.errorDelayTicks;
            } else if (!SoundEffectHandler.INSTANCE.playSound(this.activeSound)) {
                this.errorDelayTicks = 10 + RANDOM.nextInt(6);
            }
        }
        catch (Throwable t) {
            ModBase.log().error("Unable to play sound", t);
        }
    }

    public void setVolumeThrottle(float throttle) {
        if (this.activeSound != null) {
            this.activeSound.setVolumeThrottle(throttle);
        }
    }

    public void setPitch(float pitch) {
        if (this.activeSound != null) {
            this.activeSound.setPitch(pitch);
        }
    }

    public void fade() {
        if (this.activeSound != null) {
            ModBase.log().debug("FADE: %s", new Object[]{this.activeSound.toString()});
            this.activeSound.fade();
        }
    }

    public boolean isFading() {
        if (this.activeSound != null) {
            return this.activeSound.isFading();
        }
        return false;
    }

    public void unfade() {
        if (this.activeSound != null) {
            ModBase.log().debug("UNFADE: %s", new Object[]{this.activeSound.toString()});
            this.activeSound.unfade();
        }
    }

    public boolean isDonePlaying() {
        if (this.activeSound != null) {
            return this.done || this.activeSound.isDonePlaying();
        }
        return this.done;
    }

    public void stop() {
        if (this.activeSound != null) {
            this.activeSound.setRepeat(false);
            SoundEngine.instance().stopSound(this.activeSound);
        }
    }

    public String toString() {
        return this.activeSound.toString();
    }
}

