/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityDimensionInfo;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.dimension.DimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.TemperatureRating;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.scanners.BattleScanner;
import org.orecruncher.dsurround.client.handlers.scanners.CeilingCoverage;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.expression.ExpressionEngine;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.dsurround.registry.biome.BiomeRegistry;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.lib.DiurnalUtils;
import org.orecruncher.lib.MinecraftClock;

@SideOnly(value=Side.CLIENT)
public class EnvironStateHandler
extends EffectHandlerBase {
    protected final CeilingCoverage ceiling = new CeilingCoverage();
    private static final String[] scripts = new String[]{"'Dim: ' + dim.id + '/' + dim.name", "'Biome: ' + biome.name + ' (' + biome.id + '); Temp ' + biome.temperature + '/' + biome.temperatureValue + ' rainfall: ' + biome.rainfall + ' traits: ' + biome.traits", "'Weather: ' + IF(weather.isRaining,'rainfall: ' + weather.rainfall,'not raining') + IF(weather.isThundering,' thundering','') + ' Temp: ' + weather.temperature + '/' + weather.temperatureValue + ' ice: ' + IF(weather.canWaterFreeze, 'true', 'false') + ' ' + IF(weather.temperatureValue < 0.2, '(breath)', '')", "'Season: ' + season.season + IF(diurnal.isNight,' night',' day') + IF(player.isInside,' inside',' outside') + ' celestialAngle: ' + diurnal.celestialAngle", "'Player: Temp ' + player.temperature + '; health ' + player.health + '/' + player.maxHealth + '; food ' + player.food.level + '; saturation ' + player.food.saturation + IF(player.isHurt,' isHurt','') + IF(player.isHungry,' isHungry','') + ' pos: (' + player.X + ',' + player.Y + ',' + player.Z + ') light: ' + player.lightLevel", "'Village: ' + player.inVillage"};

    public EnvironStateHandler() {
        super("State Handler");
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        EnvironStateData data = EnvironState.getData();
        World world = player2.func_130014_f_();
        BiomeRegistry biomes2 = RegistryManager.BIOME;
        ISeasonInfo season = CapabilitySeasonInfo.getCapability(world);
        if (!Minecraft.func_71410_x().func_147113_T()) {
            ++data.tickCounter;
        }
        Weather.update();
        this.ceiling.func_73660_a();
        data.clock.update(world);
        data.battle.update(player2);
        data.dimInfo = CapabilityDimensionInfo.getCapability(world);
        data.playerBiome = biomes2.getPlayerBiome(player2, false);
        data.dimensionId = world.field_73011_w.getDimension();
        data.dimensionName = world.field_73011_w.func_186058_p().func_186065_b();
        data.playerPosition = new BlockPos(player2.field_70165_t, player2.func_174813_aQ().field_72338_b, player2.field_70161_v);
        data.inside = this.ceiling.isReallyInside();
        data.truePlayerBiome = biomes2.getPlayerBiome(player2, true);
        data.playerTemperature = season.getPlayerTemperature();
        data.biomeTemperature = season.getBiomeTemperature(data.playerPosition);
        data.armorStack = ItemClass.effectiveArmorStack((EntityLivingBase)player2);
        data.footArmorStack = ItemClass.footArmorStack((EntityLivingBase)player2);
        data.isUnderground = data.playerBiome == biomes2.UNDERGROUND_INFO;
        data.isInSpace = data.playerBiome == biomes2.OUTERSPACE_INFO;
        data.isInClouds = data.playerBiome == biomes2.CLOUDS_INFO;
        int blockLight = world.func_175642_b(EnumSkyBlock.BLOCK, data.playerPosition);
        int skyLight = world.func_175642_b(EnumSkyBlock.SKY, data.playerPosition) - world.func_72967_a(1.0f);
        data.lightLevel = Math.max(blockLight, skyLight);
        data.dayCycle = DiurnalUtils.getCycle((World)world);
        ExpressionEngine.instance().reset();
    }

    private void reset() {
        EnvironState.setData(new EnvironStateData());
    }

    @Override
    public void onConnect() {
        this.reset();
        ExpressionEngine.instance();
    }

    @Override
    public void onDisconnect() {
        this.reset();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void diagnostics(DiagnosticEvent.Gather event) {
        event.output.add(TextFormatting.GREEN + "Minecraft Date: " + EnvironState.getClock().toString());
        for (String s : scripts) {
            String result = ExpressionEngine.instance().eval(s).toString();
            event.output.add(TextFormatting.YELLOW + result);
        }
        List<String> badScripts = ExpressionEngine.instance().getNaughtyList();
        for (String s : badScripts) {
            event.output.add("BAD SCRIPT: " + s);
        }
        event.output.add(TextFormatting.RED + EnvironState.getBattleScanner().toString());
    }

    public static final class EnvironState {
        private static EnvironStateData data = new EnvironStateData();

        public static MinecraftClock getClock() {
            return EnvironState.data.clock;
        }

        public static BattleScanner getBattleScanner() {
            return EnvironState.data.battle;
        }

        public static IDimensionInfo getDimensionInfo() {
            return EnvironState.data.dimInfo;
        }

        public static BiomeInfo getPlayerBiome() {
            return EnvironState.data.playerBiome;
        }

        public static BiomeInfo getTruePlayerBiome() {
            return EnvironState.data.truePlayerBiome;
        }

        public static String getBiomeName() {
            return EnvironState.getPlayerBiome().getBiomeName();
        }

        public static TemperatureRating getPlayerTemperature() {
            return EnvironState.data.playerTemperature;
        }

        public static TemperatureRating getBiomeTemperature() {
            return EnvironState.data.biomeTemperature;
        }

        public static int getDimensionId() {
            return EnvironState.data.dimensionId;
        }

        public static String getDimensionName() {
            return EnvironState.data.dimensionName;
        }

        public static EntityPlayer getPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }

        public static World getWorld() {
            Minecraft mc = Minecraft.func_71410_x();
            return mc != null ? mc.field_71441_e : null;
        }

        public static BlockPos getPlayerPosition() {
            return EnvironState.data.playerPosition;
        }

        public static boolean isPlayer(Entity entity) {
            return entity.getPersistentID().equals(EnvironState.getPlayer().getPersistentID());
        }

        public static boolean isPlayerHurt() {
            if (ModOptions.player.playerHurtThreshold == 0.0f) {
                return false;
            }
            EntityPlayer player2 = EnvironState.getPlayer();
            return !player2.func_184812_l_() && player2.func_110143_aJ() <= ModOptions.player.playerHurtThreshold * player2.func_110138_aP();
        }

        public static boolean isPlayerHungry() {
            if (ModOptions.player.playerHungerThreshold == 0) {
                return false;
            }
            EntityPlayer player2 = EnvironState.getPlayer();
            return !player2.func_184812_l_() && player2.func_71024_bL().func_75116_a() <= ModOptions.player.playerHungerThreshold;
        }

        public static boolean isPlayerBurning() {
            return EnvironState.getPlayer().func_70027_ad();
        }

        public static boolean isPlayerSuffocating() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return !player2.func_184812_l_() && player2.func_70086_ai() <= 0;
        }

        public static boolean isPlayerFlying() {
            return EnvironState.getPlayer().field_71075_bZ.field_75100_b;
        }

        public static boolean isPlayerSprinting() {
            return EnvironState.getPlayer().func_70051_ag();
        }

        public static boolean isPlayerInLava() {
            return EnvironState.getPlayer().func_180799_ab();
        }

        public static boolean isPlayerInvisible() {
            return EnvironState.getPlayer().func_82150_aj();
        }

        public static boolean isPlayerBlind() {
            return EnvironState.getPlayer().func_70644_a(MobEffects.field_76440_q);
        }

        public static boolean isPlayerInWater() {
            return EnvironState.getPlayer().func_70090_H();
        }

        public static boolean isPlayerRiding() {
            return EnvironState.getPlayer().func_184218_aH();
        }

        public static boolean isPlayerMoving() {
            EntityPlayer player2 = EnvironState.getPlayer();
            return player2.field_70140_Q != player2.field_70141_P;
        }

        public static boolean isPlayerInside() {
            return EnvironState.data.inside;
        }

        public static boolean isPlayerUnderground() {
            return EnvironState.data.isUnderground;
        }

        public static boolean isPlayerInSpace() {
            return EnvironState.data.isInSpace;
        }

        public static boolean isPlayerInClouds() {
            return EnvironState.data.isInClouds;
        }

        public static ItemStack getPlayerItemStack() {
            return EnvironState.data.armorStack;
        }

        public static ItemStack getPlayerFootArmorStack() {
            return EnvironState.data.footArmorStack;
        }

        public static boolean inVillage() {
            return EnvironState.data.inVillage;
        }

        public static void setInVillage(boolean f) {
            EnvironState.data.inVillage = f;
        }

        public static int getLightLevel() {
            return EnvironState.data.lightLevel;
        }

        public static int getTickCounter() {
            return EnvironState.data.tickCounter;
        }

        public static DiurnalUtils.DayCycle getDayCycle() {
            return EnvironState.data.dayCycle;
        }

        public static float getPartialTick() {
            return Minecraft.func_71410_x().func_184121_ak();
        }

        protected static void setData(EnvironStateData d) {
            data = d;
        }

        protected static EnvironStateData getData() {
            return data;
        }
    }

    protected static final class EnvironStateData {
        public BiomeInfo playerBiome;
        public BiomeInfo truePlayerBiome;
        public int dimensionId;
        public String dimensionName;
        public IDimensionInfo dimInfo;
        public BlockPos playerPosition;
        public TemperatureRating playerTemperature;
        public TemperatureRating biomeTemperature;
        public ItemStack armorStack;
        public ItemStack footArmorStack;
        public boolean inside;
        public boolean inVillage;
        public boolean isUnderground;
        public boolean isInSpace;
        public boolean isInClouds;
        public int lightLevel;
        public int tickCounter;
        public DiurnalUtils.DayCycle dayCycle;
        public MinecraftClock clock;
        public BattleScanner battle;

        protected EnvironStateData() {
            this.playerBiome = RegistryManager.BIOME.WTF_INFO;
            this.truePlayerBiome = RegistryManager.BIOME.WTF_INFO;
            this.dimensionName = "";
            this.dimInfo = DimensionInfo.NONE;
            this.playerPosition = BlockPos.field_177992_a;
            this.playerTemperature = TemperatureRating.MILD;
            this.biomeTemperature = TemperatureRating.MILD;
            this.armorStack = ItemStack.field_190927_a;
            this.footArmorStack = ItemStack.field_190927_a;
            this.tickCounter = 1;
            this.dayCycle = DiurnalUtils.DayCycle.NO_SKY;
            this.clock = new MinecraftClock();
            this.battle = new BattleScanner();
        }
    }
}

