/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.handlers.scanners.BiomeScanner;
import org.orecruncher.dsurround.client.sound.SoundEffect;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class BiomeSoundEffectsHandler
extends EffectHandlerBase {
    public static final int SCAN_INTERVAL = 4;
    protected final BiomeScanner biomes = new BiomeScanner();

    public BiomeSoundEffectsHandler() {
        super("Biome Sound Effects");
    }

    @Override
    public boolean doTick(int tick) {
        return ModOptions.sound.enableBiomeSounds && tick % 4 == 0 && EnvironStateHandler.EnvironState.getDimensionInfo().playBiomeSounds() && EnvironStateHandler.EnvironState.getWorld().func_175667_e(EnvironStateHandler.EnvironState.getPlayerPosition());
    }

    private boolean doBiomeSounds() {
        return EnvironStateHandler.EnvironState.isPlayerUnderground() || EnvironStateHandler.EnvironState.getDimensionInfo().alwaysOutside() || !EnvironStateHandler.EnvironState.isPlayerInside();
    }

    private void getBiomeSounds(@Nonnull Object2FloatOpenHashMap<SoundEffect> result) {
        this.biomes.getBiomes().reference2FloatEntrySet().stream().forEach(e -> ((BiomeInfo)e.getKey()).findSoundMatches().forEach(fx -> result.addTo(fx, e.getFloatValue())));
        float area = this.biomes.getBiomeArea();
        result.replaceAll((fx, v) -> Float.valueOf(0.1f + 0.9f * (v.floatValue() / area)));
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        this.biomes.func_73660_a();
        Object2FloatOpenHashMap sounds = new Object2FloatOpenHashMap();
        sounds.defaultReturnValue(0.0f);
        if (player2.func_70089_S()) {
            SoundEffect sound2;
            BiomeInfo playerBiome;
            SoundEffect sound3;
            if (this.doBiomeSounds()) {
                this.getBiomeSounds((Object2FloatOpenHashMap<SoundEffect>)sounds);
            }
            ObjectArray playerSounds = new ObjectArray();
            RegistryManager.BIOME.PLAYER_INFO.findSoundMatches((Collection<SoundEffect>)playerSounds);
            RegistryManager.BIOME.BATTLE_MUSIC_INFO.findSoundMatches((Collection<SoundEffect>)playerSounds);
            if (EnvironStateHandler.EnvironState.inVillage()) {
                RegistryManager.BIOME.VILLAGE_INFO.findSoundMatches((Collection<SoundEffect>)playerSounds);
            }
            playerSounds.forEach(fx -> sounds.put(fx, 1.0f));
            if (this.doBiomeSounds() && (sound3 = (playerBiome = EnvironStateHandler.EnvironState.getPlayerBiome()).getSpotSound(this.RANDOM)) != null) {
                SoundEffectHandler.INSTANCE.playSoundAtPlayer(player2, sound3);
            }
            if ((sound2 = RegistryManager.BIOME.PLAYER_INFO.getSpotSound(this.RANDOM)) != null) {
                SoundEffectHandler.INSTANCE.playSoundAtPlayer(player2, sound2);
            }
        }
        SoundEffectHandler.INSTANCE.queueAmbientSounds((Object2FloatOpenHashMap<SoundEffect>)sounds);
    }
}

