/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx.particle.system;

import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleJet;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.lib.ReflectedField;

@SideOnly(value=Side.CLIENT)
public class ParticleFireJet
extends ParticleJet {
    private static final ReflectedField.FloatField<ParticleFlame> flameScale = new ReflectedField.FloatField(ParticleFlame.class, "flameScale", "field_70562_a");
    protected final boolean isLava = RANDOM.nextInt(3) == 0;
    protected final IParticleFactory factory;
    protected final int particleId = this.isLava ? EnumParticleTypes.LAVA.func_179348_c() : EnumParticleTypes.FLAME.func_179348_c();
    protected boolean soundFired;

    public ParticleFireJet(int strength, World world, double x, double y, double z) {
        super(strength, world, x, y, z);
        this.factory = this.isLava ? new ParticleLava.Factory() : new ParticleFlame.Factory();
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            SoundEffectHandler.INSTANCE.playSoundAt(this.getPos(), Sounds.FIRE, 0);
        }
    }

    @Override
    protected void spawnJetParticle() {
        double speedY = this.isLava ? 0.0 : (double)this.jetStrength / 10.0;
        Particle particle = this.factory.func_178902_a(this.particleId, this.world, this.posX, this.posY, this.posZ, 0.0, speedY, 0.0, new int[0]);
        if (!this.isLava) {
            ParticleFlame flame = (ParticleFlame)particle;
            flameScale.set((Object)flame, flameScale.get((Object)flame) * (float)this.jetStrength);
        }
        this.addParticle(particle);
    }
}

