/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.fx;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.fx.BlockEffectType;
import org.orecruncher.dsurround.client.fx.JetEffect;
import org.orecruncher.dsurround.client.fx.particle.system.ParticleWaterSplash;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.chunk.IBlockAccessEx;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public class WaterSplashJetEffect
extends JetEffect {
    private static final Vec3i[] cardinal_offsets = new Vec3i[]{new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)};

    public WaterSplashJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.SPLASH_JET;
    }

    private static boolean isLiquidBlock(IBlockState state) {
        return state.func_185904_a().func_76224_d();
    }

    private static boolean isUnboundedLiquid(IBlockAccessEx provider, BlockPos pos) {
        for (int i = 0; i < cardinal_offsets.length; ++i) {
            BlockPos tp = pos.func_177971_a(cardinal_offsets[i]);
            IBlockState state = provider.func_180495_p(tp);
            if (state.func_185904_a() == Material.field_151579_a) {
                return true;
            }
            if (!WaterSplashJetEffect.isLiquidBlock(state) || WorldUtils.isFullWaterBlock((IBlockState)state) || provider.func_180495_p(tp.func_177984_a()).func_185904_a().func_76224_d()) continue;
            return true;
        }
        return false;
    }

    private int liquidBlockCount(IBlockAccessEx provider, BlockPos pos) {
        int count;
        BlockPos.MutableBlockPos workBlock = new BlockPos.MutableBlockPos(pos);
        for (count = 0; count < 10 && provider.func_180495_p((BlockPos)workBlock).func_185904_a().func_76224_d(); ++count) {
            workBlock.func_185336_p(workBlock.func_177956_o() + 1);
        }
        return MathStuff.clamp((int)count, (int)0, (int)10);
    }

    public static boolean isValidSpawnBlock(IBlockAccessEx provider, BlockPos pos) {
        return WaterSplashJetEffect.isValidSpawnBlock(provider, provider.func_180495_p(pos), pos);
    }

    private static boolean isValidSpawnBlock(IBlockAccessEx provider, IBlockState state, BlockPos pos) {
        if (!state.func_185904_a().func_76224_d()) {
            return false;
        }
        if (WaterSplashJetEffect.isUnboundedLiquid(provider, pos)) {
            BlockPos down = pos.func_177977_b();
            if (provider.func_180495_p(down).func_185904_a().func_76220_a()) {
                return true;
            }
            return !WaterSplashJetEffect.isUnboundedLiquid(provider, down);
        }
        return provider.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockDynamicLiquid;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        return WaterSplashJetEffect.isValidSpawnBlock(provider, state, pos) && super.canTrigger(provider, state, pos, random);
    }

    @Override
    public void doEffect(@Nonnull IBlockAccessEx provider, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int strength = this.liquidBlockCount(provider, pos);
        if (strength > 1) {
            float height = BlockLiquid.func_149801_b((int)state.func_177230_c().func_176201_c(state)) + 0.1f;
            double y = height + (float)pos.func_177956_o();
            ParticleWaterSplash effect = new ParticleWaterSplash(strength, provider.getWorld(), pos, (double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
            this.addEffect(effect);
        }
    }
}

