/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.IRayTraceCollision;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CoordUtils {
    public static int coordXor = 0;
    private static final int[][] coordHashMap = new int[][]{{4111, 271, 3067}, {7933711, 6144389, 9538033}, {9973, 8287, 9721}, {7211, 5437, 9613}};

    public static boolean isSurroundedByLoadedChunks(World world, BlockPos pos) {
        for (Surround surr : Surround.values()) {
            Vec3i dir = surr.getOffset();
            if (world.func_72863_F().func_186026_b((pos.func_177958_n() >> 4) + dir.func_177958_n(), (pos.func_177952_p() >> 4) + dir.func_177952_p()) != null) continue;
            return false;
        }
        return true;
    }

    public static EnumFacing getRandomDir(Random rand) {
        return EnumFacing.func_82600_a((int)(2 + rand.nextInt(4)));
    }

    public static BlockPos getRayTraceFruitPos(World world, Species species, BlockPos treePos, BlockPos branchPos, SafeChunkBounds safeBounds) {
        BlockPos hitPos;
        RayTraceResult result = CoordUtils.branchRayTrace(world, species, treePos, branchPos, 45.0f, 60.0f, 4 + world.field_73012_v.nextInt(3), safeBounds);
        if (result != null && (hitPos = result.func_178782_a()) != BlockPos.field_177992_a) {
            do {
                hitPos = hitPos.func_177977_b();
            } while (species.getFamily().isCompatibleGenericLeaves(world.func_180495_p(hitPos), (IBlockAccess)world, hitPos));
            if (world.func_175623_d(hitPos)) {
                return hitPos;
            }
        }
        return BlockPos.field_177992_a;
    }

    public static RayTraceResult branchRayTrace(World world, Species species, BlockPos treePos, BlockPos branchPos, float spreadHor, float spreadVer, float distance, SafeChunkBounds safeBounds) {
        RayTraceResult result;
        treePos = new BlockPos(treePos.func_177958_n(), branchPos.func_177956_o(), treePos.func_177952_p());
        Vec3d vOut = new Vec3d((double)(branchPos.func_177958_n() - treePos.func_177958_n()), 0.0, (double)(branchPos.func_177952_p() - treePos.func_177952_p()));
        if (vOut.equals((Object)Vec3d.field_186680_a)) {
            vOut = new Vec3d(1.0, 0.0, 0.0);
            spreadHor = 180.0f;
        }
        float deltaYaw = world.field_73012_v.nextFloat() * spreadHor * 2.0f - spreadHor;
        float deltaPitch = world.field_73012_v.nextFloat() * -spreadVer;
        vOut = vOut.func_72432_b().func_72441_c(0.0, Math.tan(Math.toRadians(deltaPitch)), 0.0).func_72432_b().func_178785_b((float)Math.toRadians(deltaYaw)).func_186678_a((double)distance);
        Vec3d branchVec = new Vec3d((Vec3i)branchPos).func_72441_c(0.5, 0.5, 0.5);
        Vec3d vantageVec = branchVec.func_178787_e(vOut);
        BlockPos vantagePos = new BlockPos(vantageVec);
        if ((!safeBounds.inBounds(vantagePos, false) || world.func_175623_d(vantagePos)) && (result = CoordUtils.rayTraceBlocks(world, vantageVec, branchVec, false, true, false, safeBounds)) != null) {
            BlockPos hitPos = result.func_178782_a();
            if (result.field_72313_a == RayTraceResult.Type.BLOCK && hitPos != BlockPos.field_177992_a && species.getFamily().isCompatibleGenericLeaves(world.func_180495_p(hitPos), (IBlockAccess)world, hitPos)) {
                return result;
            }
        }
        return null;
    }

    public static RayTraceResult rayTraceBlocks(World world, Vec3d vantage, Vec3d lookingAt, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, SafeChunkBounds safeBounds) {
        if (!(Double.isNaN(vantage.field_72450_a) || Double.isNaN(vantage.field_72448_b) || Double.isNaN(vantage.field_72449_c))) {
            if (!(Double.isNaN(lookingAt.field_72450_a) || Double.isNaN(lookingAt.field_72448_b) || Double.isNaN(lookingAt.field_72449_c))) {
                RayTraceResult raytraceresult;
                boolean specialRayTraceCollision;
                int lookZ;
                int lookY;
                int vantX = MathHelper.func_76128_c((double)lookingAt.field_72450_a);
                int vantY = MathHelper.func_76128_c((double)lookingAt.field_72448_b);
                int vantZ = MathHelper.func_76128_c((double)lookingAt.field_72449_c);
                int lookX = MathHelper.func_76128_c((double)vantage.field_72450_a);
                BlockPos lookPos = new BlockPos(lookX, lookY = MathHelper.func_76128_c((double)vantage.field_72448_b), lookZ = MathHelper.func_76128_c((double)vantage.field_72449_c));
                IBlockState lookState = safeBounds.inBounds(lookPos, false) ? world.func_180495_p(lookPos) : Blocks.field_150350_a.func_176223_P();
                Block lookBlock = lookState.func_177230_c();
                AxisAlignedBB colBB1 = safeBounds.inBounds(lookPos, false) ? lookState.func_185890_d((IBlockAccess)world, lookPos) : Block.field_185506_k;
                boolean bl = specialRayTraceCollision = lookBlock instanceof IRayTraceCollision ? ((IRayTraceCollision)lookBlock).isRayTraceCollidable() : false;
                if ((specialRayTraceCollision || (!ignoreBlockWithoutBoundingBox || colBB1 != Block.field_185506_k) && lookBlock.func_176209_a(lookState, stopOnLiquid)) && (raytraceresult = lookState.func_185910_a(world, lookPos, vantage, lookingAt)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int ropeLen = 200;
                while (ropeLen-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vantage.field_72450_a) || Double.isNaN(vantage.field_72448_b) || Double.isNaN(vantage.field_72449_c)) {
                        return null;
                    }
                    if (lookX == vantX && lookY == vantY && lookZ == vantZ) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flagX = true;
                    boolean flagY = true;
                    boolean flagZ = true;
                    double modX = 999.0;
                    double modY = 999.0;
                    double modZ = 999.0;
                    if (vantX > lookX) {
                        modX = (double)lookX + 1.0;
                    } else if (vantX < lookX) {
                        modX = (double)lookX + 0.0;
                    } else {
                        flagX = false;
                    }
                    if (vantY > lookY) {
                        modY = (double)lookY + 1.0;
                    } else if (vantY < lookY) {
                        modY = (double)lookY + 0.0;
                    } else {
                        flagY = false;
                    }
                    if (vantZ > lookZ) {
                        modZ = (double)lookZ + 1.0;
                    } else if (vantZ < lookZ) {
                        modZ = (double)lookZ + 0.0;
                    } else {
                        flagZ = false;
                    }
                    double unkX = 999.0;
                    double unkY = 999.0;
                    double unkZ = 999.0;
                    double deltaX = lookingAt.field_72450_a - vantage.field_72450_a;
                    double deltaY = lookingAt.field_72448_b - vantage.field_72448_b;
                    double deltaZ = lookingAt.field_72449_c - vantage.field_72449_c;
                    if (flagX) {
                        unkX = (modX - vantage.field_72450_a) / deltaX;
                    }
                    if (flagY) {
                        unkY = (modY - vantage.field_72448_b) / deltaY;
                    }
                    if (flagZ) {
                        unkZ = (modZ - vantage.field_72449_c) / deltaZ;
                    }
                    if (unkX == -0.0) {
                        unkX = -1.0E-4;
                    }
                    if (unkY == -0.0) {
                        unkY = -1.0E-4;
                    }
                    if (unkZ == -0.0) {
                        unkZ = -1.0E-4;
                    }
                    if (unkX < unkY && unkX < unkZ) {
                        enumfacing = vantX > lookX ? EnumFacing.WEST : EnumFacing.EAST;
                        vantage = new Vec3d(modX, vantage.field_72448_b + deltaY * unkX, vantage.field_72449_c + deltaZ * unkX);
                    } else if (unkY < unkZ) {
                        enumfacing = vantY > lookY ? EnumFacing.DOWN : EnumFacing.UP;
                        vantage = new Vec3d(vantage.field_72450_a + deltaX * unkY, modY, vantage.field_72449_c + deltaZ * unkY);
                    } else {
                        enumfacing = vantZ > lookZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vantage = new Vec3d(vantage.field_72450_a + deltaX * unkZ, vantage.field_72448_b + deltaY * unkZ, modZ);
                    }
                    lookX = MathHelper.func_76128_c((double)vantage.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    lookY = MathHelper.func_76128_c((double)vantage.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    lookZ = MathHelper.func_76128_c((double)vantage.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    lookPos = new BlockPos(lookX, lookY, lookZ);
                    IBlockState lookState2 = safeBounds.inBounds(lookPos, false) ? world.func_180495_p(lookPos) : Blocks.field_150350_a.func_176223_P();
                    Block lookBlock2 = lookState2.func_177230_c();
                    AxisAlignedBB colBB2 = safeBounds.inBounds(lookPos, false) ? lookState2.func_185890_d((IBlockAccess)world, lookPos) : Block.field_185506_k;
                    boolean bl2 = specialRayTraceCollision = lookBlock2 instanceof IRayTraceCollision ? ((IRayTraceCollision)lookBlock2).isRayTraceCollidable() : false;
                    if (!specialRayTraceCollision && ignoreBlockWithoutBoundingBox && lookState2.func_185904_a() != Material.field_151567_E && colBB2 == Block.field_185506_k) continue;
                    if (specialRayTraceCollision || lookBlock2.func_176209_a(lookState2, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = lookState2.func_185910_a(world, lookPos, vantage, lookingAt);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vantage, enumfacing, lookPos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public static BlockPos findGround(World world, BlockPos startPos) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos);
        while (world.func_180495_p((BlockPos)pos).func_185917_h()) {
            pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        }
        while (!world.func_180495_p((BlockPos)pos).func_185917_h() && pos.func_177956_o() > 50) {
            pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
        }
        return pos;
    }

    public static int coordHashCode(BlockPos pos, int a, int b, int c) {
        int hash = (pos.func_177958_n() * a ^ pos.func_177956_o() * b ^ pos.func_177952_p() * c) >> 1;
        return (hash ^ coordXor) & 0xFFFF;
    }

    public static int coordHashCode(BlockPos pos, int readyMade) {
        int[] factors = coordHashMap[readyMade & 3];
        return CoordUtils.coordHashCode(pos, factors[0], factors[1], factors[2]);
    }

    public static Iterable<BlockPos> goHorSides(BlockPos pos) {
        return CoordUtils.goHorSides(pos, null);
    }

    public static Iterable<BlockPos> goHorSides(final BlockPos pos, final EnumFacing ignore) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int currentDir = 0;

                    protected BlockPos computeNext() {
                        while (this.currentDir < EnumFacing.field_176754_o.length) {
                            EnumFacing face;
                            if ((face = EnumFacing.field_176754_o[this.currentDir++]) == ignore) continue;
                            return pos.func_177972_a(face);
                        }
                        return (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    public static enum Surround implements IStringSerializable
    {
        N("n", EnumFacing.NORTH),
        NW("nw", EnumFacing.NORTH, EnumFacing.WEST),
        W("w", EnumFacing.WEST),
        SW("sw", EnumFacing.SOUTH, EnumFacing.WEST),
        S("s", EnumFacing.SOUTH),
        SE("se", EnumFacing.SOUTH, EnumFacing.EAST),
        E("e", EnumFacing.EAST),
        NE("ne", EnumFacing.NORTH, EnumFacing.EAST);

        private final String name;
        private final Vec3i offset;

        private Surround(String name, EnumFacing ... dirs) {
            this.name = name;
            BlockPos pos = BlockPos.field_177992_a;
            for (EnumFacing d : dirs) {
                pos = pos.func_177971_a(d.func_176730_m());
            }
            this.offset = pos;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Vec3i getOffset() {
            return this.offset;
        }

        public BlockPos getOffsetPos() {
            return new BlockPos(this.offset);
        }

        public Surround getOpposite() {
            return Surround.values()[this.ordinal() + 4 & 7];
        }
    }
}

