/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.ClimateZoneType;
import com.ferreusveritas.dynamictrees.api.seasons.ISeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.seasons.ISeasonProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SeasonContext {
    private ISeasonProvider provider;
    private ISeasonGrowthCalculator calculator;
    private float temperateGrowthFactor;
    private float tropicalGrowthFactor;
    private float temperateSeedDropFactor;
    private float tropicalSeedDropFactor;
    private float temperateFruitProductionFactor;
    private float tropicalFruitProductionFactor;
    private Float seasonValue;
    private long methodTicks = 0L;

    public SeasonContext(ISeasonProvider provider, ISeasonGrowthCalculator calculator) {
        this.provider = provider;
        this.calculator = calculator;
    }

    public void updateTick(World world, long worldTicks) {
        if (this.methodTicks % 20L == 0L) {
            this.provider.updateTick(world, worldTicks);
            this.seasonValue = this.provider.getSeasonValue(world, BlockPos.field_177992_a);
            this.temperateGrowthFactor = this.calculator.calcGrowthRate(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalGrowthFactor = this.calculator.calcGrowthRate(this.seasonValue, ClimateZoneType.TROPICAL);
            this.temperateSeedDropFactor = this.calculator.calcSeedDropRate(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalSeedDropFactor = this.calculator.calcSeedDropRate(this.seasonValue, ClimateZoneType.TROPICAL);
            this.temperateFruitProductionFactor = this.calculator.calcFruitProduction(this.seasonValue, ClimateZoneType.TEMPERATE);
            this.tropicalFruitProductionFactor = this.calculator.calcFruitProduction(this.seasonValue, ClimateZoneType.TROPICAL);
        }
        ++this.methodTicks;
    }

    public ISeasonProvider getSeasonProvider() {
        return this.provider;
    }

    public ISeasonGrowthCalculator getCalculator() {
        return this.calculator;
    }

    public float getTemperateGrowthFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateGrowthFactor : this.calculator.calcGrowthRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalGrowthFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalGrowthFactor : this.calculator.calcGrowthRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }

    public float getTemperateSeedDropFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateSeedDropFactor : this.calculator.calcSeedDropRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalSeedDropFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalSeedDropFactor : this.calculator.calcSeedDropRate(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }

    public float getTemperateFruitProductionFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.temperateFruitProductionFactor : this.calculator.calcFruitProduction(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TEMPERATE);
    }

    public float getTropicalFruitProductionFactor(float offset) {
        return offset == 0.0f || this.seasonValue == null ? this.tropicalFruitProductionFactor : this.calculator.calcFruitProduction(Float.valueOf(this.seasonValue.floatValue() + offset), ClimateZoneType.TROPICAL);
    }
}

