/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.command.SubCommand;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CommandSoilLife
extends SubCommand {
    public static final String SOILLIFE = "soillife";

    @Override
    public String getName() {
        return SOILLIFE;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 2: 
            case 3: 
            case 4: {
                return CommandBase.func_175771_a((String[])args, (int)1, (BlockPos)targetPos);
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    @Override
    public void execute(World world, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 4) {
            throw new WrongUsageException("commands.dynamictrees.soillife.usage", new Object[0]);
        }
        BlockPos pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)1, (boolean)false);
        BlockPos rootPos = TreeHelper.findRootNode(world.func_180495_p(pos), world, pos);
        if (rootPos != BlockPos.field_177992_a) {
            IBlockState state = world.func_180495_p(rootPos);
            if (args.length >= 5) {
                int life = 0;
                try {
                    life = Integer.parseInt(args[4]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException("commands.dynamictrees.soillife.lifeerror", new Object[]{args[4]});
                }
                TreeHelper.getRooty(state).setSoilLife(world, rootPos, life);
            } else {
                int life = TreeHelper.getRooty(state).getSoilLife(state, (IBlockAccess)world, rootPos);
                sender.func_145747_a((ITextComponent)new TextComponentString("" + life));
            }
        } else {
            throw new CommandException("commands.dynamictrees.soillife.notreeerror", new Object[]{pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p()});
        }
    }
}

