/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public abstract class CommandChunkBased
extends SubCommand {
    @Override
    public abstract String getName();

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 2: 
            case 3: {
                return CommandChunkBased.getTabCompletionCoordinate(args, 1, targetPos);
            }
            case 4: {
                return Lists.newArrayList((Object[])new String[]{Integer.toString(0)});
            }
        }
        return super.getTabCompletions(server, sender, args, targetPos);
    }

    @Override
    public void execute(World world, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1 && args.length != 3 && args.length != 4) {
            throw new WrongUsageException("commands.dynamictrees.killtree.usage", new Object[0]);
        }
        ChunkPos cPos = null;
        if (args.length >= 3) {
            BlockPos blockpos = sender.func_180425_c();
            cPos = new ChunkPos((int)CommandBase.func_175769_b((double)(blockpos.func_177958_n() >> 4), (String)args[1], (int)-1875000, (int)1875000, (boolean)false), (int)CommandBase.func_175769_b((double)(blockpos.func_177952_p() >> 4), (String)args[2], (int)-1875000, (int)1875000, (boolean)false));
        } else if (args.length == 1 && sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            cPos = new ChunkPos(player.func_180425_c());
        }
        int radius = 0;
        if (args.length == 4) {
            radius = CommandBase.func_175755_a((String)args[3]);
        }
        this.processChunk(world, cPos, radius);
    }

    public static List<String> getTabCompletionCoordinate(String[] inputArgs, int index, @Nullable BlockPos pos) {
        int v;
        if (pos == null) {
            return Lists.newArrayList((Object[])new String[]{"~"});
        }
        switch (inputArgs.length - index - 1) {
            case 0: {
                v = pos.func_177958_n();
                break;
            }
            case 1: {
                v = pos.func_177952_p();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        return Lists.newArrayList((Object[])new String[]{Integer.toString(v >> 4)});
    }

    abstract void processChunk(World var1, ChunkPos var2, int var3);
}

