/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.cells.CellMetadata;
import com.ferreusveritas.dynamictrees.entities.EntityFallingTree;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BlockBranchBasic
extends BlockBranch {
    private int flammability = 5;
    private int fireSpreadSpeed = 5;
    protected static final PropertyInteger RADIUS = PropertyInteger.func_177719_a((String)"radius", (int)1, (int)8);
    protected IBlockState[] branchStates;

    public BlockBranchBasic(String name) {
        this(Material.field_151575_d, name);
    }

    public BlockBranchBasic(Material material, String name) {
        super(material, name);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.cacheBranchStates();
    }

    public void cacheBranchStates() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(1)));
        this.branchStates = new IBlockState[9];
        this.branchStates[0] = Blocks.field_150350_a.func_176223_P();
        for (int radius = 1; radius <= 8; ++radius) {
            this.branchStates[radius] = this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf(radius));
        }
    }

    @Override
    public IProperty<?>[] getIgnorableProperties() {
        return new IProperty[]{RADIUS};
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{RADIUS};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)RADIUS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)RADIUS) - 1;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.getSideConnectionRadius(world, pos, thisRadius, dir));
            }
            return retval;
        }
        return state;
    }

    @Override
    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return this.isSameTree(branch) ? BlockBranchBasic.setSupport(1, 1) : 0;
    }

    @Override
    public boolean canFall() {
        return true;
    }

    @Override
    public boolean checkForRot(World world, BlockPos pos, Species species, int radius, Random rand, float chance, boolean rapid) {
        if (!rapid && (chance == 0.0f || rand.nextFloat() > chance)) {
            return false;
        }
        int neigh = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos deltaPos = pos.func_177972_a(dir);
            IBlockState deltaBlockState = world.func_180495_p(deltaPos);
            if (BlockBranchBasic.getBranchSupport(neigh += TreeHelper.getTreePart(deltaBlockState).branchSupport(deltaBlockState, (IBlockAccess)world, this, deltaPos, dir, radius)) < 1 || BlockBranchBasic.getLeavesSupport(neigh) < 2) continue;
            return false;
        }
        boolean didRot = species.rot(world, pos, neigh & 0xF, radius, rand, rapid);
        if (rapid && didRot) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos neighPos = pos.func_177972_a(dir);
                IBlockState neighState = world.func_180495_p(neighPos);
                if (neighState.func_177230_c() != this) continue;
                this.checkForRot(world, neighPos, species, this.getRadius(neighState), rand, 1.0f, true);
            }
        }
        return didRot;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(blockState);
        float hardness = this.getFamily().getPrimitiveLog().func_177230_c().func_176195_g(blockState, world, pos) * (float)(radius * radius) / 64.0f * 8.0f;
        hardness = Math.min(hardness, ModConfigs.maxTreeHardness);
        return hardness;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        int radius = this.getRadius(world.func_180495_p(pos));
        return this.fireSpreadSpeed * radius / 8;
    }

    public BlockBranchBasic setFlammability(int flammability) {
        this.flammability = flammability;
        return this;
    }

    public BlockBranchBasic setFireSpreadSpeed(int fireSpreadSpeed) {
        this.fireSpreadSpeed = fireSpreadSpeed;
        return this;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return this.getRadius(state) == 8;
    }

    @Override
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRadius(blockState) != 8 || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, ILeavesProperties leavesProperties) {
        TreeFamily thisTree = this.getFamily();
        if (leavesProperties.getTree() == thisTree) {
            int radiusAndMeta = thisTree.getRadiusForCellKit(blockAccess, pos, blockState, dir, this);
            int radius = CellMetadata.getRadius(radiusAndMeta);
            int metadata = CellMetadata.getMeta(radiusAndMeta);
            return leavesProperties.getCellKit().getCellForBranch(radius, metadata);
        }
        return CellNull.NULLCELL;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return blockState.func_177230_c() == this ? (Integer)blockState.func_177229_b((IProperty)RADIUS) : 0;
    }

    @Override
    public int setRadius(World world, BlockPos pos, int radius, EnumFacing originDir, int flags) {
        destroyMode = BlockBranch.EnumDestroyMode.SETRADIUS;
        world.func_180501_a(pos, this.getStateForRadius(radius), flags);
        destroyMode = BlockBranch.EnumDestroyMode.SLOPPY;
        return radius;
    }

    @Override
    public IBlockState getStateForRadius(int radius) {
        return this.branchStates[MathHelper.func_76125_a((int)radius, (int)0, (int)this.getMaxRadius())];
    }

    @Override
    public int probabilityForBlock(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return this.isSameTree(from) ? this.getRadius(blockState) + 2 : 0;
    }

    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
        Species species = signal.getSpecies();
        BlockDynamicLeaves leaves = TreeHelper.getLeaves(species.getLeavesProperties().getDynamicLeavesState());
        if (leaves != null) {
            if (fromRadius == 1) {
                signal.success = leaves.growLeavesIfLocationIsSuitable(world, species.getLeavesProperties(), pos, 0);
            } else {
                return leaves.branchOut(world, pos, signal);
            }
        }
        return signal;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            IBlockState currBlockState = world.func_180495_p(pos);
            Species species = signal.getSpecies();
            boolean inTrunk = signal.isInTrunk();
            EnumFacing originDir = signal.dir.func_176734_d();
            EnumFacing targetDir = species.selectNewDirection(world, pos, this, signal);
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.func_177972_a(targetDir);
            EnumFacing[] deltaState = world.func_180495_p(deltaPos);
            ITreePart treepart = TreeHelper.getTreePart((IBlockState)deltaState);
            if (treepart != TreeHelper.nullTreePart) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.func_175623_d(deltaPos) || deltaState.func_177230_c() == ModBlocks.blockTrunkShell) {
                signal = this.growIntoAir(world, deltaPos, signal, this.getRadius(currBlockState));
            }
            float areaAccum = signal.radius * signal.radius;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos deltaPos2;
                IBlockState blockState;
                ITreePart treepart2;
                if (dir.equals((Object)originDir) || dir.equals((Object)targetDir) || !this.isSameTree(treepart2 = TreeHelper.getTreePart(blockState = world.func_180495_p(deltaPos2 = pos.func_177972_a(dir))))) continue;
                int branchRadius = treepart2.getRadius(blockState);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (!signal.choked) {
                int maxRadius = inTrunk ? species.maxBranchRadius() : Math.min(species.maxBranchRadius(), 8);
                signal.radius = MathHelper.func_76131_a((float)((float)Math.sqrt(areaAccum) + species.getTapering()), (float)this.getRadius(currBlockState), (float)maxRadius);
                int targetRadius = (int)Math.floor(signal.radius);
                int setRad = this.setRadius(world, pos, targetRadius, originDir);
                if (setRad < targetRadius) {
                    signal.choked = true;
                }
            }
        }
        return signal;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return ModConfigs.enableBranchClimbling && this.getRadius(state) <= 3;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return field_185506_k;
        }
        int thisRadius = this.getRadius(state);
        boolean connectionMade = false;
        double radius = (double)thisRadius / 16.0;
        double gap = 0.5 - radius;
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.getSideConnectionRadius(blockAccess, pos, thisRadius, dir) <= 0) continue;
            connectionMade = true;
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
        }
        if (connectionMade) {
            return aabb.func_72317_d(0.5, 0.5, 0.5);
        }
        return new AxisAlignedBB(0.5 - radius, 0.5 - radius, 0.5 - radius, 0.5 + radius, 0.5 + radius, 0.5 + radius);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (entityIn instanceof EntityFallingTree) {
            return;
        }
        boolean hasConnections = false;
        int thisRadius = this.getRadius(state);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = this.getSideConnectionRadius((IBlockAccess)world, pos, thisRadius, dir);
            if (connRadius <= 0) continue;
            hasConnections = true;
            double radius = (double)MathHelper.func_76125_a((int)connRadius, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            BlockBranchBasic.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
        if (!hasConnections) {
            AxisAlignedBB aabb = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5).func_186662_g((double)thisRadius);
            BlockBranchBasic.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess world, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return this.getRadius(blockState);
    }

    protected int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        IBlockState blockState = blockAccess.func_180495_p(deltaPos);
        return TreeHelper.getTreePart(blockState).getRadiusForConnection(blockState, blockAccess, deltaPos, this, side, radius);
    }

    protected int getMaxSignalDepth() {
        return 32;
    }

    @Override
    public MapSignal analyse(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        if (signal.overflow || signal.trackVisited && signal.doTrackingVisited(pos)) {
            return signal;
        }
        if (signal.depth++ < this.getMaxSignalDepth()) {
            signal.run(blockState, world, pos, fromDir);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos deltaPos;
                IBlockState deltaState;
                ITreePart treePart;
                if (dir == fromDir || !(treePart = TreeHelper.getTreePart(deltaState = world.func_180495_p(deltaPos = pos.func_177972_a(dir)))).shouldAnalyse()) continue;
                signal = treePart.analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                if (!signal.found || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            IBlockState state = world.func_180495_p(pos);
            if (signal.destroyLoopedNodes && state.func_177230_c() instanceof BlockBranch) {
                BlockBranch branch = (BlockBranch)state.func_177230_c();
                branch.breakDeliberate(world, pos, BlockBranch.EnumDestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }
}

