/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tfcompat.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.PrecipitatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import mrthomas20121.tfcompat.library.recipes.RecipeCore;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.recipes.quern.QuernRecipe;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.blocks.wood.BlockDoorTFC;
import net.dries007.tfc.objects.blocks.wood.BlockFenceGateTFC;
import net.dries007.tfc.objects.blocks.wood.BlockFenceTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.blocks.wood.BlockPlanksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockTrapDoorWoodTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.wood.ItemLumberTFC;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistry;
import tfctech.objects.items.TechItems;

public class ThermalExpansionRecipes
implements RecipeCore {
    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> r) {
        this.barrelStillRecipes();
        this.extruderRecipes();
        this.precipiratorRecipes();
        this.pulverizerRecipes();
        this.sawmillRecipes();
        this.redstoneFurnaceRecipes();
    }

    private void barrelStillRecipes() {
        RefineryManager.RefineryRecipe[] recipes;
        for (RefineryManager.RefineryRecipe recipe : recipes = RefineryManager.getRecipeList()) {
            FluidStack input = recipe.getInput();
            FluidStack output = recipe.getOutputFluid();
            ItemStack outputItem = recipe.getOutputItem();
            TFCRegistries.BARREL.register(new BarrelRecipe(IIngredient.of((FluidStack)input), IIngredient.of((ItemStack)ItemStack.field_190927_a), output, outputItem.func_190926_b() ? ItemStack.field_190927_a : outputItem, 1464000).setRegistryName("still_" + input.getFluid().getName()));
        }
    }

    private void extruderRecipes() {
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            ExtruderManager.addRecipeIgneous((int)1000, (ItemStack)new ItemStack((Block)BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.RAW)), (FluidStack)FluidRegistry.getFluidStack((String)"lava", (int)1000), (FluidStack)FluidRegistry.getFluidStack((String)"fresh_water", (int)1000));
            ExtruderManager.addRecipeSedimentary((int)1000, (ItemStack)new ItemStack((Block)BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.SAND)), (FluidStack)FluidRegistry.getFluidStack((String)"lava", (int)1000), (FluidStack)FluidRegistry.getFluidStack((String)"fresh_water", (int)1000));
        }
    }

    private void precipiratorRecipes() {
        PrecipitatorManager.addRecipe((int)800, (ItemStack)new ItemStack(Items.field_151126_ay, 4), (FluidStack)this.getFluid("fresh_water", 500));
        PrecipitatorManager.addRecipe((int)800, (ItemStack)new ItemStack(Blocks.field_150433_aE, 1), (FluidStack)this.getFluid("fresh_water", 500));
        PrecipitatorManager.addRecipe((int)800, (ItemStack)new ItemStack(Blocks.field_150431_aC, 2), (FluidStack)this.getFluid("fresh_water", 500));
        PrecipitatorManager.addRecipe((int)1600, (ItemStack)new ItemStack(Blocks.field_150432_aD, 1), (FluidStack)this.getFluid("fresh_water", 1000));
        PrecipitatorManager.addRecipe((int)1600, (ItemStack)new ItemStack(Blocks.field_150403_cj, 1), (FluidStack)this.getFluid("fresh_water", 1000));
        PrecipitatorManager.addRecipe((int)1600, (ItemStack)new ItemStack((Block)BlocksTFC.SEA_ICE, 1), (FluidStack)this.getFluid("salt_water", 1000));
    }

    private void sawmillRecipes() {
        for (Tree tree : TFCRegistries.TREES.getValuesCollection()) {
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockLogTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 8), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockPlanksTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 3), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockDoorTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 4), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockTrapDoorWoodTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 4), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockFenceTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 3), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
            SawmillManager.addRecipe((int)1000, (ItemStack)this.getStack((Block)BlockFenceGateTFC.get((Tree)tree), 1), (ItemStack)this.getStack((Item)ItemLumberTFC.get((Tree)tree), 4), (ItemStack)this.getStack((Item)TechItems.WOOD_POWDER, 1), (int)20);
        }
    }

    private void redstoneFurnaceRecipes() {
        for (HeatRecipe heatRecipe : TFCRegistries.HEAT.getValuesCollection()) {
            NonNullList r = heatRecipe.getIngredients();
            if (r.size() <= 0) continue;
            NonNullList ingredient = ((IIngredient)r.get(0)).getValidIngredients();
            FurnaceManager.addRecipe((int)1000, (ItemStack)((ItemStack)ingredient.get(0)), (ItemStack)((ItemStack)heatRecipe.getOutputs().get(0)));
        }
    }

    private void pulverizerRecipes() {
        PulverizerManager.PulverizerRecipe[] recipes = PulverizerManager.getRecipeList();
        for (PulverizerManager.PulverizerRecipe pulverizerRecipe : recipes) {
            PulverizerManager.removeRecipe((ItemStack)pulverizerRecipe.getInput());
        }
        for (QuernRecipe recipe : TFCRegistries.QUERN.getValuesCollection()) {
            NonNullList ingredient = recipe.getIngredients();
            NonNullList outputs = recipe.getOutputs();
            ItemStack output = (ItemStack)outputs.get(0);
            NonNullList stacks = ((IIngredient)ingredient.get(0)).getValidIngredients();
            PulverizerManager.addRecipe((int)1000, (ItemStack)((ItemStack)stacks.get(0)), (ItemStack)output, (ItemStack)output, (int)10);
        }
    }
}

