/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tfcompat.compat.pyrotech;

import com.codetaylor.mc.pyrotech.PyrotechAPI;
import com.codetaylor.mc.pyrotech.modules.bucket.ModuleBucket;
import com.codetaylor.mc.pyrotech.modules.core.item.ItemMaterial;
import com.codetaylor.mc.pyrotech.modules.tech.basic.ModuleTechBasic;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.AnvilRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.CompactingBinRecipe;
import com.codetaylor.mc.pyrotech.modules.tech.basic.recipe.SoakingPotRecipe;
import com.codetaylor.mc.pyrotech.modules.tool.ModuleTool;
import mrthomas20121.rocksalt.utils.CraftingUtils;
import mrthomas20121.tfcompat.library.helpers.HeatHelper;
import mrthomas20121.tfcompat.library.recipes.IHeatRecipe;
import mrthomas20121.tfcompat.library.recipes.IKnappingRecipe;
import mrthomas20121.tfcompat.library.recipes.IRecipeRemoval;
import mrthomas20121.tfcompat.library.recipes.RecipeCore;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipeSimple;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipeSimple;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.blocks.BlockSlabTFC;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.items.rock.ItemBrickTFC;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import tfctech.objects.items.TechItems;

public class PyrotechRecipes
implements RecipeCore,
IRecipeRemoval,
IHeatRecipe,
IKnappingRecipe {
    public void init(FMLInitializationEvent event) {
        this.registerHammers();
        HeatHelper.addItemHeat(ItemMaterial.EnumType.UNFIRED_REFRACTORY_BRICK.asStack(), 600, 580);
        HeatHelper.addItemHeat(new ItemStack((Item)ModuleBucket.Items.BUCKET_CLAY_UNFIRED), 1500, 1700);
        HeatHelper.addItemHeat(new ItemStack((Item)ModuleTool.Items.UNFIRED_CLAY_SHEARS), 1500, 1700);
    }

    @Override
    public void initHeatRecipes(IForgeRegistry<HeatRecipe> r) {
        r.register(new HeatRecipeSimple(IIngredient.of((ItemStack)ItemMaterial.EnumType.UNFIRED_REFRACTORY_BRICK.asStack()), ItemMaterial.EnumType.REFRACTORY_BRICK.asStack(), 480.0f).setRegistryName(new ResourceLocation("tfcompat", "unfired_refractory_brick")));
        r.register(new HeatRecipeSimple(IIngredient.of((Item)ModuleBucket.Items.BUCKET_CLAY_UNFIRED), new ItemStack((Item)ModuleBucket.Items.BUCKET_CLAY, 1), 1500.0f).setRegistryName(new ResourceLocation("tfcompat", "unfired_clay_bucket")));
        r.register(new HeatRecipeSimple(IIngredient.of((Item)ModuleTool.Items.UNFIRED_CLAY_SHEARS), new ItemStack((Item)ModuleTool.Items.CLAY_SHEARS, 1), 1500.0f).setRegistryName(new ResourceLocation("tfcompat", "unfired_clay_shears")));
    }

    @Override
    public void initKnappingRecipes(IForgeRegistry<KnappingRecipe> r) {
        r.register(new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)ModuleBucket.Items.BUCKET_CLAY_UNFIRED), new String[]{"X   X", "X   X", "X   X", "XX XX", "  X  "}).setRegistryName("pyrotech_unfired_clay_bucket"));
        r.register(new KnappingRecipeSimple(KnappingType.CLAY, true, new ItemStack((Item)ModuleTool.Items.UNFIRED_CLAY_SHEARS), new String[]{"XX  X", "X  X ", " XX  ", " XX X", "X  XX"}).setRegistryName("pyrotech_unfired_clay_shears"));
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> r) {
        this.AnvilRecipes((IForgeRegistryModifiable<AnvilRecipe>)ModuleTechBasic.Registries.ANVIL_RECIPE);
        this.SoakingPotRecipes((IForgeRegistryModifiable<SoakingPotRecipe>)ModuleTechBasic.Registries.SOAKING_POT_RECIPE);
        this.CompactingBinRecipes((IForgeRegistryModifiable<CompactingBinRecipe>)ModuleTechBasic.Registries.COMPACTING_BIN_RECIPE);
    }

    @Override
    public void removal(IForgeRegistry<IRecipe> r) {
        CraftingUtils.removeRecipe(r, (ResourceLocation)new ResourceLocation("pyrotech:bucket/bucket_clay_unfired"));
        CraftingUtils.removeRecipe(r, (ResourceLocation)new ResourceLocation("pyrotech:tool/unfired_clay_shears"));
    }

    private void registerHammers() {
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (!metal.isToolMetal()) continue;
            Item hammer = ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.HAMMER);
            PyrotechAPI.registerHammer((Item)hammer, (int)metal.getToolMetal().func_77996_d());
        }
    }

    private void CompactingBinRecipes(IForgeRegistryModifiable<CompactingBinRecipe> r) {
        r.register((IForgeRegistryEntry)PyrotechRecipes.createBinRecipe("tfc_fire_clay", this.getStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("tfc:fire_clay_block")), 1), this.getStack(ItemsTFC.FIRE_CLAY, 4), 4));
        r.register((IForgeRegistryEntry)PyrotechRecipes.createBinRecipe("tfc_thatch", this.getStack((Block)BlocksTFC.THATCH, 1), this.getStack((Item)ItemsTFC.STRAW, 4), 4));
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            ItemRock itemRock = ItemRock.get((Rock)rock);
            BlockRockVariant gravel = BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.GRAVEL);
            r.register((IForgeRegistryEntry)PyrotechRecipes.createBinRecipe("tfc_" + rock.getRegistryName().func_110623_a() + "_" + Rock.Type.GRAVEL.name(), this.getStack((Block)gravel, 1), this.getStack((Item)itemRock, 8), 4));
        }
    }

    private void AnvilRecipes(IForgeRegistryModifiable<AnvilRecipe> r) {
        for (Rock rock : TFCRegistries.ROCKS.getValuesCollection()) {
            ItemRock itemRock = ItemRock.get((Rock)rock);
            BlockRockVariant smooth = BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.SMOOTH);
            BlockRockVariant cobble = BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.COBBLE);
            BlockRockVariant brick = BlockRockVariant.get((Rock)rock, (Rock.Type)Rock.Type.BRICKS);
            BlockSlabTFC.Half cobbleSlab = BlockSlabTFC.Half.get((Rock)rock, (Rock.Type)Rock.Type.COBBLE);
            BlockSlabTFC.Half smoothSlab = BlockSlabTFC.Half.get((Rock)rock, (Rock.Type)Rock.Type.SMOOTH);
            BlockSlabTFC.Half brickSlab = BlockSlabTFC.Half.get((Rock)rock, (Rock.Type)Rock.Type.BRICKS);
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("cobble_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)cobbleSlab, 2), this.getStack((Block)cobble, 1), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_cobble_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)cobbleSlab, 2), this.getStack((Block)cobble, 1), 7, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.IRONCLAD));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("smooth_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)smoothSlab, 2), this.getStack((Block)smooth, 1), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_smooth_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)smoothSlab, 2), this.getStack((Block)smooth, 1), 7, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.IRONCLAD));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("brick_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)brickSlab, 2), this.getStack((Block)brick, 1), 8, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_brick_slab_" + rock.getRegistryName().func_110623_a(), this.getStack((Block)brickSlab, 2), this.getStack((Block)brick, 1), 7, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.IRONCLAD));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("refractory_brick_" + rock.getRegistryName().func_110623_a(), ItemMaterial.EnumType.BRICK_STONE.asStack(2), this.getStack((Block)brickSlab, 2), 4, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.GRANITE));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_refractory_brick_" + rock.getRegistryName().func_110623_a(), ItemMaterial.EnumType.BRICK_STONE.asStack(2), this.getStack((Block)brickSlab, 1), 4, AnvilRecipe.EnumType.PICKAXE, AnvilRecipe.EnumTier.IRONCLAD));
            for (Rock.Type type : Rock.Type.values()) {
                ItemBrickTFC brickTFC;
                if (type == Rock.Type.DIRT || type == Rock.Type.ANVIL || type == Rock.Type.DRY_GRASS || type == Rock.Type.FARMLAND || type == Rock.Type.PATH || type == Rock.Type.SAND || type == Rock.Type.GRASS || type == Rock.Type.SPIKE) continue;
                BlockRockVariant variant = BlockRockVariant.get((Rock)rock, (Rock.Type)type);
                if (type == Rock.Type.BRICKS) {
                    brickTFC = ItemBrickTFC.get((Rock)rock);
                    r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe(rock.getRegistryName().func_110623_a() + "_from_" + type.name(), this.getStack((Item)brickTFC, 4), this.getStack((Block)variant, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE));
                    r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_" + rock.getRegistryName().func_110623_a() + "_from_" + type.name(), this.getStack((Item)brickTFC, 5), this.getStack((Block)variant, 1), 7, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.IRONCLAD));
                    continue;
                }
                if (type == Rock.Type.CLAY || type == Rock.Type.CLAY_GRASS) {
                    brickTFC = ItemBrickTFC.get((Rock)rock);
                    r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe(rock.getRegistryName().func_110623_a() + "_" + type.name(), this.getStack(Items.field_151119_aD, 4), this.getStack((Block)variant, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE));
                    r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_" + rock.getRegistryName().func_110623_a() + "_" + type.name(), this.getStack(Items.field_151119_aD, 4), this.getStack((Block)variant, 1), 7, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.IRONCLAD));
                    continue;
                }
                r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe(rock.getRegistryName().func_110623_a() + "_from_" + type.name(), this.getStack((Item)itemRock, 6), this.getStack((Block)variant, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.GRANITE));
                r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe("ironclad_" + rock.getRegistryName().func_110623_a() + "_from_" + type.name(), this.getStack((Item)itemRock, 6), this.getStack((Block)variant, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.IRONCLAD));
            }
        }
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (PyrotechRecipes.checkMetal(metal)) continue;
            Item double_ingot = ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.DOUBLE_INGOT);
            Item ingot = ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.INGOT);
            Item double_sheet = ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.DOUBLE_SHEET);
            Item sheet = ItemMetal.get((Metal)metal, (Metal.ItemType)Metal.ItemType.SHEET);
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe(metal.getRegistryName().func_110623_a() + "_ingot_tfc", this.getStack(ingot, 2), this.getStack(double_ingot, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.IRONCLAD));
            r.register((IForgeRegistryEntry)PyrotechRecipes.createAnvilRecipe(metal.getRegistryName().func_110623_a() + "_sheet_tfc", this.getStack(sheet, 2), this.getStack(double_sheet, 1), 8, AnvilRecipe.EnumType.HAMMER, AnvilRecipe.EnumTier.IRONCLAD));
        }
    }

    private void SoakingPotRecipes(IForgeRegistryModifiable<SoakingPotRecipe> r) {
        r.register((IForgeRegistryEntry)PyrotechRecipes.createSoakingPotRecipe("tfc_tech_slaked_lime", ItemMaterial.EnumType.SLAKED_LIME.asStack(1), Ingredient.func_193367_a((Item)TechItems.LIME), this.getFluid("fresh_water", 125), 7));
    }

    private static CompactingBinRecipe createBinRecipe(String registryName, ItemStack output, ItemStack input, int time) {
        CompactingBinRecipe recipe = new CompactingBinRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), time);
        recipe.setRegistryName(registryName);
        return recipe;
    }

    private static AnvilRecipe createAnvilRecipe(String registryName, ItemStack output, ItemStack input, int hit, AnvilRecipe.EnumType type, AnvilRecipe.EnumTier tier) {
        AnvilRecipe recipe = new AnvilRecipe(output, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), hit, type, tier);
        recipe.setRegistryName("tfcompat", registryName);
        return recipe;
    }

    private static SoakingPotRecipe createSoakingPotRecipe(String registryName, ItemStack output, Ingredient inputItem, FluidStack inputFluid, int timeTicks) {
        SoakingPotRecipe recipe = new SoakingPotRecipe(output, inputItem, inputFluid, timeTicks);
        recipe.setRegistryName(registryName);
        return recipe;
    }

    private static boolean checkMetal(Metal metal) {
        String metal_name = metal.getRegistryName().func_110623_a();
        String[] metalsExtrusion = new String[]{"unknown", "high_carbon_steel", "high_carbon_red_steel", "high_carbon_blue_steel", "high_carbon_black_steel", "weak_steel", "weak_blue_steel", "weak_red_steel", "weak_black_steel"};
        boolean res = false;
        for (String m : metalsExtrusion) {
            if (!metal_name.contains(m)) continue;
            res = true;
            break;
        }
        return res;
    }
}

