/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.rocksalt.utils;

import javax.annotation.Nonnull;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidUtils {
    private static final ResourceLocation STILL = new ResourceLocation("tfc", "blocks/fluid_still");
    private static final ResourceLocation FLOW = new ResourceLocation("tfc", "blocks/fluid_flow");
    private static final ResourceLocation LAVA_STILL = new ResourceLocation("tfc", "blocks/lava_still");
    private static final ResourceLocation LAVA_FLOW = new ResourceLocation("tfc", "blocks/lava_flow");

    private static FluidWrapper registerFluid(@Nonnull Fluid newFluid) {
        boolean isDefault = FluidRegistry.registerFluid((Fluid)newFluid);
        if (!isDefault) {
            newFluid = FluidRegistry.getFluid((String)newFluid.getName());
        }
        FluidRegistry.addBucketForFluid((Fluid)newFluid);
        return new FluidWrapper(newFluid, isDefault);
    }

    private static FluidWrapper getFluid(String fluidName, ResourceLocation still, ResourceLocation flow, int color) {
        return FluidUtils.registerFluid(new Fluid(fluidName, still, flow, color));
    }

    private static FluidWrapper getFluid(String fluidName, ResourceLocation still, ResourceLocation flow, int color, EnumRarity rarity) {
        return FluidUtils.registerFluid(new Fluid(fluidName, still, flow, color).setRarity(rarity));
    }

    public static FluidWrapper registerLiquid(String fluidName, int color) {
        return FluidUtils.getFluid(fluidName, STILL, FLOW, color);
    }

    public static FluidWrapper registerLiquid(String fluidName, int color, EnumRarity rarity) {
        return FluidUtils.getFluid(fluidName, STILL, FLOW, color, rarity);
    }

    public static FluidWrapper registerMolten(String fluidName, int color) {
        return FluidUtils.getFluid(fluidName, LAVA_STILL, LAVA_FLOW, color);
    }

    public static FluidWrapper registerMolten(String fluidName, int color, EnumRarity rarity) {
        return FluidUtils.getFluid(fluidName, LAVA_STILL, LAVA_FLOW, color, rarity);
    }
}

