/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.rocksalt.types;

import net.dries007.tfc.api.types.IFruitTree;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RocksaltFruitTree
implements IFruitTree {
    private final String name;
    private final Food fruit;
    private final Month flowerMonthStart;
    private final int floweringMonths;
    private final Month harvestMonthStart;
    private final int harvestingMonths;
    private final float growthTime;
    private final float minTemp;
    private final float maxTemp;
    private final float minRain;
    private final float maxRain;

    RocksaltFruitTree(String name, Food fruit, Month flowerMonthStart, int floweringMonths, Month harvestMonthStart, int harvestingMonths, float minTemp, float maxTemp, float minRain, float maxRain, float growthTime) {
        this.name = name;
        this.fruit = fruit;
        this.flowerMonthStart = flowerMonthStart;
        this.floweringMonths = floweringMonths;
        this.harvestMonthStart = harvestMonthStart;
        this.harvestingMonths = harvestingMonths;
        this.growthTime = growthTime * (float)CalendarTFC.CALENDAR_TIME.getDaysInMonth() * 24.0f;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minRain = minRain;
        this.maxRain = maxRain;
    }

    public Food getFruit() {
        return this.fruit;
    }

    public float getGrowthTime() {
        return this.growthTime;
    }

    public boolean isFlowerMonth(Month month) {
        Month testing = this.flowerMonthStart;
        for (int i = 0; i < this.floweringMonths; ++i) {
            if (testing.equals((Object)month)) {
                return true;
            }
            testing = testing.next();
        }
        return false;
    }

    public boolean isHarvestMonth(Month month) {
        Month testing = this.harvestMonthStart;
        for (int i = 0; i < this.harvestingMonths; ++i) {
            if (testing.equals((Object)month)) {
                return true;
            }
            testing = testing.next();
        }
        return false;
    }

    public boolean isValidConditions(float temperature, float rainfall) {
        return this.minTemp - 5.0f < temperature && temperature < this.maxTemp + 5.0f && this.minRain - 50.0f < rainfall && rainfall < this.maxRain + 50.0f;
    }

    public boolean isValidForGrowth(float temperature, float rainfall) {
        return this.minTemp < temperature && temperature < this.maxTemp && this.minRain < rainfall && rainfall < this.maxRain;
    }

    public ItemStack getFoodDrop() {
        return new ItemStack((Item)ItemFoodTFC.get((Food)this.getFruit()));
    }

    public String getName() {
        return this.name;
    }
}

